/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Queues;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Deque;
import javax.annotation.Nullable;

public final class SequencedPriorityIterator<T>
extends AbstractIterator<T> {
    private static final int MIN_PRIO = Integer.MIN_VALUE;
    @Nullable
    private Deque<T> highestPrioQueue = null;
    private int highestPrio = Integer.MIN_VALUE;
    private final Int2ObjectMap<Deque<T>> queuesByPriority = new Int2ObjectOpenHashMap();

    public void add(T p_309040_, int p_308964_) {
        if (p_308964_ == this.highestPrio && this.highestPrioQueue != null) {
            this.highestPrioQueue.addLast(p_309040_);
        } else {
            Deque deque = (Deque)this.queuesByPriority.computeIfAbsent(p_308964_, p_308896_ -> Queues.newArrayDeque());
            deque.addLast(p_309040_);
            if (p_308964_ >= this.highestPrio) {
                this.highestPrioQueue = deque;
                this.highestPrio = p_308964_;
            }
        }
    }

    @Nullable
    protected T computeNext() {
        if (this.highestPrioQueue == null) {
            return (T)this.endOfData();
        }
        T t = this.highestPrioQueue.removeFirst();
        if (t == null) {
            return (T)this.endOfData();
        }
        if (this.highestPrioQueue.isEmpty()) {
            this.switchCacheToNextHighestPrioQueue();
        }
        return t;
    }

    private void switchCacheToNextHighestPrioQueue() {
        int i = Integer.MIN_VALUE;
        Deque deque = null;
        for (Int2ObjectMap.Entry entry : Int2ObjectMaps.fastIterable(this.queuesByPriority)) {
            Deque deque1 = (Deque)entry.getValue();
            int j = entry.getIntKey();
            if (j <= i || deque1.isEmpty()) continue;
            i = j;
            deque = deque1;
            if (j != this.highestPrio - 1) continue;
            break;
        }
        this.highestPrio = i;
        this.highestPrioQueue = deque;
    }
}

