/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceKey;
import org.slf4j.Logger;

public interface ProblemReporter {
    public static final ProblemReporter DISCARDING = new ProblemReporter(){

        @Override
        public ProblemReporter forChild(PathElement p_422462_) {
            return this;
        }

        @Override
        public void report(Problem p_422437_) {
        }
    };

    public ProblemReporter forChild(PathElement var1);

    public void report(Problem var1);

    public static class ScopedCollector
    extends Collector
    implements AutoCloseable {
        private final Logger logger;

        public ScopedCollector(Logger p_421960_) {
            this.logger = p_421960_;
        }

        public ScopedCollector(PathElement p_421607_, Logger p_421775_) {
            super(p_421607_);
            this.logger = p_421775_;
        }

        @Override
        public void close() {
            if (!this.isEmpty()) {
                this.logger.warn("[{}] Serialization errors:\n{}", (Object)this.logger.getName(), (Object)this.getTreeReport());
            }
        }
    }

    public record RootFieldPathElement(String name) implements PathElement
    {
        @Override
        public String get() {
            return this.name;
        }
    }

    public record RootElementPathElement(ResourceKey<?> id) implements PathElement
    {
        @Override
        public String get() {
            return "{" + String.valueOf(this.id.location()) + "@" + String.valueOf(this.id.registry()) + "}";
        }
    }

    public static interface Problem {
        public String description();
    }

    @FunctionalInterface
    public static interface PathElement {
        public String get();
    }

    public record IndexedPathElement(int index) implements PathElement
    {
        @Override
        public String get() {
            return "[" + this.index + "]";
        }
    }

    public record IndexedFieldPathElement(String name, int index) implements PathElement
    {
        @Override
        public String get() {
            return "." + this.name + "[" + this.index + "]";
        }
    }

    public record FieldPathElement(String name) implements PathElement
    {
        @Override
        public String get() {
            return "." + this.name;
        }
    }

    public record ElementReferencePathElement(ResourceKey<?> id) implements PathElement
    {
        @Override
        public String get() {
            return "->{" + String.valueOf(this.id.location()) + "@" + String.valueOf(this.id.registry()) + "}";
        }
    }

    public static class Collector
    implements ProblemReporter {
        public static final PathElement EMPTY_ROOT = () -> "";
        @Nullable
        private final Collector parent;
        private final PathElement element;
        private final Set<Entry> problems;

        public Collector() {
            this(EMPTY_ROOT);
        }

        public Collector(PathElement p_421639_) {
            this.parent = null;
            this.problems = new LinkedHashSet<Entry>();
            this.element = p_421639_;
        }

        private Collector(Collector p_421606_, PathElement p_422426_) {
            this.problems = p_421606_.problems;
            this.parent = p_421606_;
            this.element = p_422426_;
        }

        @Override
        public ProblemReporter forChild(PathElement p_422155_) {
            return new Collector(this, p_422155_);
        }

        @Override
        public void report(Problem p_422092_) {
            this.problems.add(new Entry(this, p_422092_));
        }

        public boolean isEmpty() {
            return this.problems.isEmpty();
        }

        public void forEach(BiConsumer<String, Problem> p_421886_) {
            ArrayList<PathElement> list = new ArrayList<PathElement>();
            StringBuilder stringbuilder = new StringBuilder();
            for (Entry problemreporter$collector$entry : this.problems) {
                Collector problemreporter$collector = problemreporter$collector$entry.source;
                while (problemreporter$collector != null) {
                    list.add(problemreporter$collector.element);
                    problemreporter$collector = problemreporter$collector.parent;
                }
                for (int i = list.size() - 1; i >= 0; --i) {
                    stringbuilder.append(((PathElement)list.get(i)).get());
                }
                p_421886_.accept(stringbuilder.toString(), problemreporter$collector$entry.problem());
                stringbuilder.setLength(0);
                list.clear();
            }
        }

        public String getReport() {
            HashMultimap multimap = HashMultimap.create();
            this.forEach((arg_0, arg_1) -> ((Multimap)multimap).put(arg_0, arg_1));
            return multimap.asMap().entrySet().stream().map(p_421345_ -> " at " + (String)p_421345_.getKey() + ": " + ((Collection)p_421345_.getValue()).stream().map(Problem::description).collect(Collectors.joining("; "))).collect(Collectors.joining("\n"));
        }

        public String getTreeReport() {
            ArrayList<PathElement> list = new ArrayList<PathElement>();
            ProblemTreeNode problemreporter$collector$problemtreenode = new ProblemTreeNode(this.element);
            for (Entry problemreporter$collector$entry : this.problems) {
                Collector problemreporter$collector = problemreporter$collector$entry.source;
                while (problemreporter$collector != this) {
                    list.add(problemreporter$collector.element);
                    problemreporter$collector = problemreporter$collector.parent;
                }
                ProblemTreeNode problemreporter$collector$problemtreenode1 = problemreporter$collector$problemtreenode;
                for (int i = list.size() - 1; i >= 0; --i) {
                    problemreporter$collector$problemtreenode1 = problemreporter$collector$problemtreenode1.child((PathElement)list.get(i));
                }
                list.clear();
                problemreporter$collector$problemtreenode1.problems.add(problemreporter$collector$entry.problem);
            }
            return String.join((CharSequence)"\n", problemreporter$collector$problemtreenode.getLines());
        }

        record Entry(Collector source, Problem problem) {
        }

        record ProblemTreeNode(PathElement element, List<Problem> problems, Map<PathElement, ProblemTreeNode> children) {
            public ProblemTreeNode(PathElement p_422382_) {
                this(p_422382_, new ArrayList<Problem>(), new LinkedHashMap<PathElement, ProblemTreeNode>());
            }

            public ProblemTreeNode child(PathElement p_422281_) {
                return this.children.computeIfAbsent(p_422281_, ProblemTreeNode::new);
            }

            public List<String> getLines() {
                int i = this.problems.size();
                int j = this.children.size();
                if (i == 0 && j == 0) {
                    return List.of();
                }
                if (i == 0 && j == 1) {
                    ArrayList<String> list1 = new ArrayList<String>();
                    this.children.forEach((p_421768_, p_421762_) -> list1.addAll(p_421762_.getLines()));
                    list1.set(0, this.element.get() + (String)list1.get(0));
                    return list1;
                }
                if (i == 1 && j == 0) {
                    return List.of(this.element.get() + ": " + this.problems.getFirst().description());
                }
                ArrayList<String> list = new ArrayList<String>();
                this.children.forEach((p_422150_, p_422334_) -> list.addAll(p_422334_.getLines()));
                list.replaceAll(p_422662_ -> "  " + p_422662_);
                for (Problem problemreporter$problem : this.problems) {
                    list.add("  " + problemreporter$problem.description());
                }
                list.addFirst(this.element.get() + ":");
                return list;
            }
        }
    }
}

