/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import net.minecraft.nbt.Tag;

public class EncoderCache {
    final LoadingCache<Key<?, ?>, DataResult<?>> cache;

    public EncoderCache(int p_341936_) {
        this.cache = CacheBuilder.newBuilder().maximumSize((long)p_341936_).concurrencyLevel(1).softValues().build(new CacheLoader<Key<?, ?>, DataResult<?>>(this){

            public DataResult<?> load(Key<?, ?> p_341934_) {
                return p_341934_.resolve();
            }
        });
    }

    public <A> Codec<A> wrap(final Codec<A> p_341888_) {
        return new Codec<A>(){

            public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> p_341931_, T p_341946_) {
                return p_341888_.decode(p_341931_, p_341946_);
            }

            public <T> DataResult<T> encode(A p_341885_, DynamicOps<T> p_341925_, T p_341904_) {
                return ((DataResult)EncoderCache.this.cache.getUnchecked(new Key(p_341888_, p_341885_, p_341925_))).map(p_342020_ -> {
                    Object object;
                    if (p_342020_ instanceof Tag) {
                        Tag tag = (Tag)p_342020_;
                        object = tag.copy();
                    } else {
                        object = p_342020_;
                    }
                    return object;
                });
            }
        };
    }

    record Key<A, T>(Codec<A> codec, A value, DynamicOps<T> ops) {
        public DataResult<T> resolve() {
            return this.codec.encodeStart(this.ops, this.value);
        }

        @Override
        public boolean equals(Object p_341937_) {
            boolean bl;
            if (this == p_341937_) {
                return true;
            }
            if (!(p_341937_ instanceof Key)) {
                bl = false;
            } else {
                Key key = (Key)p_341937_;
                bl = this.codec == key.codec && this.value.equals(key.value) && this.ops.equals(key.ops);
            }
            return bl;
        }

        @Override
        public int hashCode() {
            int i = System.identityHashCode(this.codec);
            i = 31 * i + this.value.hashCode();
            return 31 * i + this.ops.hashCode();
        }
    }
}

