/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class ARGB {
    public static int alpha(int p_360646_) {
        return p_360646_ >>> 24;
    }

    public static int red(int p_365322_) {
        return p_365322_ >> 16 & 0xFF;
    }

    public static int green(int p_364426_) {
        return p_364426_ >> 8 & 0xFF;
    }

    public static int blue(int p_365014_) {
        return p_365014_ & 0xFF;
    }

    public static int color(int p_364075_, int p_361505_, int p_364686_, int p_361326_) {
        return p_364075_ << 24 | p_361505_ << 16 | p_364686_ << 8 | p_361326_;
    }

    public static int color(int p_364209_, int p_361249_, int p_362935_) {
        return ARGB.color(255, p_364209_, p_361249_, p_362935_);
    }

    public static int color(Vec3 p_362659_) {
        return ARGB.color(ARGB.as8BitChannel((float)p_362659_.x()), ARGB.as8BitChannel((float)p_362659_.y()), ARGB.as8BitChannel((float)p_362659_.z()));
    }

    public static int multiply(int p_365204_, int p_362101_) {
        if (p_365204_ == -1) {
            return p_362101_;
        }
        return p_362101_ == -1 ? p_365204_ : ARGB.color(ARGB.alpha(p_365204_) * ARGB.alpha(p_362101_) / 255, ARGB.red(p_365204_) * ARGB.red(p_362101_) / 255, ARGB.green(p_365204_) * ARGB.green(p_362101_) / 255, ARGB.blue(p_365204_) * ARGB.blue(p_362101_) / 255);
    }

    public static int scaleRGB(int p_365021_, float p_363883_) {
        return ARGB.scaleRGB(p_365021_, p_363883_, p_363883_, p_363883_);
    }

    public static int scaleRGB(int p_379627_, float p_379288_, float p_380277_, float p_380015_) {
        return ARGB.color(ARGB.alpha(p_379627_), Math.clamp((long)((int)((float)ARGB.red(p_379627_) * p_379288_)), 0, 255), Math.clamp((long)((int)((float)ARGB.green(p_379627_) * p_380277_)), 0, 255), Math.clamp((long)((int)((float)ARGB.blue(p_379627_) * p_380015_)), 0, 255));
    }

    public static int scaleRGB(int p_360775_, int p_363230_) {
        return ARGB.color(ARGB.alpha(p_360775_), Math.clamp((long)ARGB.red(p_360775_) * (long)p_363230_ / 255L, 0, 255), Math.clamp((long)ARGB.green(p_360775_) * (long)p_363230_ / 255L, 0, 255), Math.clamp((long)ARGB.blue(p_360775_) * (long)p_363230_ / 255L, 0, 255));
    }

    public static int greyscale(int p_363419_) {
        int i = (int)((float)ARGB.red(p_363419_) * 0.3f + (float)ARGB.green(p_363419_) * 0.59f + (float)ARGB.blue(p_363419_) * 0.11f);
        return ARGB.color(i, i, i);
    }

    public static int lerp(float p_361174_, int p_362196_, int p_364079_) {
        int i = Mth.lerpInt(p_361174_, ARGB.alpha(p_362196_), ARGB.alpha(p_364079_));
        int j = Mth.lerpInt(p_361174_, ARGB.red(p_362196_), ARGB.red(p_364079_));
        int k = Mth.lerpInt(p_361174_, ARGB.green(p_362196_), ARGB.green(p_364079_));
        int l = Mth.lerpInt(p_361174_, ARGB.blue(p_362196_), ARGB.blue(p_364079_));
        return ARGB.color(i, j, k, l);
    }

    public static int opaque(int p_363279_) {
        return p_363279_ | 0xFF000000;
    }

    public static int transparent(int p_361588_) {
        return p_361588_ & 0xFFFFFF;
    }

    public static int color(int p_360598_, int p_363344_) {
        return p_360598_ << 24 | p_363344_ & 0xFFFFFF;
    }

    public static int color(float p_422159_, int p_421556_) {
        return ARGB.as8BitChannel(p_422159_) << 24 | p_421556_ & 0xFFFFFF;
    }

    public static int white(float p_361517_) {
        return ARGB.as8BitChannel(p_361517_) << 24 | 0xFFFFFF;
    }

    public static int colorFromFloat(float p_361263_, float p_361756_, float p_363770_, float p_362317_) {
        return ARGB.color(ARGB.as8BitChannel(p_361263_), ARGB.as8BitChannel(p_361756_), ARGB.as8BitChannel(p_363770_), ARGB.as8BitChannel(p_362317_));
    }

    public static Vector3f vector3fFromRGB24(int p_381022_) {
        float f = (float)ARGB.red(p_381022_) / 255.0f;
        float f1 = (float)ARGB.green(p_381022_) / 255.0f;
        float f2 = (float)ARGB.blue(p_381022_) / 255.0f;
        return new Vector3f(f, f1, f2);
    }

    public static int average(int p_363294_, int p_365166_) {
        return ARGB.color((ARGB.alpha(p_363294_) + ARGB.alpha(p_365166_)) / 2, (ARGB.red(p_363294_) + ARGB.red(p_365166_)) / 2, (ARGB.green(p_363294_) + ARGB.green(p_365166_)) / 2, (ARGB.blue(p_363294_) + ARGB.blue(p_365166_)) / 2);
    }

    public static int as8BitChannel(float p_362531_) {
        return Mth.floor(p_362531_ * 255.0f);
    }

    public static float alphaFloat(int p_383239_) {
        return ARGB.from8BitChannel(ARGB.alpha(p_383239_));
    }

    public static float redFloat(int p_382787_) {
        return ARGB.from8BitChannel(ARGB.red(p_382787_));
    }

    public static float greenFloat(int p_382823_) {
        return ARGB.from8BitChannel(ARGB.green(p_382823_));
    }

    public static float blueFloat(int p_382858_) {
        return ARGB.from8BitChannel(ARGB.blue(p_382858_));
    }

    private static float from8BitChannel(int p_362888_) {
        return (float)p_362888_ / 255.0f;
    }

    public static int toABGR(int p_364127_) {
        return p_364127_ & 0xFF00FF00 | (p_364127_ & 0xFF0000) >> 16 | (p_364127_ & 0xFF) << 16;
    }

    public static int fromABGR(int p_362222_) {
        return ARGB.toABGR(p_362222_);
    }

    public static int setBrightness(int p_416733_, float p_415549_) {
        float f2;
        int i = ARGB.red(p_416733_);
        int j = ARGB.green(p_416733_);
        int k = ARGB.blue(p_416733_);
        int l = ARGB.alpha(p_416733_);
        int i1 = Math.max(Math.max(i, j), k);
        int j1 = Math.min(Math.min(i, j), k);
        float f = i1 - j1;
        float f1 = i1 != 0 ? f / (float)i1 : 0.0f;
        if (f1 == 0.0f) {
            f2 = 0.0f;
        } else {
            float f3 = (float)(i1 - i) / f;
            float f4 = (float)(i1 - j) / f;
            float f5 = (float)(i1 - k) / f;
            f2 = i == i1 ? f5 - f4 : (j == i1 ? 2.0f + f3 - f5 : 4.0f + f4 - f3);
            if ((f2 /= 6.0f) < 0.0f) {
                f2 += 1.0f;
            }
        }
        if (f1 == 0.0f) {
            j = k = Math.round(p_415549_ * 255.0f);
            i = k;
            return ARGB.color(l, i, j, k);
        }
        float f8 = (f2 - (float)Math.floor(f2)) * 6.0f;
        float f9 = f8 - (float)Math.floor(f8);
        float f10 = p_415549_ * (1.0f - f1);
        float f6 = p_415549_ * (1.0f - f1 * f9);
        float f7 = p_415549_ * (1.0f - f1 * (1.0f - f9));
        switch ((int)f8) {
            case 0: {
                i = Math.round(p_415549_ * 255.0f);
                j = Math.round(f7 * 255.0f);
                k = Math.round(f10 * 255.0f);
                break;
            }
            case 1: {
                i = Math.round(f6 * 255.0f);
                j = Math.round(p_415549_ * 255.0f);
                k = Math.round(f10 * 255.0f);
                break;
            }
            case 2: {
                i = Math.round(f10 * 255.0f);
                j = Math.round(p_415549_ * 255.0f);
                k = Math.round(f7 * 255.0f);
                break;
            }
            case 3: {
                i = Math.round(f10 * 255.0f);
                j = Math.round(f6 * 255.0f);
                k = Math.round(p_415549_ * 255.0f);
                break;
            }
            case 4: {
                i = Math.round(f7 * 255.0f);
                j = Math.round(f10 * 255.0f);
                k = Math.round(p_415549_ * 255.0f);
                break;
            }
            case 5: {
                i = Math.round(p_415549_ * 255.0f);
                j = Math.round(f10 * 255.0f);
                k = Math.round(f6 * 255.0f);
            }
        }
        return ARGB.color(l, i, j, k);
    }
}

