/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistrySynchronization;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.RegistryLayer;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagLoader;

public class TagNetworkSerialization {
    public static Map<ResourceKey<? extends Registry<?>>, NetworkPayload> serializeTagsToNetwork(LayeredRegistryAccess<RegistryLayer> p_251774_) {
        return RegistrySynchronization.networkSafeRegistries(p_251774_).map(p_203949_ -> Pair.of(p_203949_.key(), (Object)TagNetworkSerialization.serializeToNetwork(p_203949_.value()))).filter(p_359657_ -> !((NetworkPayload)p_359657_.getSecond()).isEmpty()).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
    }

    private static <T> NetworkPayload serializeToNetwork(Registry<T> p_203943_) {
        HashMap<ResourceLocation, IntList> map = new HashMap<ResourceLocation, IntList>();
        p_203943_.getTags().forEach(p_359660_ -> {
            IntArrayList intlist = new IntArrayList(p_359660_.size());
            for (Holder holder : p_359660_) {
                if (holder.kind() != Holder.Kind.REFERENCE) {
                    throw new IllegalStateException("Can't serialize unregistered value " + String.valueOf(holder));
                }
                intlist.add(p_203943_.getId(holder.value()));
            }
            map.put(p_359660_.key().location(), (IntList)intlist);
        });
        return new NetworkPayload(map);
    }

    static <T> TagLoader.LoadResult<T> deserializeTagsFromNetwork(Registry<T> p_203954_, NetworkPayload p_203955_) {
        ResourceKey resourcekey = p_203954_.key();
        HashMap map = new HashMap();
        p_203955_.tags.forEach((p_359655_, p_359656_) -> {
            TagKey tagkey = TagKey.create(resourcekey, p_359655_);
            List list = p_359656_.intStream().mapToObj(p_203954_::get).flatMap(Optional::stream).collect(Collectors.toUnmodifiableList());
            map.put(tagkey, list);
        });
        return new TagLoader.LoadResult<T>(resourcekey, map);
    }

    public static final class NetworkPayload {
        public static final NetworkPayload EMPTY = new NetworkPayload(Map.of());
        final Map<ResourceLocation, IntList> tags;

        NetworkPayload(Map<ResourceLocation, IntList> p_203965_) {
            this.tags = p_203965_;
        }

        public void write(FriendlyByteBuf p_203968_) {
            p_203968_.writeMap(this.tags, FriendlyByteBuf::writeResourceLocation, FriendlyByteBuf::writeIntIdList);
        }

        public static NetworkPayload read(FriendlyByteBuf p_203970_) {
            return new NetworkPayload(p_203970_.readMap(FriendlyByteBuf::readResourceLocation, FriendlyByteBuf::readIntIdList));
        }

        public boolean isEmpty() {
            return this.tags.isEmpty();
        }

        public int size() {
            return this.tags.size();
        }

        public <T> TagLoader.LoadResult<T> resolve(Registry<T> p_363647_) {
            return TagNetworkSerialization.deserializeTagsFromNetwork(p_363647_, this);
        }
    }
}

