/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.inventory.RecipeBookType;
import net.neoforged.neoforge.common.CommonHooks;

public final class RecipeBookSettings {
    public static final StreamCodec<RegistryFriendlyByteBuf, RecipeBookSettings> STREAM_CODEC = StreamCodec.composite(TypeSettings.STREAM_CODEC, p_421342_ -> p_421342_.crafting, TypeSettings.STREAM_CODEC, p_421338_ -> p_421338_.furnace, TypeSettings.STREAM_CODEC, p_421337_ -> p_421337_.blastFurnace, TypeSettings.STREAM_CODEC, p_421340_ -> p_421340_.smoker, CommonHooks.MODDED_RECIPE_BOOK_TYPES_SETTINGS_STREAM_CODEC, settings -> settings.moddedSettings, RecipeBookSettings::new);
    public static final MapCodec<RecipeBookSettings> MAP_CODEC = RecordCodecBuilder.mapCodec(p_421339_ -> p_421339_.group((App)TypeSettings.CRAFTING_MAP_CODEC.forGetter(p_421343_ -> p_421343_.crafting), (App)TypeSettings.FURNACE_MAP_CODEC.forGetter(p_421344_ -> p_421344_.furnace), (App)TypeSettings.BLAST_FURNACE_MAP_CODEC.forGetter(p_421336_ -> p_421336_.blastFurnace), (App)TypeSettings.SMOKER_MAP_CODEC.forGetter(p_421341_ -> p_421341_.smoker), (App)CommonHooks.makeModdedRecipeBookTypesSettingsCodec().forGetter(settings -> settings.moddedSettings)).apply((Applicative)p_421339_, RecipeBookSettings::new));
    private TypeSettings crafting;
    private TypeSettings furnace;
    private TypeSettings blastFurnace;
    private TypeSettings smoker;
    private final Map<RecipeBookType, TypeSettings> moddedSettings;

    public RecipeBookSettings() {
        this(TypeSettings.DEFAULT, TypeSettings.DEFAULT, TypeSettings.DEFAULT, TypeSettings.DEFAULT);
    }

    private RecipeBookSettings(TypeSettings p_422389_, TypeSettings p_422071_, TypeSettings p_421838_, TypeSettings p_421582_) {
        this(p_422389_, p_422071_, p_421838_, p_421582_, new EnumMap<RecipeBookType, TypeSettings>(RecipeBookType.class));
    }

    private RecipeBookSettings(TypeSettings p_422389_, TypeSettings p_422071_, TypeSettings p_421838_, TypeSettings p_421582_, Map<RecipeBookType, TypeSettings> moddedSettings) {
        this.crafting = p_422389_;
        this.furnace = p_422071_;
        this.blastFurnace = p_421838_;
        this.smoker = p_421582_;
        this.moddedSettings = moddedSettings;
    }

    @VisibleForTesting
    public TypeSettings getSettings(RecipeBookType p_380129_) {
        return switch (p_380129_) {
            case RecipeBookType.CRAFTING -> this.crafting;
            case RecipeBookType.FURNACE -> this.furnace;
            case RecipeBookType.BLAST_FURNACE -> this.blastFurnace;
            case RecipeBookType.SMOKER -> this.smoker;
            default -> this.moddedSettings.getOrDefault((Object)p_380129_, TypeSettings.DEFAULT);
        };
    }

    private void updateSettings(RecipeBookType p_379381_, UnaryOperator<TypeSettings> p_379491_) {
        switch (p_379381_) {
            case CRAFTING: {
                this.crafting = (TypeSettings)p_379491_.apply(this.crafting);
                break;
            }
            case FURNACE: {
                this.furnace = (TypeSettings)p_379491_.apply(this.furnace);
                break;
            }
            case BLAST_FURNACE: {
                this.blastFurnace = (TypeSettings)p_379491_.apply(this.blastFurnace);
                break;
            }
            case SMOKER: {
                this.smoker = (TypeSettings)p_379491_.apply(this.smoker);
                break;
            }
            default: {
                this.moddedSettings.put(p_379381_, (TypeSettings)p_379491_.apply(this.moddedSettings.getOrDefault((Object)p_379381_, TypeSettings.DEFAULT)));
            }
        }
    }

    public boolean isOpen(RecipeBookType p_12735_) {
        return this.getSettings((RecipeBookType)p_12735_).open;
    }

    public void setOpen(RecipeBookType p_12737_, boolean p_12738_) {
        this.updateSettings(p_12737_, p_379063_ -> p_379063_.setOpen(p_12738_));
    }

    public boolean isFiltering(RecipeBookType p_12755_) {
        return this.getSettings((RecipeBookType)p_12755_).filtering;
    }

    public void setFiltering(RecipeBookType p_12757_, boolean p_12758_) {
        this.updateSettings(p_12757_, p_379058_ -> p_379058_.setFiltering(p_12758_));
    }

    public RecipeBookSettings copy() {
        return new RecipeBookSettings(this.crafting, this.furnace, this.blastFurnace, this.smoker, new EnumMap<RecipeBookType, TypeSettings>(this.moddedSettings));
    }

    public void replaceFrom(RecipeBookSettings p_12733_) {
        this.crafting = p_12733_.crafting;
        this.furnace = p_12733_.furnace;
        this.blastFurnace = p_12733_.blastFurnace;
        this.smoker = p_12733_.smoker;
        this.moddedSettings.clear();
        this.moddedSettings.putAll(p_12733_.moddedSettings);
    }

    public record TypeSettings(boolean open, boolean filtering) {
        public static final TypeSettings DEFAULT = new TypeSettings(false, false);
        public static final MapCodec<TypeSettings> CRAFTING_MAP_CODEC = TypeSettings.codec("isGuiOpen", "isFilteringCraftable");
        public static final MapCodec<TypeSettings> FURNACE_MAP_CODEC = TypeSettings.codec("isFurnaceGuiOpen", "isFurnaceFilteringCraftable");
        public static final MapCodec<TypeSettings> BLAST_FURNACE_MAP_CODEC = TypeSettings.codec("isBlastingFurnaceGuiOpen", "isBlastingFurnaceFilteringCraftable");
        public static final MapCodec<TypeSettings> SMOKER_MAP_CODEC = TypeSettings.codec("isSmokerGuiOpen", "isSmokerFilteringCraftable");
        public static final StreamCodec<ByteBuf, TypeSettings> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.BOOL, TypeSettings::open, ByteBufCodecs.BOOL, TypeSettings::filtering, TypeSettings::new);

        @Override
        public String toString() {
            return "[open=" + this.open + ", filtering=" + this.filtering + "]";
        }

        public TypeSettings setOpen(boolean p_379785_) {
            return new TypeSettings(p_379785_, this.filtering);
        }

        public TypeSettings setFiltering(boolean p_380039_) {
            return new TypeSettings(this.open, p_380039_);
        }

        public static MapCodec<TypeSettings> codec(String p_422385_, String p_422603_) {
            return RecordCodecBuilder.mapCodec(p_422649_ -> p_422649_.group((App)Codec.BOOL.optionalFieldOf(p_422385_, (Object)false).forGetter(TypeSettings::open), (App)Codec.BOOL.optionalFieldOf(p_422603_, (Object)false).forGetter(TypeSettings::filtering)).apply((Applicative)p_422649_, TypeSettings::new));
        }
    }
}

