/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.repository;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.FileUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.FilePackResources;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.linkfs.LinkFileSystem;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackDetector;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.world.level.validation.ContentValidationException;
import net.minecraft.world.level.validation.DirectoryValidator;
import net.minecraft.world.level.validation.ForbiddenSymlinkInfo;
import org.slf4j.Logger;

public class FolderRepositorySource
implements RepositorySource {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final PackSelectionConfig DISCOVERED_PACK_SELECTION_CONFIG = new PackSelectionConfig(false, Pack.Position.TOP, false);
    private final Path folder;
    private final PackType packType;
    private final PackSource packSource;
    private final DirectoryValidator validator;

    public FolderRepositorySource(Path p_251796_, PackType p_251664_, PackSource p_250854_, DirectoryValidator p_296354_) {
        this.folder = p_251796_;
        this.packType = p_251664_;
        this.packSource = p_250854_;
        this.validator = p_296354_;
    }

    private static String nameFromPath(Path p_248745_) {
        return p_248745_.getFileName().toString();
    }

    @Override
    public void loadPacks(Consumer<Pack> p_250965_) {
        try {
            FileUtil.createDirectoriesSafe(this.folder);
            FolderRepositorySource.discoverPacks(this.folder, this.validator, (p_325639_, p_325640_) -> {
                PackLocationInfo packlocationinfo = this.createDiscoveredFilePackInfo((Path)p_325639_);
                Pack pack = Pack.readMetaAndCreate(packlocationinfo, p_325640_, this.packType, DISCOVERED_PACK_SELECTION_CONFIG);
                if (pack != null) {
                    p_250965_.accept(pack);
                }
            });
        }
        catch (IOException ioexception) {
            LOGGER.warn("Failed to list packs in {}", (Object)this.folder, (Object)ioexception);
        }
    }

    private PackLocationInfo createDiscoveredFilePackInfo(Path p_326163_) {
        String s = FolderRepositorySource.nameFromPath(p_326163_);
        return new PackLocationInfo("file/" + s, Component.literal(s), this.packSource, Optional.empty());
    }

    public static void discoverPacks(Path p_248794_, DirectoryValidator p_294483_, BiConsumer<Path, Pack.ResourcesSupplier> p_248580_) throws IOException {
        FolderPackDetector folderrepositorysource$folderpackdetector = new FolderPackDetector(p_294483_);
        try (DirectoryStream<Path> directorystream = Files.newDirectoryStream(p_248794_);){
            for (Path path : directorystream) {
                try {
                    ArrayList<ForbiddenSymlinkInfo> list = new ArrayList<ForbiddenSymlinkInfo>();
                    Pack.ResourcesSupplier pack$resourcessupplier = (Pack.ResourcesSupplier)folderrepositorysource$folderpackdetector.detectPackResources(path, list);
                    if (!list.isEmpty()) {
                        LOGGER.warn("Ignoring potential pack entry: {}", (Object)ContentValidationException.getMessage(path, list));
                        continue;
                    }
                    if (pack$resourcessupplier != null) {
                        p_248580_.accept(path, pack$resourcessupplier);
                        continue;
                    }
                    LOGGER.info("Found non-pack entry '{}', ignoring", (Object)path);
                }
                catch (IOException ioexception) {
                    LOGGER.warn("Failed to read properties of '{}', ignoring", (Object)path, (Object)ioexception);
                }
            }
        }
    }

    static class FolderPackDetector
    extends PackDetector<Pack.ResourcesSupplier> {
        protected FolderPackDetector(DirectoryValidator p_296420_) {
            super(p_296420_);
        }

        @Override
        @Nullable
        protected Pack.ResourcesSupplier createZipPack(Path p_294522_) {
            FileSystem filesystem = p_294522_.getFileSystem();
            if (filesystem != FileSystems.getDefault() && !(filesystem instanceof LinkFileSystem)) {
                LOGGER.info("Can't open pack archive at {}", (Object)p_294522_);
                return null;
            }
            return new FilePackResources.FileResourcesSupplier(p_294522_);
        }

        @Override
        protected Pack.ResourcesSupplier createDirectoryPack(Path p_295493_) {
            return new PathPackResources.PathResourcesSupplier(p_295493_);
        }
    }
}

