/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.FileUtil;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.CompositePackResources;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.resources.IoSupplier;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class PathPackResources
extends AbstractPackResources {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Joiner PATH_JOINER = Joiner.on((String)"/");
    private final Path root;

    public PathPackResources(PackLocationInfo p_326080_, Path p_256025_) {
        super(p_326080_);
        this.root = p_256025_;
    }

    @Override
    @Nullable
    public IoSupplier<InputStream> getRootResource(String ... p_249041_) {
        FileUtil.validatePath(p_249041_);
        Path path = FileUtil.resolvePath(this.root, List.of(p_249041_));
        return Files.exists(path, new LinkOption[0]) ? IoSupplier.create(path) : null;
    }

    public static boolean validatePath(Path p_249579_) {
        return true;
    }

    @Override
    @Nullable
    public IoSupplier<InputStream> getResource(PackType p_249352_, ResourceLocation p_251715_) {
        Path path = this.root.resolve(p_249352_.getDirectory()).resolve(p_251715_.getNamespace());
        return PathPackResources.getResource(p_251715_, path);
    }

    @Nullable
    public static IoSupplier<InputStream> getResource(ResourceLocation p_250145_, Path p_251046_) {
        return (IoSupplier)FileUtil.decomposePath(p_250145_.getPath()).mapOrElse(p_251647_ -> {
            Path path = FileUtil.resolvePath(p_251046_, p_251647_);
            return PathPackResources.returnFileIfExists(path);
        }, p_337558_ -> {
            LOGGER.error("Invalid path {}: {}", (Object)p_250145_, (Object)p_337558_.message());
            return null;
        });
    }

    @Nullable
    private static IoSupplier<InputStream> returnFileIfExists(Path p_250506_) {
        return Files.exists(p_250506_, new LinkOption[0]) && PathPackResources.validatePath(p_250506_) ? IoSupplier.create(p_250506_) : null;
    }

    @Override
    public void listResources(PackType p_251452_, String p_249854_, String p_248650_, PackResources.ResourceOutput p_248572_) {
        FileUtil.decomposePath(p_248650_).ifSuccess(p_250225_ -> {
            Path path = this.root.resolve(p_251452_.getDirectory()).resolve(p_249854_);
            PathPackResources.listPath(p_249854_, path, p_250225_, p_248572_);
        }).ifError(p_337560_ -> LOGGER.error("Invalid path {}: {}", (Object)p_248650_, (Object)p_337560_.message()));
    }

    public static void listPath(String p_249455_, Path p_249514_, List<String> p_251918_, PackResources.ResourceOutput p_249964_) {
        Path path = FileUtil.resolvePath(p_249514_, p_251918_);
        try (Stream<Path> stream2 = Files.find(path, Integer.MAX_VALUE, PathPackResources::isRegularFile, new FileVisitOption[0]);){
            stream2.forEach(p_249092_ -> {
                String s = PATH_JOINER.join((Iterable)p_249514_.relativize((Path)p_249092_));
                ResourceLocation resourcelocation = ResourceLocation.tryBuild(p_249455_, s);
                if (resourcelocation == null) {
                    Util.logAndPauseIfInIde(String.format(Locale.ROOT, "Invalid path in pack: %s:%s, ignoring", p_249455_, s));
                } else {
                    p_249964_.accept(resourcelocation, IoSupplier.create(p_249092_));
                }
            });
        }
        catch (NoSuchFileException | NotDirectoryException stream2) {
        }
        catch (IOException ioexception) {
            LOGGER.error("Failed to list path {}", (Object)path, (Object)ioexception);
        }
    }

    private static boolean isRegularFile(Path p_428531_, BasicFileAttributes p_428454_) {
        return !SharedConstants.IS_RUNNING_IN_IDE ? p_428454_.isRegularFile() : p_428454_.isRegularFile() && !StringUtils.equalsIgnoreCase((CharSequence)p_428531_.getFileName().toString(), (CharSequence)".ds_store");
    }

    @Override
    public Set<String> getNamespaces(PackType p_251896_) {
        HashSet set = Sets.newHashSet();
        Path path = this.root.resolve(p_251896_.getDirectory());
        try (DirectoryStream<Path> directorystream2 = Files.newDirectoryStream(path);){
            for (Path path1 : directorystream2) {
                String s = path1.getFileName().toString();
                if (ResourceLocation.isValidNamespace(s)) {
                    set.add(s);
                    continue;
                }
                LOGGER.warn("Non [a-z0-9_.-] character in namespace {} in pack {}, ignoring", (Object)s, (Object)this.root);
            }
        }
        catch (NoSuchFileException | NotDirectoryException directorystream2) {
        }
        catch (IOException ioexception) {
            LOGGER.error("Failed to list path {}", (Object)path, (Object)ioexception);
        }
        return set;
    }

    @Override
    public void close() {
    }

    public static class PathResourcesSupplier
    implements Pack.ResourcesSupplier {
        private final Path content;

        public PathResourcesSupplier(Path p_294512_) {
            this.content = p_294512_;
        }

        @Override
        public PackResources openPrimary(PackLocationInfo p_325962_) {
            return new PathPackResources(p_325962_, this.content);
        }

        @Override
        public PackResources openFull(PackLocationInfo p_326066_, Pack.Metadata p_326237_) {
            PackResources packresources = this.openPrimary(p_326066_);
            List<String> list = p_326237_.overlays();
            if (list.isEmpty()) {
                return packresources;
            }
            ArrayList<PackResources> list1 = new ArrayList<PackResources>(list.size());
            for (String s : list) {
                Path path = this.content.resolve(s);
                list1.add(new PathPackResources(p_326066_, path));
            }
            return new CompositePackResources(packresources, list1);
        }
    }
}

