/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.CompositePackResources;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.resources.IoSupplier;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class FilePackResources
extends AbstractPackResources {
    static final Logger LOGGER = LogUtils.getLogger();
    private final SharedZipFileAccess zipFileAccess;
    private final String prefix;

    public FilePackResources(PackLocationInfo p_326506_, SharedZipFileAccess p_296014_, String p_256076_) {
        super(p_326506_);
        this.zipFileAccess = p_296014_;
        this.prefix = p_256076_;
    }

    private static String getPathFromLocation(PackType p_250585_, ResourceLocation p_251470_) {
        return String.format(Locale.ROOT, "%s/%s/%s", p_250585_.getDirectory(), p_251470_.getNamespace(), p_251470_.getPath());
    }

    @Override
    @Nullable
    public IoSupplier<InputStream> getRootResource(String ... p_248514_) {
        return this.getResource(String.join((CharSequence)"/", p_248514_));
    }

    @Override
    public IoSupplier<InputStream> getResource(PackType p_249605_, ResourceLocation p_252147_) {
        return this.getResource(FilePackResources.getPathFromLocation(p_249605_, p_252147_));
    }

    private String addPrefix(String p_295349_) {
        return this.prefix.isEmpty() ? p_295349_ : this.prefix + "/" + p_295349_;
    }

    @Nullable
    private IoSupplier<InputStream> getResource(String p_251795_) {
        ZipFile zipfile = this.zipFileAccess.getOrCreateZipFile();
        if (zipfile == null) {
            return null;
        }
        ZipEntry zipentry = zipfile.getEntry(this.addPrefix(p_251795_));
        return zipentry == null ? null : IoSupplier.create(zipfile, zipentry);
    }

    @Override
    public Set<String> getNamespaces(PackType p_10238_) {
        ZipFile zipfile = this.zipFileAccess.getOrCreateZipFile();
        if (zipfile == null) {
            return Set.of();
        }
        Enumeration<? extends ZipEntry> enumeration = zipfile.entries();
        HashSet set = Sets.newHashSet();
        String s = this.addPrefix(p_10238_.getDirectory() + "/");
        while (enumeration.hasMoreElements()) {
            ZipEntry zipentry = enumeration.nextElement();
            String s1 = zipentry.getName();
            String s2 = FilePackResources.extractNamespace(s, s1);
            if (s2.isEmpty()) continue;
            if (ResourceLocation.isValidNamespace(s2)) {
                set.add(s2);
                continue;
            }
            LOGGER.warn("Non [a-z0-9_.-] character in namespace {} in pack {}, ignoring", (Object)s2, (Object)this.zipFileAccess.file);
        }
        return set;
    }

    @VisibleForTesting
    public static String extractNamespace(String p_294953_, String p_294476_) {
        if (!p_294476_.startsWith(p_294953_)) {
            return "";
        }
        int i = p_294953_.length();
        int j = p_294476_.indexOf(47, i);
        return j == -1 ? p_294476_.substring(i) : p_294476_.substring(i, j);
    }

    @Override
    public void close() {
        this.zipFileAccess.close();
    }

    @Override
    public void listResources(PackType p_250500_, String p_249598_, String p_251613_, PackResources.ResourceOutput p_250655_) {
        ZipFile zipfile = this.zipFileAccess.getOrCreateZipFile();
        if (zipfile != null) {
            Enumeration<? extends ZipEntry> enumeration = zipfile.entries();
            String s = this.addPrefix(p_250500_.getDirectory() + "/" + p_249598_ + "/");
            String s1 = s + p_251613_ + "/";
            while (enumeration.hasMoreElements()) {
                String s2;
                ZipEntry zipentry = enumeration.nextElement();
                if (zipentry.isDirectory() || !(s2 = zipentry.getName()).startsWith(s1)) continue;
                String s3 = s2.substring(s.length());
                ResourceLocation resourcelocation = ResourceLocation.tryBuild(p_249598_, s3);
                if (resourcelocation != null) {
                    p_250655_.accept(resourcelocation, IoSupplier.create(zipfile, zipentry));
                    continue;
                }
                LOGGER.warn("Invalid path in datapack: {}:{}, ignoring", (Object)p_249598_, (Object)s3);
            }
        }
    }

    public static class SharedZipFileAccess
    implements AutoCloseable {
        final File file;
        @Nullable
        private ZipFile zipFile;
        private boolean failedToLoad;

        public SharedZipFileAccess(File p_294132_) {
            this.file = p_294132_;
        }

        @Nullable
        ZipFile getOrCreateZipFile() {
            if (this.failedToLoad) {
                return null;
            }
            if (this.zipFile == null) {
                try {
                    this.zipFile = new ZipFile(this.file);
                }
                catch (IOException ioexception) {
                    LOGGER.error("Failed to open pack {}", (Object)this.file, (Object)ioexception);
                    this.failedToLoad = true;
                    return null;
                }
            }
            return this.zipFile;
        }

        @Override
        public void close() {
            if (this.zipFile != null) {
                IOUtils.closeQuietly((Closeable)this.zipFile);
                this.zipFile = null;
            }
        }

        protected void finalize() throws Throwable {
            this.close();
            super.finalize();
        }
    }

    public static class FileResourcesSupplier
    implements Pack.ResourcesSupplier {
        private final File content;

        public FileResourcesSupplier(Path p_326243_) {
            this(p_326243_.toFile());
        }

        public FileResourcesSupplier(File p_326453_) {
            this.content = p_326453_;
        }

        @Override
        public PackResources openPrimary(PackLocationInfo p_326493_) {
            SharedZipFileAccess filepackresources$sharedzipfileaccess = new SharedZipFileAccess(this.content);
            return new FilePackResources(p_326493_, filepackresources$sharedzipfileaccess, "");
        }

        @Override
        public PackResources openFull(PackLocationInfo p_326484_, Pack.Metadata p_326165_) {
            SharedZipFileAccess filepackresources$sharedzipfileaccess = new SharedZipFileAccess(this.content);
            FilePackResources packresources = new FilePackResources(p_326484_, filepackresources$sharedzipfileaccess, "");
            List<String> list = p_326165_.overlays();
            if (list.isEmpty()) {
                return packresources;
            }
            ArrayList<PackResources> list1 = new ArrayList<PackResources>(list.size());
            for (String s : list) {
                list1.add(new FilePackResources(p_326484_, filepackresources$sharedzipfileaccess, s));
            }
            return new CompositePackResources(packresources, list1);
        }
    }
}

