/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;

public class DownloadCacheCleaner {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void vacuumCacheDir(Path p_314919_, int p_314928_) {
        try {
            List<PathAndTime> list = DownloadCacheCleaner.listFilesWithModificationTimes(p_314919_);
            int i = list.size() - p_314928_;
            if (i <= 0) {
                return;
            }
            list.sort(PathAndTime.NEWEST_FIRST);
            List<PathAndPriority> list1 = DownloadCacheCleaner.prioritizeFilesInDirs(list);
            Collections.reverse(list1);
            list1.sort(PathAndPriority.HIGHEST_PRIORITY_FIRST);
            HashSet<Path> set = new HashSet<Path>();
            for (int j = 0; j < i; ++j) {
                PathAndPriority downloadcachecleaner$pathandpriority = list1.get(j);
                Path path = downloadcachecleaner$pathandpriority.path;
                try {
                    Files.delete(path);
                    if (downloadcachecleaner$pathandpriority.removalPriority != 0) continue;
                    set.add(path.getParent());
                    continue;
                }
                catch (IOException ioexception1) {
                    LOGGER.warn("Failed to delete cache file {}", (Object)path, (Object)ioexception1);
                }
            }
            set.remove(p_314919_);
            for (Path path1 : set) {
                try {
                    Files.delete(path1);
                }
                catch (DirectoryNotEmptyException path) {
                }
                catch (IOException ioexception) {
                    LOGGER.warn("Failed to delete empty(?) cache directory {}", (Object)path1, (Object)ioexception);
                }
            }
        }
        catch (IOException | UncheckedIOException ioexception2) {
            LOGGER.error("Failed to vacuum cache dir {}", (Object)p_314919_, (Object)ioexception2);
        }
    }

    private static List<PathAndTime> listFilesWithModificationTimes(final Path p_314985_) throws IOException {
        try {
            final ArrayList<PathAndTime> list = new ArrayList<PathAndTime>();
            Files.walkFileTree(p_314985_, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path p_314922_, BasicFileAttributes p_315004_) {
                    if (p_315004_.isRegularFile() && !p_314922_.getParent().equals(p_314985_)) {
                        FileTime filetime = p_315004_.lastModifiedTime();
                        list.add(new PathAndTime(p_314922_, filetime));
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            return list;
        }
        catch (NoSuchFileException nosuchfileexception) {
            return List.of();
        }
    }

    private static List<PathAndPriority> prioritizeFilesInDirs(List<PathAndTime> p_314924_) {
        ArrayList<PathAndPriority> list = new ArrayList<PathAndPriority>();
        Object2IntOpenHashMap object2intopenhashmap = new Object2IntOpenHashMap();
        for (PathAndTime downloadcachecleaner$pathandtime : p_314924_) {
            int i = object2intopenhashmap.addTo((Object)downloadcachecleaner$pathandtime.path.getParent(), 1);
            list.add(new PathAndPriority(downloadcachecleaner$pathandtime.path, i));
        }
        return list;
    }

    record PathAndTime(Path path, FileTime modifiedTime) {
        public static final Comparator<PathAndTime> NEWEST_FIRST = Comparator.comparing(PathAndTime::modifiedTime).reversed();
    }

    record PathAndPriority(Path path, int removalPriority) {
        public static final Comparator<PathAndPriority> HIGHEST_PRIORITY_FIRST = Comparator.comparing(PathAndPriority::removalPriority).reversed();
    }
}

