/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionType;
import net.minecraft.server.packs.resources.IoSupplier;

public class CompositePackResources
implements PackResources {
    private final PackResources primaryPackResources;
    private final List<PackResources> packResourcesStack;

    public CompositePackResources(PackResources p_296246_, List<PackResources> p_294643_) {
        this.primaryPackResources = p_296246_;
        ArrayList<PackResources> list = new ArrayList<PackResources>(p_294643_.size() + 1);
        list.addAll(Lists.reverse(p_294643_));
        list.add(p_296246_);
        this.packResourcesStack = List.copyOf(list);
    }

    @Override
    @Nullable
    public IoSupplier<InputStream> getRootResource(String ... p_295316_) {
        return this.primaryPackResources.getRootResource(p_295316_);
    }

    @Override
    @Nullable
    public IoSupplier<InputStream> getResource(PackType p_295406_, ResourceLocation p_296382_) {
        for (PackResources packresources : this.packResourcesStack) {
            IoSupplier<InputStream> iosupplier = packresources.getResource(p_295406_, p_296382_);
            if (iosupplier == null) continue;
            return iosupplier;
        }
        return null;
    }

    @Override
    public void listResources(PackType p_295490_, String p_296164_, String p_294691_, PackResources.ResourceOutput p_295313_) {
        HashMap<ResourceLocation, IoSupplier<InputStream>> map = new HashMap<ResourceLocation, IoSupplier<InputStream>>();
        for (PackResources packresources : this.packResourcesStack) {
            packresources.listResources(p_295490_, p_296164_, p_294691_, map::putIfAbsent);
        }
        map.forEach(p_295313_);
    }

    @Override
    public Set<String> getNamespaces(PackType p_294708_) {
        HashSet<String> set = new HashSet<String>();
        for (PackResources packresources : this.packResourcesStack) {
            set.addAll(packresources.getNamespaces(p_294708_));
        }
        return set;
    }

    @Override
    @Nullable
    public <T> T getMetadataSection(MetadataSectionType<T> p_389616_) throws IOException {
        return this.primaryPackResources.getMetadataSection(p_389616_);
    }

    @Override
    public PackLocationInfo location() {
        return this.primaryPackResources.location();
    }

    @Override
    public void close() {
        this.packResourcesStack.forEach(PackResources::close);
    }
}

