/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.metadata.MetadataSectionType;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.util.GsonHelper;
import org.slf4j.Logger;

public abstract class AbstractPackResources
implements PackResources {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final PackLocationInfo location;

    protected AbstractPackResources(PackLocationInfo p_326071_) {
        this.location = p_326071_;
    }

    @Override
    @Nullable
    public <T> T getMetadataSection(MetadataSectionType<T> p_389404_) throws IOException {
        T object;
        IoSupplier<InputStream> iosupplier = this.getRootResource("pack.mcmeta");
        if (iosupplier == null) {
            return null;
        }
        try (InputStream inputstream = iosupplier.get();){
            object = AbstractPackResources.getMetadataFromStream(p_389404_, inputstream);
        }
        return object;
    }

    @Nullable
    public static <T> T getMetadataFromStream(MetadataSectionType<T> p_389726_, InputStream p_10216_) {
        JsonObject jsonobject;
        try (BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(p_10216_, StandardCharsets.UTF_8));){
            jsonobject = GsonHelper.parse(bufferedreader);
        }
        catch (Exception exception) {
            LOGGER.error("Couldn't load {} metadata", (Object)p_389726_.name(), (Object)exception);
            return null;
        }
        return !jsonobject.has(p_389726_.name()) ? null : p_389726_.codec().parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonobject.get(p_389726_.name())).ifError(p_389537_ -> LOGGER.error("Couldn't load {} metadata: {}", (Object)p_389726_.name(), p_389537_)).result().orElse(null);
    }

    @Override
    public PackLocationInfo location() {
        return this.location;
    }

    public String toString() {
        return String.format(Locale.ROOT, "%s: %s", this.getClass().getName(), this.location.id());
    }
}

