/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.mojang.logging.LogUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Locale;
import net.minecraft.server.ServerInfo;
import net.minecraft.server.network.LegacyProtocolUtils;
import org.slf4j.Logger;

public class LegacyQueryHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ServerInfo server;

    public LegacyQueryHandler(ServerInfo p_296029_) {
        this.server = p_296029_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void channelRead(ChannelHandlerContext p_9686_, Object p_9687_) {
        block13: {
            block14: {
                block11: {
                    block12: {
                        block16: {
                            block9: {
                                block10: {
                                    bytebuf = (ByteBuf)p_9687_;
                                    bytebuf.markReaderIndex();
                                    flag = true;
                                    if (bytebuf.readUnsignedByte() == 254) break block9;
                                    if (!flag) break block10;
                                    bytebuf.resetReaderIndex();
                                    p_9686_.channel().pipeline().remove((ChannelHandler)this);
                                    p_9686_.fireChannelRead(p_9687_);
                                }
                                return;
                            }
                            socketaddress = p_9686_.channel().remoteAddress();
                            i = bytebuf.readableBytes();
                            if (i != 0) break block16;
                            LegacyQueryHandler.LOGGER.debug("Ping: (<1.3.x) from {}", (Object)socketaddress);
                            s = LegacyQueryHandler.createVersion0Response(this.server);
                            LegacyQueryHandler.sendFlushAndClose(p_9686_, LegacyQueryHandler.createLegacyDisconnectPacket(p_9686_.alloc(), s));
                            ** GOTO lbl58
                        }
                        if (bytebuf.readUnsignedByte() == 1) break block11;
                        if (!flag) break block12;
                        bytebuf.resetReaderIndex();
                        p_9686_.channel().pipeline().remove((ChannelHandler)this);
                        p_9686_.fireChannelRead(p_9687_);
                    }
                    return;
                }
                if (!bytebuf.isReadable()) ** GOTO lbl54
                if (LegacyQueryHandler.readCustomPayloadPacket(bytebuf)) break block13;
                if (!flag) break block14;
                bytebuf.resetReaderIndex();
                p_9686_.channel().pipeline().remove((ChannelHandler)this);
                p_9686_.fireChannelRead(p_9687_);
            }
            return;
        }
        try {
            try {
                block17: {
                    LegacyQueryHandler.LOGGER.debug("Ping: (1.6) from {}", (Object)socketaddress);
                    break block17;
lbl54:
                    // 1 sources

                    LegacyQueryHandler.LOGGER.debug("Ping: (1.4-1.5.x) from {}", (Object)socketaddress);
                }
                s1 = LegacyQueryHandler.createVersion1Response(this.server);
                LegacyQueryHandler.sendFlushAndClose(p_9686_, LegacyQueryHandler.createLegacyDisconnectPacket(p_9686_.alloc(), s1));
lbl58:
                // 2 sources

                bytebuf.release();
                flag = false;
            }
            catch (RuntimeException var5_6) {
                // empty catch block
            }
        }
        catch (Throwable var8_10) {
            throw var8_10;
        }
        finally {
            if (flag) {
                bytebuf.resetReaderIndex();
                p_9686_.channel().pipeline().remove((ChannelHandler)this);
                p_9686_.fireChannelRead(p_9687_);
            }
        }
    }

    private static boolean readCustomPayloadPacket(ByteBuf p_294725_) {
        short short1 = p_294725_.readUnsignedByte();
        if (short1 != 250) {
            return false;
        }
        String s = LegacyProtocolUtils.readLegacyString(p_294725_);
        if (!"MC|PingHost".equals(s)) {
            return false;
        }
        int i = p_294725_.readUnsignedShort();
        if (p_294725_.readableBytes() != i) {
            return false;
        }
        short short2 = p_294725_.readUnsignedByte();
        if (short2 < 73) {
            return false;
        }
        String s1 = LegacyProtocolUtils.readLegacyString(p_294725_);
        int j = p_294725_.readInt();
        return j <= 65535;
    }

    private static String createVersion0Response(ServerInfo p_294449_) {
        return String.format(Locale.ROOT, "%s\u00a7%d\u00a7%d", p_294449_.getMotd(), p_294449_.getPlayerCount(), p_294449_.getMaxPlayers());
    }

    private static String createVersion1Response(ServerInfo p_295503_) {
        return String.format(Locale.ROOT, "\u00a71\u0000%d\u0000%s\u0000%s\u0000%d\u0000%d", 127, p_295503_.getServerVersion(), p_295503_.getMotd(), p_295503_.getPlayerCount(), p_295503_.getMaxPlayers());
    }

    private static void sendFlushAndClose(ChannelHandlerContext p_9681_, ByteBuf p_9682_) {
        p_9681_.pipeline().firstContext().writeAndFlush((Object)p_9682_).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private static ByteBuf createLegacyDisconnectPacket(ByteBufAllocator p_294764_, String p_296452_) {
        ByteBuf bytebuf = p_294764_.buffer();
        bytebuf.writeByte(255);
        LegacyProtocolUtils.writeLegacyString(bytebuf, p_296452_);
        return bytebuf;
    }
}

