/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.annotations.VisibleForTesting;
import java.util.function.Consumer;
import net.minecraft.world.level.ChunkPos;

public interface ChunkTrackingView {
    public static final ChunkTrackingView EMPTY = new ChunkTrackingView(){

        @Override
        public boolean contains(int p_294225_, int p_294897_, boolean p_294644_) {
            return false;
        }

        @Override
        public void forEach(Consumer<ChunkPos> p_295201_) {
        }
    };

    public static ChunkTrackingView of(ChunkPos p_296254_, int p_295979_) {
        return new Positioned(p_296254_, p_295979_);
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public static void difference(ChunkTrackingView p_294391_, ChunkTrackingView p_294272_, Consumer<ChunkPos> p_295078_, Consumer<ChunkPos> p_294115_) {
        Positioned chunktrackingview$positioned1;
        Positioned chunktrackingview$positioned;
        block7: {
            block6: {
                if (p_294391_.equals(p_294272_)) return;
                if (!(p_294391_ instanceof Positioned)) break block6;
                chunktrackingview$positioned = (Positioned)p_294391_;
                if (p_294272_ instanceof Positioned && chunktrackingview$positioned.squareIntersects(chunktrackingview$positioned1 = (Positioned)p_294272_)) break block7;
            }
            p_294391_.forEach(p_294115_);
            p_294272_.forEach(p_295078_);
            return;
        }
        int i = Math.min(chunktrackingview$positioned.minX(), chunktrackingview$positioned1.minX());
        int j = Math.min(chunktrackingview$positioned.minZ(), chunktrackingview$positioned1.minZ());
        int k = Math.max(chunktrackingview$positioned.maxX(), chunktrackingview$positioned1.maxX());
        int l = Math.max(chunktrackingview$positioned.maxZ(), chunktrackingview$positioned1.maxZ());
        int i1 = i;
        while (i1 <= k) {
            for (int j1 = j; j1 <= l; ++j1) {
                boolean flag1;
                boolean flag = chunktrackingview$positioned.contains(i1, j1);
                if (flag == (flag1 = chunktrackingview$positioned1.contains(i1, j1))) continue;
                if (flag1) {
                    p_295078_.accept(new ChunkPos(i1, j1));
                    continue;
                }
                p_294115_.accept(new ChunkPos(i1, j1));
            }
            ++i1;
        }
    }

    default public boolean contains(ChunkPos p_296112_) {
        return this.contains(p_296112_.x, p_296112_.z);
    }

    default public boolean contains(int p_295374_, int p_296479_) {
        return this.contains(p_295374_, p_296479_, true);
    }

    public boolean contains(int var1, int var2, boolean var3);

    public void forEach(Consumer<ChunkPos> var1);

    default public boolean isInViewDistance(int p_295863_, int p_294569_) {
        return this.contains(p_295863_, p_294569_, false);
    }

    public static boolean isInViewDistance(int p_294551_, int p_294918_, int p_296415_, int p_296475_, int p_295248_) {
        return ChunkTrackingView.isWithinDistance(p_294551_, p_294918_, p_296415_, p_296475_, p_295248_, false);
    }

    public static boolean isWithinDistance(int p_294927_, int p_295703_, int p_294990_, int p_295161_, int p_295394_, boolean p_295219_) {
        int i = p_295219_ ? 2 : 1;
        long j = Math.max(0, Math.abs(p_295161_ - p_294927_) - i);
        long k = Math.max(0, Math.abs(p_295394_ - p_295703_) - i);
        long l = j * j + k * k;
        int i1 = p_294990_ * p_294990_;
        return l < (long)i1;
    }

    public record Positioned(ChunkPos center, int viewDistance) implements ChunkTrackingView
    {
        int minX() {
            return this.center.x - this.viewDistance - 1;
        }

        int minZ() {
            return this.center.z - this.viewDistance - 1;
        }

        int maxX() {
            return this.center.x + this.viewDistance + 1;
        }

        int maxZ() {
            return this.center.z + this.viewDistance + 1;
        }

        @VisibleForTesting
        protected boolean squareIntersects(Positioned p_295100_) {
            return this.minX() <= p_295100_.maxX() && this.maxX() >= p_295100_.minX() && this.minZ() <= p_295100_.maxZ() && this.maxZ() >= p_295100_.minZ();
        }

        @Override
        public boolean contains(int p_295177_, int p_294248_, boolean p_294703_) {
            return ChunkTrackingView.isWithinDistance(this.center.x, this.center.z, this.viewDistance, p_295177_, p_294248_, p_294703_);
        }

        @Override
        public void forEach(Consumer<ChunkPos> p_294236_) {
            for (int i = this.minX(); i <= this.maxX(); ++i) {
                for (int j = this.minZ(); j <= this.maxZ(); ++j) {
                    if (!this.contains(i, j)) continue;
                    p_294236_.accept(new ChunkPos(i, j));
                }
            }
        }
    }
}

