/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public interface ChunkResult<T> {
    public static <T> ChunkResult<T> of(T p_330787_) {
        return new Success<T>(p_330787_);
    }

    public static <T> ChunkResult<T> error(String p_330756_) {
        return ChunkResult.error(() -> p_330756_);
    }

    public static <T> ChunkResult<T> error(Supplier<String> p_331226_) {
        return new Fail(p_331226_);
    }

    public boolean isSuccess();

    @Nullable
    public T orElse(@Nullable T var1);

    @Nullable
    public static <R> R orElse(ChunkResult<? extends R> p_331283_, @Nullable R p_331474_) {
        R r = p_331283_.orElse(null);
        return r != null ? r : (R)p_331474_;
    }

    @Nullable
    public String getError();

    public ChunkResult<T> ifSuccess(Consumer<T> var1);

    public <R> ChunkResult<R> map(Function<T, R> var1);

    public <E extends Throwable> T orElseThrow(Supplier<E> var1) throws E;

    public record Success<T>(T value) implements ChunkResult<T>
    {
        @Override
        public boolean isSuccess() {
            return true;
        }

        @Override
        public T orElse(@Nullable T p_331661_) {
            return this.value;
        }

        @Override
        @Nullable
        public String getError() {
            return null;
        }

        @Override
        public ChunkResult<T> ifSuccess(Consumer<T> p_330331_) {
            p_330331_.accept(this.value);
            return this;
        }

        @Override
        public <R> ChunkResult<R> map(Function<T, R> p_330743_) {
            return new Success<R>(p_330743_.apply(this.value));
        }

        @Override
        public <E extends Throwable> T orElseThrow(Supplier<E> p_332180_) throws E {
            return this.value;
        }
    }

    public record Fail<T>(Supplier<String> error) implements ChunkResult<T>
    {
        @Override
        public boolean isSuccess() {
            return false;
        }

        @Override
        @Nullable
        public T orElse(@Nullable T p_332121_) {
            return p_332121_;
        }

        @Override
        public String getError() {
            return this.error.get();
        }

        @Override
        public ChunkResult<T> ifSuccess(Consumer<T> p_332025_) {
            return this;
        }

        @Override
        public <R> ChunkResult<R> map(Function<T, R> p_331060_) {
            return new Fail<T>(this.error);
        }

        @Override
        public <E extends Throwable> T orElseThrow(Supplier<E> p_331373_) throws E {
            throw (Throwable)p_331373_.get();
        }
    }
}

