/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dialog.input;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.server.dialog.Dialog;
import net.minecraft.server.dialog.input.InputControl;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;

public record NumberRangeInput(int width, Component label, String labelFormat, RangeInfo rangeInfo) implements InputControl
{
    public static final MapCodec<NumberRangeInput> MAP_CODEC = RecordCodecBuilder.mapCodec(p_426967_ -> p_426967_.group((App)Dialog.WIDTH_CODEC.optionalFieldOf("width", (Object)200).forGetter(NumberRangeInput::width), (App)ComponentSerialization.CODEC.fieldOf("label").forGetter(NumberRangeInput::label), (App)Codec.STRING.optionalFieldOf("label_format", (Object)"options.generic_value").forGetter(NumberRangeInput::labelFormat), (App)RangeInfo.MAP_CODEC.forGetter(NumberRangeInput::rangeInfo)).apply((Applicative)p_426967_, NumberRangeInput::new));

    public MapCodec<NumberRangeInput> mapCodec() {
        return MAP_CODEC;
    }

    public Component computeLabel(String p_426283_) {
        return Component.translatable(this.labelFormat, this.label, p_426283_);
    }

    public record RangeInfo(float start, float end, Optional<Float> initial, Optional<Float> step) {
        public static final MapCodec<RangeInfo> MAP_CODEC = RecordCodecBuilder.mapCodec(p_426968_ -> p_426968_.group((App)Codec.FLOAT.fieldOf("start").forGetter(RangeInfo::start), (App)Codec.FLOAT.fieldOf("end").forGetter(RangeInfo::end), (App)Codec.FLOAT.optionalFieldOf("initial").forGetter(RangeInfo::initial), (App)ExtraCodecs.POSITIVE_FLOAT.optionalFieldOf("step").forGetter(RangeInfo::step)).apply((Applicative)p_426968_, RangeInfo::new)).validate(p_425998_ -> {
            if (p_425998_.initial.isPresent()) {
                double d0 = p_425998_.initial.get().floatValue();
                double d1 = Math.min(p_425998_.start, p_425998_.end);
                double d2 = Math.max(p_425998_.start, p_425998_.end);
                if (d0 < d1 || d0 > d2) {
                    return DataResult.error(() -> "Initial value " + d0 + " is outside of range [" + d1 + ", " + d2 + "]");
                }
            }
            return DataResult.success((Object)p_425998_);
        });

        public float computeScaledValue(float p_427226_) {
            float f3;
            int i;
            float f = Mth.lerp(p_427226_, this.start, this.end);
            if (this.step.isEmpty()) {
                return f;
            }
            float f1 = this.step.get().floatValue();
            float f2 = this.initialScaledValue();
            float f4 = f2 + (float)(i = Math.round((f3 = f - f2) / f1)) * f1;
            if (!this.isOutOfRange(f4)) {
                return f4;
            }
            int j = i - Mth.sign(i);
            return f2 + (float)j * f1;
        }

        private boolean isOutOfRange(float p_427366_) {
            float f = this.scaledValueToSlider(p_427366_);
            return (double)f < 0.0 || (double)f > 1.0;
        }

        private float initialScaledValue() {
            return this.initial.isPresent() ? this.initial.get().floatValue() : (this.start + this.end) / 2.0f;
        }

        public float initialSliderValue() {
            float f = this.initialScaledValue();
            return this.scaledValueToSlider(f);
        }

        private float scaledValueToSlider(float p_427373_) {
            return this.start == this.end ? 0.5f : Mth.inverseLerp(p_427373_, this.start, this.end);
        }
    }
}

