/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Sets;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.world.entity.Entity;

public class TagCommand {
    private static final SimpleCommandExceptionType ERROR_ADD_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.tag.add.failed"));
    private static final SimpleCommandExceptionType ERROR_REMOVE_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.tag.remove.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> p_138837_) {
        p_138837_.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("tag").requires(Commands.hasPermission(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("targets", EntityArgument.entities()).then(Commands.literal("add").then(Commands.argument("name", StringArgumentType.word()).executes(p_138861_ -> TagCommand.addTag((CommandSourceStack)p_138861_.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)p_138861_, "targets"), StringArgumentType.getString((CommandContext)p_138861_, (String)"name")))))).then(Commands.literal("remove").then(Commands.argument("name", StringArgumentType.word()).suggests((p_138841_, p_138842_) -> SharedSuggestionProvider.suggest(TagCommand.getTags(EntityArgument.getEntities((CommandContext<CommandSourceStack>)p_138841_, "targets")), p_138842_)).executes(p_138855_ -> TagCommand.removeTag((CommandSourceStack)p_138855_.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)p_138855_, "targets"), StringArgumentType.getString((CommandContext)p_138855_, (String)"name")))))).then(Commands.literal("list").executes(p_138839_ -> TagCommand.listTags((CommandSourceStack)p_138839_.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)p_138839_, "targets"))))));
    }

    private static Collection<String> getTags(Collection<? extends Entity> p_138853_) {
        HashSet set = Sets.newHashSet();
        for (Entity entity : p_138853_) {
            set.addAll(entity.getTags());
        }
        return set;
    }

    private static int addTag(CommandSourceStack p_138849_, Collection<? extends Entity> p_138850_, String p_138851_) throws CommandSyntaxException {
        int i = 0;
        for (Entity entity : p_138850_) {
            if (!entity.addTag(p_138851_)) continue;
            ++i;
        }
        if (i == 0) {
            throw ERROR_ADD_FAILED.create();
        }
        if (p_138850_.size() == 1) {
            p_138849_.sendSuccess(() -> Component.translatable("commands.tag.add.success.single", p_138851_, ((Entity)p_138850_.iterator().next()).getDisplayName()), true);
        } else {
            p_138849_.sendSuccess(() -> Component.translatable("commands.tag.add.success.multiple", p_138851_, p_138850_.size()), true);
        }
        return i;
    }

    private static int removeTag(CommandSourceStack p_138857_, Collection<? extends Entity> p_138858_, String p_138859_) throws CommandSyntaxException {
        int i = 0;
        for (Entity entity : p_138858_) {
            if (!entity.removeTag(p_138859_)) continue;
            ++i;
        }
        if (i == 0) {
            throw ERROR_REMOVE_FAILED.create();
        }
        if (p_138858_.size() == 1) {
            p_138857_.sendSuccess(() -> Component.translatable("commands.tag.remove.success.single", p_138859_, ((Entity)p_138858_.iterator().next()).getDisplayName()), true);
        } else {
            p_138857_.sendSuccess(() -> Component.translatable("commands.tag.remove.success.multiple", p_138859_, p_138858_.size()), true);
        }
        return i;
    }

    private static int listTags(CommandSourceStack p_138846_, Collection<? extends Entity> p_138847_) {
        HashSet set = Sets.newHashSet();
        for (Entity entity : p_138847_) {
            set.addAll(entity.getTags());
        }
        if (p_138847_.size() == 1) {
            Entity entity1 = p_138847_.iterator().next();
            if (set.isEmpty()) {
                p_138846_.sendSuccess(() -> Component.translatable("commands.tag.list.single.empty", entity1.getDisplayName()), false);
            } else {
                p_138846_.sendSuccess(() -> Component.translatable("commands.tag.list.single.success", entity1.getDisplayName(), set.size(), ComponentUtils.formatList(set)), false);
            }
        } else if (set.isEmpty()) {
            p_138846_.sendSuccess(() -> Component.translatable("commands.tag.list.multiple.empty", p_138847_.size()), false);
        } else {
            p_138846_.sendSuccess(() -> Component.translatable("commands.tag.list.multiple.success", p_138847_.size(), set.size(), ComponentUtils.formatList(set)), false);
        }
        return set.size();
    }
}

