/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ContextChain;
import com.mojang.brigadier.tree.CommandNode;
import java.util.List;
import net.minecraft.commands.Commands;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.execution.ChainModifiers;
import net.minecraft.commands.execution.CustomCommandExecutor;
import net.minecraft.commands.execution.CustomModifierExecutor;
import net.minecraft.commands.execution.ExecutionControl;
import net.minecraft.commands.execution.Frame;
import net.minecraft.commands.execution.tasks.BuildContexts;
import net.minecraft.commands.execution.tasks.FallthroughTask;

public class ReturnCommand {
    public static <T extends ExecutionCommandSource<T>> void register(CommandDispatcher<T> p_282091_) {
        p_282091_.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"return").requires(Commands.hasPermission(2))).then(RequiredArgumentBuilder.argument((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(new ReturnValueCustomExecutor()))).then(LiteralArgumentBuilder.literal((String)"fail").executes(new ReturnFailCustomExecutor()))).then(LiteralArgumentBuilder.literal((String)"run").forward((CommandNode)p_282091_.getRoot(), new ReturnFromCommandCustomModifier(), false)));
    }

    static class ReturnValueCustomExecutor<T extends ExecutionCommandSource<T>>
    implements CustomCommandExecutor.CommandAdapter<T> {
        ReturnValueCustomExecutor() {
        }

        @Override
        public void run(T p_309669_, ContextChain<T> p_306161_, ChainModifiers p_309665_, ExecutionControl<T> p_306298_) {
            int i = IntegerArgumentType.getInteger((CommandContext)p_306161_.getTopContext(), (String)"value");
            p_309669_.callback().onSuccess(i);
            Frame frame = p_306298_.currentFrame();
            frame.returnSuccess(i);
            frame.discard();
        }
    }

    static class ReturnFailCustomExecutor<T extends ExecutionCommandSource<T>>
    implements CustomCommandExecutor.CommandAdapter<T> {
        ReturnFailCustomExecutor() {
        }

        @Override
        public void run(T p_309679_, ContextChain<T> p_309539_, ChainModifiers p_309649_, ExecutionControl<T> p_309599_) {
            p_309679_.callback().onFailure();
            Frame frame = p_309599_.currentFrame();
            frame.returnFailure();
            frame.discard();
        }
    }

    static class ReturnFromCommandCustomModifier<T extends ExecutionCommandSource<T>>
    implements CustomModifierExecutor.ModifierAdapter<T> {
        ReturnFromCommandCustomModifier() {
        }

        @Override
        public void apply(T p_309535_, List<T> p_305925_, ContextChain<T> p_305969_, ChainModifiers p_309676_, ExecutionControl<T> p_305873_) {
            if (p_305925_.isEmpty()) {
                if (p_309676_.isReturn()) {
                    p_305873_.queueNext(FallthroughTask.instance());
                }
            } else {
                p_305873_.currentFrame().discard();
                ContextChain contextchain = p_305969_.nextStage();
                String s = contextchain.getTopContext().getInput();
                p_305873_.queueNext(new BuildContexts.Continuation<T>(s, contextchain, p_309676_.setReturn(), p_309535_, p_305925_));
            }
        }
    }
}

