/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.world.level.storage.WorldData;
import net.neoforged.neoforge.resource.ResourcePackLoader;
import org.slf4j.Logger;

public class ReloadCommand {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void reloadPacks(Collection<String> p_138236_, CommandSourceStack p_138237_) {
        p_138237_.getServer().reloadResources(p_138236_).exceptionally(p_138234_ -> {
            LOGGER.warn("Failed to execute reload", p_138234_);
            p_138237_.sendFailure(Component.translatable("commands.reload.failure"));
            return null;
        });
    }

    private static Collection<String> discoverNewPacks(PackRepository p_138223_, WorldData p_138224_, Collection<String> p_138225_) {
        p_138223_.reload();
        ArrayList collection = Lists.newArrayList(p_138225_);
        List<String> collection1 = p_138224_.getDataConfiguration().dataPacks().getDisabled();
        for (String s : p_138223_.getAvailableIds()) {
            if (collection1.contains(s) || collection.contains(s)) continue;
            collection.add(s);
        }
        ResourcePackLoader.reorderNewlyDiscoveredPacks((Collection)collection, p_138225_, (PackRepository)p_138223_);
        return collection;
    }

    public static void register(CommandDispatcher<CommandSourceStack> p_138227_) {
        p_138227_.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("reload").requires(Commands.hasPermission(2))).executes(p_288528_ -> {
            CommandSourceStack commandsourcestack = (CommandSourceStack)p_288528_.getSource();
            MinecraftServer minecraftserver = commandsourcestack.getServer();
            PackRepository packrepository = minecraftserver.getPackRepository();
            WorldData worlddata = minecraftserver.getWorldData();
            Collection<String> collection = packrepository.getSelectedIds();
            Collection<String> collection1 = ReloadCommand.discoverNewPacks(packrepository, worlddata, collection);
            commandsourcestack.sendSuccess(() -> Component.translatable("commands.reload.success"), true);
            ReloadCommand.reloadPacks(collection1, commandsourcestack);
            return 0;
        }));
    }
}

