/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.RangeArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.RandomSequences;

public class RandomCommand {
    private static final SimpleCommandExceptionType ERROR_RANGE_TOO_LARGE = new SimpleCommandExceptionType((Message)Component.translatable("commands.random.error.range_too_large"));
    private static final SimpleCommandExceptionType ERROR_RANGE_TOO_SMALL = new SimpleCommandExceptionType((Message)Component.translatable("commands.random.error.range_too_small"));

    public static void register(CommandDispatcher<CommandSourceStack> p_295018_) {
        p_295018_.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("random").then(RandomCommand.drawRandomValueTree("value", false))).then(RandomCommand.drawRandomValueTree("roll", true))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("reset").requires(Commands.hasPermission(2))).then(((LiteralArgumentBuilder)Commands.literal("*").executes(p_295916_ -> RandomCommand.resetAllSequences((CommandSourceStack)p_295916_.getSource()))).then(((RequiredArgumentBuilder)Commands.argument("seed", IntegerArgumentType.integer()).executes(p_294436_ -> RandomCommand.resetAllSequencesAndSetNewDefaults((CommandSourceStack)p_294436_.getSource(), IntegerArgumentType.getInteger((CommandContext)p_294436_, (String)"seed"), true, true))).then(((RequiredArgumentBuilder)Commands.argument("includeWorldSeed", BoolArgumentType.bool()).executes(p_295162_ -> RandomCommand.resetAllSequencesAndSetNewDefaults((CommandSourceStack)p_295162_.getSource(), IntegerArgumentType.getInteger((CommandContext)p_295162_, (String)"seed"), BoolArgumentType.getBool((CommandContext)p_295162_, (String)"includeWorldSeed"), true))).then(Commands.argument("includeSequenceId", BoolArgumentType.bool()).executes(p_295871_ -> RandomCommand.resetAllSequencesAndSetNewDefaults((CommandSourceStack)p_295871_.getSource(), IntegerArgumentType.getInteger((CommandContext)p_295871_, (String)"seed"), BoolArgumentType.getBool((CommandContext)p_295871_, (String)"includeWorldSeed"), BoolArgumentType.getBool((CommandContext)p_295871_, (String)"includeSequenceId")))))))).then(((RequiredArgumentBuilder)Commands.argument("sequence", ResourceLocationArgument.id()).suggests(RandomCommand::suggestRandomSequence).executes(p_295053_ -> RandomCommand.resetSequence((CommandSourceStack)p_295053_.getSource(), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)p_295053_, "sequence")))).then(((RequiredArgumentBuilder)Commands.argument("seed", IntegerArgumentType.integer()).executes(p_295487_ -> RandomCommand.resetSequence((CommandSourceStack)p_295487_.getSource(), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)p_295487_, "sequence"), IntegerArgumentType.getInteger((CommandContext)p_295487_, (String)"seed"), true, true))).then(((RequiredArgumentBuilder)Commands.argument("includeWorldSeed", BoolArgumentType.bool()).executes(p_294832_ -> RandomCommand.resetSequence((CommandSourceStack)p_294832_.getSource(), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)p_294832_, "sequence"), IntegerArgumentType.getInteger((CommandContext)p_294832_, (String)"seed"), BoolArgumentType.getBool((CommandContext)p_294832_, (String)"includeWorldSeed"), true))).then(Commands.argument("includeSequenceId", BoolArgumentType.bool()).executes(p_295213_ -> RandomCommand.resetSequence((CommandSourceStack)p_295213_.getSource(), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)p_295213_, "sequence"), IntegerArgumentType.getInteger((CommandContext)p_295213_, (String)"seed"), BoolArgumentType.getBool((CommandContext)p_295213_, (String)"includeWorldSeed"), BoolArgumentType.getBool((CommandContext)p_295213_, (String)"includeSequenceId")))))))));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> drawRandomValueTree(String p_295419_, boolean p_295785_) {
        return (LiteralArgumentBuilder)Commands.literal(p_295419_).then(((RequiredArgumentBuilder)Commands.argument("range", RangeArgument.intRange()).executes(p_294702_ -> RandomCommand.randomSample((CommandSourceStack)p_294702_.getSource(), RangeArgument.Ints.getRange((CommandContext<CommandSourceStack>)p_294702_, "range"), null, p_295785_))).then(((RequiredArgumentBuilder)Commands.argument("sequence", ResourceLocationArgument.id()).suggests(RandomCommand::suggestRandomSequence).requires(Commands.hasPermission(2))).executes(p_295226_ -> RandomCommand.randomSample((CommandSourceStack)p_295226_.getSource(), RangeArgument.Ints.getRange((CommandContext<CommandSourceStack>)p_295226_, "range"), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)p_295226_, "sequence"), p_295785_))));
    }

    private static CompletableFuture<Suggestions> suggestRandomSequence(CommandContext<CommandSourceStack> p_296223_, SuggestionsBuilder p_295797_) {
        ArrayList list = Lists.newArrayList();
        ((CommandSourceStack)p_296223_.getSource()).getLevel().getRandomSequences().forAllSequences((p_294879_, p_294337_) -> list.add(p_294879_.toString()));
        return SharedSuggestionProvider.suggest(list, p_295797_);
    }

    private static int randomSample(CommandSourceStack p_295774_, MinMaxBounds.Ints p_295453_, @Nullable ResourceLocation p_294336_, boolean p_296222_) throws CommandSyntaxException {
        RandomSource randomsource = p_294336_ != null ? p_295774_.getLevel().getRandomSequence(p_294336_) : p_295774_.getLevel().getRandom();
        int i = p_295453_.min().orElse(Integer.MIN_VALUE);
        int j = p_295453_.max().orElse(Integer.MAX_VALUE);
        long k = (long)j - (long)i;
        if (k == 0L) {
            throw ERROR_RANGE_TOO_SMALL.create();
        }
        if (k >= Integer.MAX_VALUE) {
            throw ERROR_RANGE_TOO_LARGE.create();
        }
        int l = Mth.randomBetweenInclusive(randomsource, i, j);
        if (p_296222_) {
            p_295774_.getServer().getPlayerList().broadcastSystemMessage(Component.translatable("commands.random.roll", p_295774_.getDisplayName(), l, i, j), false);
        } else {
            p_295774_.sendSuccess(() -> Component.translatable("commands.random.sample.success", l), false);
        }
        return l;
    }

    private static int resetSequence(CommandSourceStack p_295984_, ResourceLocation p_296220_) throws CommandSyntaxException {
        p_295984_.getLevel().getRandomSequences().reset(p_296220_);
        p_295984_.sendSuccess(() -> Component.translatable("commands.random.reset.success", Component.translationArg(p_296220_)), false);
        return 1;
    }

    private static int resetSequence(CommandSourceStack p_296416_, ResourceLocation p_294611_, int p_295199_, boolean p_295241_, boolean p_294844_) throws CommandSyntaxException {
        p_296416_.getLevel().getRandomSequences().reset(p_294611_, p_295199_, p_295241_, p_294844_);
        p_296416_.sendSuccess(() -> Component.translatable("commands.random.reset.success", Component.translationArg(p_294611_)), false);
        return 1;
    }

    private static int resetAllSequences(CommandSourceStack p_294291_) {
        int i = p_294291_.getLevel().getRandomSequences().clear();
        p_294291_.sendSuccess(() -> Component.translatable("commands.random.reset.all.success", i), false);
        return i;
    }

    private static int resetAllSequencesAndSetNewDefaults(CommandSourceStack p_294151_, int p_295754_, boolean p_294405_, boolean p_294396_) {
        RandomSequences randomsequences = p_294151_.getLevel().getRandomSequences();
        randomsequences.setSeedDefaults(p_295754_, p_294405_, p_294396_);
        int i = randomsequences.clear();
        p_294151_.sendSuccess(() -> Component.translatable("commands.random.reset.all.success", i), false);
        return i;
    }
}

