/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.Difficulty;

public class DifficultyCommand {
    private static final DynamicCommandExceptionType ERROR_ALREADY_DIFFICULT = new DynamicCommandExceptionType(p_304204_ -> Component.translatableEscape("commands.difficulty.failure", p_304204_));

    public static void register(CommandDispatcher<CommandSourceStack> p_136939_) {
        LiteralArgumentBuilder<CommandSourceStack> literalargumentbuilder = Commands.literal("difficulty");
        for (Difficulty difficulty : Difficulty.values()) {
            literalargumentbuilder.then(Commands.literal(difficulty.getKey()).executes(p_136937_ -> DifficultyCommand.setDifficulty((CommandSourceStack)p_136937_.getSource(), difficulty)));
        }
        p_136939_.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)literalargumentbuilder.requires(Commands.hasPermission(2))).executes(p_428122_ -> {
            Difficulty difficulty1 = ((CommandSourceStack)p_428122_.getSource()).getLevel().getDifficulty();
            ((CommandSourceStack)p_428122_.getSource()).sendSuccess(() -> Component.translatable("commands.difficulty.query", difficulty1.getDisplayName()), false);
            return difficulty1.getId();
        }));
    }

    public static int setDifficulty(CommandSourceStack p_136945_, Difficulty p_136946_) throws CommandSyntaxException {
        MinecraftServer minecraftserver = p_136945_.getServer();
        if (minecraftserver.getWorldData().getDifficulty() == p_136946_) {
            throw ERROR_ALREADY_DIFFICULT.create((Object)p_136946_.getKey());
        }
        minecraftserver.setDifficulty(p_136946_, true);
        p_136945_.sendSuccess(() -> Component.translatable("commands.difficulty.success", p_136946_.getDisplayName()), true);
        return 0;
    }
}

