/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.FileUtil;
import net.minecraft.SharedConstants;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ComponentArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.server.commands.ReloadCommand;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.storage.LevelResource;
import org.slf4j.Logger;

public class DataPackCommand {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final DynamicCommandExceptionType ERROR_UNKNOWN_PACK = new DynamicCommandExceptionType(p_304196_ -> Component.translatableEscape("commands.datapack.unknown", p_304196_));
    private static final DynamicCommandExceptionType ERROR_PACK_ALREADY_ENABLED = new DynamicCommandExceptionType(p_304199_ -> Component.translatableEscape("commands.datapack.enable.failed", p_304199_));
    private static final DynamicCommandExceptionType ERROR_PACK_ALREADY_DISABLED = new DynamicCommandExceptionType(p_304200_ -> Component.translatableEscape("commands.datapack.disable.failed", p_304200_));
    private static final DynamicCommandExceptionType ERROR_CANNOT_DISABLE_FEATURE = new DynamicCommandExceptionType(p_333496_ -> Component.translatableEscape("commands.datapack.disable.failed.feature", p_333496_));
    private static final Dynamic2CommandExceptionType ERROR_PACK_FEATURES_NOT_ENABLED = new Dynamic2CommandExceptionType((p_304197_, p_304198_) -> Component.translatableEscape("commands.datapack.enable.failed.no_flags", p_304197_, p_304198_));
    private static final DynamicCommandExceptionType ERROR_PACK_INVALID_NAME = new DynamicCommandExceptionType(p_415017_ -> Component.translatableEscape("commands.datapack.create.invalid_name", p_415017_));
    private static final DynamicCommandExceptionType ERROR_PACK_INVALID_FULL_NAME = new DynamicCommandExceptionType(p_415016_ -> Component.translatableEscape("commands.datapack.create.invalid_full_name", p_415016_));
    private static final DynamicCommandExceptionType ERROR_PACK_ALREADY_EXISTS = new DynamicCommandExceptionType(p_415013_ -> Component.translatableEscape("commands.datapack.create.already_exists", p_415013_));
    private static final Dynamic2CommandExceptionType ERROR_PACK_METADATA_ENCODE_FAILURE = new Dynamic2CommandExceptionType((p_415018_, p_415019_) -> Component.translatableEscape("commands.datapack.create.metadata_encode_failure", p_415018_, p_415019_));
    private static final DynamicCommandExceptionType ERROR_PACK_IO_FAILURE = new DynamicCommandExceptionType(p_428121_ -> Component.translatableEscape("commands.datapack.create.io_failure", p_428121_));
    private static final SuggestionProvider<CommandSourceStack> SELECTED_PACKS = (p_136848_, p_136849_) -> SharedSuggestionProvider.suggest(((CommandSourceStack)p_136848_.getSource()).getServer().getPackRepository().getSelectedIds().stream().map(StringArgumentType::escapeIfRequired), p_136849_);
    private static final SuggestionProvider<CommandSourceStack> UNSELECTED_PACKS = (p_248113_, p_248114_) -> {
        PackRepository packrepository = ((CommandSourceStack)p_248113_.getSource()).getServer().getPackRepository();
        Collection<String> collection = packrepository.getSelectedIds();
        FeatureFlagSet featureflagset = ((CommandSourceStack)p_248113_.getSource()).enabledFeatures();
        return SharedSuggestionProvider.suggest(packrepository.getAvailablePacks().stream().filter(p_248116_ -> p_248116_.getRequestedFeatures().isSubsetOf(featureflagset)).map(Pack::getId).filter(p_250072_ -> !collection.contains(p_250072_)).map(StringArgumentType::escapeIfRequired), p_248114_);
    };

    public static void register(CommandDispatcher<CommandSourceStack> p_136809_, CommandBuildContext p_416025_) {
        p_136809_.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("datapack").requires(Commands.hasPermission(2))).then(Commands.literal("enable").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("name", StringArgumentType.string()).suggests(UNSELECTED_PACKS).executes(p_136876_ -> DataPackCommand.enablePack((CommandSourceStack)p_136876_.getSource(), DataPackCommand.getPack((CommandContext<CommandSourceStack>)p_136876_, "name", true), (p_180059_, p_180060_) -> p_180060_.getDefaultPosition().insert(p_180059_, p_180060_, Pack::selectionConfig, false)))).then(Commands.literal("after").then(Commands.argument("existing", StringArgumentType.string()).suggests(SELECTED_PACKS).executes(p_136880_ -> DataPackCommand.enablePack((CommandSourceStack)p_136880_.getSource(), DataPackCommand.getPack((CommandContext<CommandSourceStack>)p_136880_, "name", true), (p_180056_, p_180057_) -> p_180056_.add(p_180056_.indexOf(DataPackCommand.getPack((CommandContext<CommandSourceStack>)p_136880_, "existing", false)) + 1, p_180057_)))))).then(Commands.literal("before").then(Commands.argument("existing", StringArgumentType.string()).suggests(SELECTED_PACKS).executes(p_136878_ -> DataPackCommand.enablePack((CommandSourceStack)p_136878_.getSource(), DataPackCommand.getPack((CommandContext<CommandSourceStack>)p_136878_, "name", true), (p_180046_, p_180047_) -> p_180046_.add(p_180046_.indexOf(DataPackCommand.getPack((CommandContext<CommandSourceStack>)p_136878_, "existing", false)), p_180047_)))))).then(Commands.literal("last").executes(p_136874_ -> DataPackCommand.enablePack((CommandSourceStack)p_136874_.getSource(), DataPackCommand.getPack((CommandContext<CommandSourceStack>)p_136874_, "name", true), List::add)))).then(Commands.literal("first").executes(p_136882_ -> DataPackCommand.enablePack((CommandSourceStack)p_136882_.getSource(), DataPackCommand.getPack((CommandContext<CommandSourceStack>)p_136882_, "name", true), (p_180052_, p_180053_) -> p_180052_.add(0, p_180053_))))))).then(Commands.literal("disable").then(Commands.argument("name", StringArgumentType.string()).suggests(SELECTED_PACKS).executes(p_136870_ -> DataPackCommand.disablePack((CommandSourceStack)p_136870_.getSource(), DataPackCommand.getPack((CommandContext<CommandSourceStack>)p_136870_, "name", false)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("list").executes(p_136864_ -> DataPackCommand.listPacks((CommandSourceStack)p_136864_.getSource()))).then(Commands.literal("available").executes(p_136846_ -> DataPackCommand.listAvailablePacks((CommandSourceStack)p_136846_.getSource())))).then(Commands.literal("enabled").executes(p_136811_ -> DataPackCommand.listEnabledPacks((CommandSourceStack)p_136811_.getSource()))))).then(((LiteralArgumentBuilder)Commands.literal("create").requires(Commands.hasPermission(4))).then(Commands.argument("id", StringArgumentType.string()).then(Commands.argument("description", ComponentArgument.textComponent(p_416025_)).executes(p_415020_ -> DataPackCommand.createPack((CommandSourceStack)p_415020_.getSource(), StringArgumentType.getString((CommandContext)p_415020_, (String)"id"), ComponentArgument.getResolvedComponent((CommandContext<CommandSourceStack>)p_415020_, "description")))))));
    }

    private static int createPack(CommandSourceStack p_416736_, String p_416116_, Component p_416178_) throws CommandSyntaxException {
        Path path = p_416736_.getServer().getWorldPath(LevelResource.DATAPACK_DIR);
        if (!FileUtil.isValidStrictPathSegment(p_416116_)) {
            throw ERROR_PACK_INVALID_NAME.create((Object)p_416116_);
        }
        if (!FileUtil.isPathPartPortable(p_416116_)) {
            throw ERROR_PACK_INVALID_FULL_NAME.create((Object)p_416116_);
        }
        Path path1 = path.resolve(p_416116_);
        if (Files.exists(path1, new LinkOption[0])) {
            throw ERROR_PACK_ALREADY_EXISTS.create((Object)p_416116_);
        }
        PackMetadataSection packmetadatasection = new PackMetadataSection(p_416178_, SharedConstants.getCurrentVersion().packVersion(PackType.SERVER_DATA), Optional.empty());
        DataResult dataresult = PackMetadataSection.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)packmetadatasection);
        Optional optional = dataresult.error();
        if (optional.isPresent()) {
            throw ERROR_PACK_METADATA_ENCODE_FAILURE.create((Object)p_416116_, (Object)((DataResult.Error)optional.get()).message());
        }
        JsonObject jsonobject = new JsonObject();
        jsonobject.add(PackMetadataSection.TYPE.name(), (JsonElement)dataresult.getOrThrow());
        try {
            Files.createDirectory(path1, new FileAttribute[0]);
            Files.createDirectory(path1.resolve(PackType.SERVER_DATA.getDirectory()), new FileAttribute[0]);
            try (BufferedWriter bufferedwriter = Files.newBufferedWriter(path1.resolve("pack.mcmeta"), StandardCharsets.UTF_8, new OpenOption[0]);
                 JsonWriter jsonwriter = new JsonWriter((Writer)bufferedwriter);){
                jsonwriter.setSerializeNulls(false);
                jsonwriter.setIndent("  ");
                GsonHelper.writeValue(jsonwriter, (JsonElement)jsonobject, null);
            }
        }
        catch (IOException ioexception) {
            LOGGER.warn("Failed to create pack at {}", (Object)path.toAbsolutePath(), (Object)ioexception);
            throw ERROR_PACK_IO_FAILURE.create((Object)p_416116_);
        }
        p_416736_.sendSuccess(() -> Component.translatable("commands.datapack.create.success", p_416116_), true);
        return 1;
    }

    private static int enablePack(CommandSourceStack p_136829_, Pack p_136830_, Inserter p_136831_) throws CommandSyntaxException {
        PackRepository packrepository = p_136829_.getServer().getPackRepository();
        ArrayList list = Lists.newArrayList(packrepository.getSelectedPacks());
        p_136831_.apply(list, p_136830_);
        p_136829_.sendSuccess(() -> Component.translatable("commands.datapack.modify.enable", p_136830_.getChatLink(true)), true);
        ReloadCommand.reloadPacks(list.stream().map(Pack::getId).collect(Collectors.toList()), p_136829_);
        return list.size();
    }

    private static int disablePack(CommandSourceStack p_136826_, Pack p_136827_) {
        PackRepository packrepository = p_136826_.getServer().getPackRepository();
        ArrayList list = Lists.newArrayList(packrepository.getSelectedPacks());
        list.remove(p_136827_);
        p_136826_.sendSuccess(() -> Component.translatable("commands.datapack.modify.disable", p_136827_.getChatLink(true)), true);
        ReloadCommand.reloadPacks(list.stream().map(Pack::getId).collect(Collectors.toList()), p_136826_);
        return list.size();
    }

    private static int listPacks(CommandSourceStack p_136824_) {
        return DataPackCommand.listEnabledPacks(p_136824_) + DataPackCommand.listAvailablePacks(p_136824_);
    }

    private static int listAvailablePacks(CommandSourceStack p_136855_) {
        PackRepository packrepository = p_136855_.getServer().getPackRepository();
        packrepository.reload();
        Collection<Pack> collection = packrepository.getSelectedPacks();
        Collection<Pack> collection1 = packrepository.getAvailablePacks();
        FeatureFlagSet featureflagset = p_136855_.enabledFeatures();
        List<Pack> list = collection1.stream().filter(p_248121_ -> !collection.contains(p_248121_) && p_248121_.getRequestedFeatures().isSubsetOf(featureflagset)).toList();
        if (list.isEmpty()) {
            p_136855_.sendSuccess(() -> Component.translatable("commands.datapack.list.available.none"), false);
        } else {
            p_136855_.sendSuccess(() -> Component.translatable("commands.datapack.list.available.success", list.size(), ComponentUtils.formatList(list, p_136844_ -> p_136844_.getChatLink(false))), false);
        }
        return list.size();
    }

    private static int listEnabledPacks(CommandSourceStack p_136866_) {
        PackRepository packrepository = p_136866_.getServer().getPackRepository();
        packrepository.reload();
        List<Pack> collection = packrepository.getSelectedPacks().stream().filter(p -> !p.isHidden()).toList();
        if (collection.isEmpty()) {
            p_136866_.sendSuccess(() -> Component.translatable("commands.datapack.list.enabled.none"), false);
        } else {
            p_136866_.sendSuccess(() -> Component.translatable("commands.datapack.list.enabled.success", collection.size(), ComponentUtils.formatList(collection, p_136807_ -> p_136807_.getChatLink(true))), false);
        }
        return collection.size();
    }

    private static Pack getPack(CommandContext<CommandSourceStack> p_136816_, String p_136817_, boolean p_136818_) throws CommandSyntaxException {
        String s = StringArgumentType.getString(p_136816_, (String)p_136817_);
        PackRepository packrepository = ((CommandSourceStack)p_136816_.getSource()).getServer().getPackRepository();
        Pack pack = packrepository.getPack(s);
        if (pack == null) {
            throw ERROR_UNKNOWN_PACK.create((Object)s);
        }
        boolean flag = packrepository.getSelectedPacks().contains(pack);
        if (p_136818_ && flag) {
            throw ERROR_PACK_ALREADY_ENABLED.create((Object)s);
        }
        if (!p_136818_ && !flag) {
            throw ERROR_PACK_ALREADY_DISABLED.create((Object)s);
        }
        FeatureFlagSet featureflagset = ((CommandSourceStack)p_136816_.getSource()).enabledFeatures();
        FeatureFlagSet featureflagset1 = pack.getRequestedFeatures();
        if (!p_136818_ && !featureflagset1.isEmpty() && pack.getPackSource() == PackSource.FEATURE) {
            throw ERROR_CANNOT_DISABLE_FEATURE.create((Object)s);
        }
        if (!featureflagset1.isSubsetOf(featureflagset)) {
            throw ERROR_PACK_FEATURES_NOT_ENABLED.create((Object)s, (Object)FeatureFlags.printMissingFlags(featureflagset, featureflagset1));
        }
        return pack;
    }

    static interface Inserter {
        public void apply(List<Pack> var1, Pack var2) throws CommandSyntaxException;
    }
}

