/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.blocks.BlockPredicateArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.commands.InCommandFunction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.ticks.LevelTicks;
import org.slf4j.Logger;

public class CloneCommands {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final SimpleCommandExceptionType ERROR_OVERLAP = new SimpleCommandExceptionType((Message)Component.translatable("commands.clone.overlap"));
    private static final Dynamic2CommandExceptionType ERROR_AREA_TOO_LARGE = new Dynamic2CommandExceptionType((p_304194_, p_304195_) -> Component.translatableEscape("commands.clone.toobig", p_304194_, p_304195_));
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.clone.failed"));
    public static final Predicate<BlockInWorld> FILTER_AIR = p_359534_ -> !p_359534_.getState().isAir();

    public static void register(CommandDispatcher<CommandSourceStack> p_214424_, CommandBuildContext p_214425_) {
        p_214424_.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("clone").requires(Commands.hasPermission(2))).then(CloneCommands.beginEndDestinationAndModeSuffix(p_214425_, p_264757_ -> ((CommandSourceStack)p_264757_.getSource()).getLevel()))).then(Commands.literal("from").then(Commands.argument("sourceDimension", DimensionArgument.dimension()).then(CloneCommands.beginEndDestinationAndModeSuffix(p_214425_, p_264743_ -> DimensionArgument.getDimension((CommandContext<CommandSourceStack>)p_264743_, "sourceDimension"))))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> beginEndDestinationAndModeSuffix(CommandBuildContext p_265681_, InCommandFunction<CommandContext<CommandSourceStack>, ServerLevel> p_397938_) {
        return Commands.argument("begin", BlockPosArgument.blockPos()).then(((RequiredArgumentBuilder)Commands.argument("end", BlockPosArgument.blockPos()).then(CloneCommands.destinationAndStrictSuffix(p_265681_, p_397938_, p_264751_ -> ((CommandSourceStack)p_264751_.getSource()).getLevel()))).then(Commands.literal("to").then(Commands.argument("targetDimension", DimensionArgument.dimension()).then(CloneCommands.destinationAndStrictSuffix(p_265681_, p_397938_, p_264756_ -> DimensionArgument.getDimension((CommandContext<CommandSourceStack>)p_264756_, "targetDimension"))))));
    }

    private static DimensionAndPosition getLoadedDimensionAndPosition(CommandContext<CommandSourceStack> p_265513_, ServerLevel p_265183_, String p_265511_) throws CommandSyntaxException {
        BlockPos blockpos = BlockPosArgument.getLoadedBlockPos(p_265513_, p_265183_, p_265511_);
        return new DimensionAndPosition(p_265183_, blockpos);
    }

    private static ArgumentBuilder<CommandSourceStack, ?> destinationAndStrictSuffix(CommandBuildContext p_394289_, InCommandFunction<CommandContext<CommandSourceStack>, ServerLevel> p_397860_, InCommandFunction<CommandContext<CommandSourceStack>, ServerLevel> p_397792_) {
        InCommandFunction<CommandContext<CommandSourceStack>, DimensionAndPosition> incommandfunction = p_396524_ -> CloneCommands.getLoadedDimensionAndPosition((CommandContext<CommandSourceStack>)p_396524_, (ServerLevel)p_397860_.apply((CommandContext<CommandSourceStack>)p_396524_), "begin");
        InCommandFunction<CommandContext<CommandSourceStack>, DimensionAndPosition> incommandfunction1 = p_396503_ -> CloneCommands.getLoadedDimensionAndPosition((CommandContext<CommandSourceStack>)p_396503_, (ServerLevel)p_397860_.apply((CommandContext<CommandSourceStack>)p_396503_), "end");
        InCommandFunction<CommandContext<CommandSourceStack>, DimensionAndPosition> incommandfunction2 = p_396505_ -> CloneCommands.getLoadedDimensionAndPosition((CommandContext<CommandSourceStack>)p_396505_, (ServerLevel)p_397792_.apply((CommandContext<CommandSourceStack>)p_396505_), "destination");
        return CloneCommands.modeSuffix(p_394289_, incommandfunction, incommandfunction1, incommandfunction2, false, Commands.argument("destination", BlockPosArgument.blockPos())).then(CloneCommands.modeSuffix(p_394289_, incommandfunction, incommandfunction1, incommandfunction2, true, Commands.literal("strict")));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> modeSuffix(CommandBuildContext p_393631_, InCommandFunction<CommandContext<CommandSourceStack>, DimensionAndPosition> p_397485_, InCommandFunction<CommandContext<CommandSourceStack>, DimensionAndPosition> p_397966_, InCommandFunction<CommandContext<CommandSourceStack>, DimensionAndPosition> p_397447_, boolean p_394427_, ArgumentBuilder<CommandSourceStack, ?> p_394612_) {
        return p_394612_.executes(p_396510_ -> CloneCommands.clone((CommandSourceStack)p_396510_.getSource(), (DimensionAndPosition)p_397485_.apply(p_396510_), (DimensionAndPosition)p_397966_.apply(p_396510_), (DimensionAndPosition)p_397447_.apply(p_396510_), p_180041_ -> true, Mode.NORMAL, p_394427_)).then(CloneCommands.wrapWithCloneMode(p_397485_, p_397966_, p_397447_, p_264738_ -> p_180033_ -> true, p_394427_, Commands.literal("replace"))).then(CloneCommands.wrapWithCloneMode(p_397485_, p_397966_, p_397447_, p_264744_ -> FILTER_AIR, p_394427_, Commands.literal("masked"))).then(Commands.literal("filtered").then(CloneCommands.wrapWithCloneMode(p_397485_, p_397966_, p_397447_, p_264745_ -> BlockPredicateArgument.getBlockPredicate((CommandContext<CommandSourceStack>)p_264745_, "filter"), p_394427_, Commands.argument("filter", BlockPredicateArgument.blockPredicate(p_393631_)))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> wrapWithCloneMode(InCommandFunction<CommandContext<CommandSourceStack>, DimensionAndPosition> p_397931_, InCommandFunction<CommandContext<CommandSourceStack>, DimensionAndPosition> p_397162_, InCommandFunction<CommandContext<CommandSourceStack>, DimensionAndPosition> p_397777_, InCommandFunction<CommandContext<CommandSourceStack>, Predicate<BlockInWorld>> p_397479_, boolean p_394385_, ArgumentBuilder<CommandSourceStack, ?> p_265069_) {
        return p_265069_.executes(p_396516_ -> CloneCommands.clone((CommandSourceStack)p_396516_.getSource(), (DimensionAndPosition)p_397931_.apply(p_396516_), (DimensionAndPosition)p_397162_.apply(p_396516_), (DimensionAndPosition)p_397777_.apply(p_396516_), (Predicate)p_397479_.apply(p_396516_), Mode.NORMAL, p_394385_)).then(Commands.literal("force").executes(p_396530_ -> CloneCommands.clone((CommandSourceStack)p_396530_.getSource(), (DimensionAndPosition)p_397931_.apply(p_396530_), (DimensionAndPosition)p_397162_.apply(p_396530_), (DimensionAndPosition)p_397777_.apply(p_396530_), (Predicate)p_397479_.apply(p_396530_), Mode.FORCE, p_394385_))).then(Commands.literal("move").executes(p_396522_ -> CloneCommands.clone((CommandSourceStack)p_396522_.getSource(), (DimensionAndPosition)p_397931_.apply(p_396522_), (DimensionAndPosition)p_397162_.apply(p_396522_), (DimensionAndPosition)p_397777_.apply(p_396522_), (Predicate)p_397479_.apply(p_396522_), Mode.MOVE, p_394385_))).then(Commands.literal("normal").executes(p_396501_ -> CloneCommands.clone((CommandSourceStack)p_396501_.getSource(), (DimensionAndPosition)p_397931_.apply(p_396501_), (DimensionAndPosition)p_397162_.apply(p_396501_), (DimensionAndPosition)p_397777_.apply(p_396501_), (Predicate)p_397479_.apply(p_396501_), Mode.NORMAL, p_394385_)));
    }

    private static int clone(CommandSourceStack p_265047_, DimensionAndPosition p_265232_, DimensionAndPosition p_265188_, DimensionAndPosition p_265594_, Predicate<BlockInWorld> p_265585_, Mode p_265530_, boolean p_394351_) throws CommandSyntaxException {
        int j;
        BlockPos blockpos = p_265232_.position();
        BlockPos blockpos1 = p_265188_.position();
        BoundingBox boundingbox = BoundingBox.fromCorners(blockpos, blockpos1);
        BlockPos blockpos2 = p_265594_.position();
        BlockPos blockpos3 = blockpos2.offset(boundingbox.getLength());
        BoundingBox boundingbox1 = BoundingBox.fromCorners(blockpos2, blockpos3);
        ServerLevel serverlevel = p_265232_.dimension();
        ServerLevel serverlevel1 = p_265594_.dimension();
        if (!p_265530_.canOverlap() && serverlevel == serverlevel1 && boundingbox1.intersects(boundingbox)) {
            throw ERROR_OVERLAP.create();
        }
        int i = boundingbox.getXSpan() * boundingbox.getYSpan() * boundingbox.getZSpan();
        if (i > (j = p_265047_.getLevel().getGameRules().getInt(GameRules.RULE_COMMAND_MODIFICATION_BLOCK_LIMIT))) {
            throw ERROR_AREA_TOO_LARGE.create((Object)j, (Object)i);
        }
        if (!serverlevel.hasChunksAt(blockpos, blockpos1) || !serverlevel1.hasChunksAt(blockpos2, blockpos3)) {
            throw BlockPosArgument.ERROR_NOT_LOADED.create();
        }
        if (serverlevel1.isDebug()) {
            throw ERROR_FAILED.create();
        }
        ArrayList list = Lists.newArrayList();
        ArrayList list1 = Lists.newArrayList();
        ArrayList list2 = Lists.newArrayList();
        LinkedList deque = Lists.newLinkedList();
        int k = 0;
        try (ProblemReporter.ScopedCollector problemreporter$scopedcollector = new ProblemReporter.ScopedCollector(LOGGER);){
            BlockPos blockpos4 = new BlockPos(boundingbox1.minX() - boundingbox.minX(), boundingbox1.minY() - boundingbox.minY(), boundingbox1.minZ() - boundingbox.minZ());
            for (int l = boundingbox.minZ(); l <= boundingbox.maxZ(); ++l) {
                for (int i1 = boundingbox.minY(); i1 <= boundingbox.maxY(); ++i1) {
                    for (int j1 = boundingbox.minX(); j1 <= boundingbox.maxX(); ++j1) {
                        BlockPos blockpos5 = new BlockPos(j1, i1, l);
                        BlockPos blockpos6 = blockpos5.offset(blockpos4);
                        BlockInWorld blockinworld = new BlockInWorld(serverlevel, blockpos5, false);
                        BlockState blockstate = blockinworld.getState();
                        if (!p_265585_.test(blockinworld)) continue;
                        BlockEntity blockentity = serverlevel.getBlockEntity(blockpos5);
                        if (blockentity != null) {
                            TagValueOutput tagvalueoutput = TagValueOutput.createWithContext(problemreporter$scopedcollector.forChild(blockentity.problemPath()), p_265047_.registryAccess());
                            blockentity.saveCustomOnly(tagvalueoutput);
                            CloneBlockEntityInfo clonecommands$cloneblockentityinfo = new CloneBlockEntityInfo(tagvalueoutput.buildResult(), blockentity.components());
                            list1.add(new CloneBlockInfo(blockpos6, blockstate, clonecommands$cloneblockentityinfo, serverlevel1.getBlockState(blockpos6)));
                            deque.addLast(blockpos5);
                            continue;
                        }
                        if (!blockstate.isSolidRender() && !blockstate.isCollisionShapeFullBlock(serverlevel, blockpos5)) {
                            list2.add(new CloneBlockInfo(blockpos6, blockstate, null, serverlevel1.getBlockState(blockpos6)));
                            deque.addFirst(blockpos5);
                            continue;
                        }
                        list.add(new CloneBlockInfo(blockpos6, blockstate, null, serverlevel1.getBlockState(blockpos6)));
                        deque.addLast(blockpos5);
                    }
                }
            }
            int l1 = 2 | (p_394351_ ? 816 : 0);
            if (p_265530_ == Mode.MOVE) {
                for (BlockPos blockpos7 : deque) {
                    serverlevel.setBlock(blockpos7, Blocks.BARRIER.defaultBlockState(), l1 | 0x330);
                }
                int i2 = p_394351_ ? l1 : 3;
                for (BlockPos blockpos8 : deque) {
                    serverlevel.setBlock(blockpos8, Blocks.AIR.defaultBlockState(), i2);
                }
            }
            ArrayList list3 = Lists.newArrayList();
            list3.addAll(list);
            list3.addAll(list1);
            list3.addAll(list2);
            List list4 = Lists.reverse((List)list3);
            for (CloneBlockInfo clonecommands$cloneblockinfo : list4) {
                serverlevel1.setBlock(clonecommands$cloneblockinfo.pos, Blocks.BARRIER.defaultBlockState(), l1 | 0x330);
            }
            for (CloneBlockInfo clonecommands$cloneblockinfo1 : list3) {
                if (!serverlevel1.setBlock(clonecommands$cloneblockinfo1.pos, clonecommands$cloneblockinfo1.state, l1)) continue;
                ++k;
            }
            for (CloneBlockInfo clonecommands$cloneblockinfo2 : list1) {
                BlockEntity blockentity1 = serverlevel1.getBlockEntity(clonecommands$cloneblockinfo2.pos);
                if (clonecommands$cloneblockinfo2.blockEntityInfo != null && blockentity1 != null) {
                    blockentity1.loadCustomOnly(TagValueInput.create(problemreporter$scopedcollector.forChild(blockentity1.problemPath()), (HolderLookup.Provider)serverlevel1.registryAccess(), clonecommands$cloneblockinfo2.blockEntityInfo.tag));
                    blockentity1.setComponents(clonecommands$cloneblockinfo2.blockEntityInfo.components);
                    blockentity1.setChanged();
                }
                serverlevel1.setBlock(clonecommands$cloneblockinfo2.pos, clonecommands$cloneblockinfo2.state, l1);
            }
            if (!p_394351_) {
                for (CloneBlockInfo clonecommands$cloneblockinfo3 : list4) {
                    serverlevel1.updateNeighboursOnBlockSet(clonecommands$cloneblockinfo3.pos, clonecommands$cloneblockinfo3.previousStateAtDestination);
                }
            }
            ((LevelTicks)serverlevel1.getBlockTicks()).copyAreaFrom(serverlevel.getBlockTicks(), boundingbox, blockpos4);
        }
        if (k == 0) {
            throw ERROR_FAILED.create();
        }
        int k1 = k;
        p_265047_.sendSuccess(() -> Component.translatable("commands.clone.success", k1), true);
        return k;
    }

    record DimensionAndPosition(ServerLevel dimension, BlockPos position) {
    }

    static enum Mode {
        FORCE(true),
        MOVE(true),
        NORMAL(false);

        private final boolean canOverlap;

        private Mode(boolean p_136795_) {
            this.canOverlap = p_136795_;
        }

        public boolean canOverlap() {
            return this.canOverlap;
        }
    }

    record CloneBlockEntityInfo(CompoundTag tag, DataComponentMap components) {
    }

    record CloneBlockInfo(BlockPos pos, BlockState state, @Nullable CloneBlockEntityInfo blockEntityInfo, BlockState previousStateAtDestination) {
    }
}

