/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.bossevents;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;

public class CustomBossEvent
extends ServerBossEvent {
    private static final int DEFAULT_MAX = 100;
    private final ResourceLocation id;
    private final Set<UUID> players = Sets.newHashSet();
    private int value;
    private int max = 100;

    public CustomBossEvent(ResourceLocation p_136261_, Component p_136262_) {
        super(p_136262_, BossEvent.BossBarColor.WHITE, BossEvent.BossBarOverlay.PROGRESS);
        this.id = p_136261_;
        this.setProgress(0.0f);
    }

    public ResourceLocation getTextId() {
        return this.id;
    }

    @Override
    public void addPlayer(ServerPlayer p_136267_) {
        super.addPlayer(p_136267_);
        this.players.add(p_136267_.getUUID());
    }

    public void addOfflinePlayer(UUID p_136271_) {
        this.players.add(p_136271_);
    }

    @Override
    public void removePlayer(ServerPlayer p_136281_) {
        super.removePlayer(p_136281_);
        this.players.remove(p_136281_.getUUID());
    }

    @Override
    public void removeAllPlayers() {
        super.removeAllPlayers();
        this.players.clear();
    }

    public int getValue() {
        return this.value;
    }

    public int getMax() {
        return this.max;
    }

    public void setValue(int p_136265_) {
        this.value = p_136265_;
        this.setProgress(Mth.clamp((float)p_136265_ / (float)this.max, 0.0f, 1.0f));
    }

    public void setMax(int p_136279_) {
        this.max = p_136279_;
        this.setProgress(Mth.clamp((float)this.value / (float)p_136279_, 0.0f, 1.0f));
    }

    public final Component getDisplayName() {
        return ComponentUtils.wrapInSquareBrackets(this.getName()).withStyle(p_404184_ -> p_404184_.withColor(this.getColor().getFormatting()).withHoverEvent(new HoverEvent.ShowText(Component.literal(this.getTextId().toString()))).withInsertion(this.getTextId().toString()));
    }

    public boolean setPlayers(Collection<ServerPlayer> p_136269_) {
        HashSet set = Sets.newHashSet();
        HashSet set1 = Sets.newHashSet();
        for (UUID uuid : this.players) {
            boolean flag = false;
            for (ServerPlayer serverplayer : p_136269_) {
                if (!serverplayer.getUUID().equals(uuid)) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            set.add(uuid);
        }
        for (ServerPlayer serverplayer1 : p_136269_) {
            boolean flag1 = false;
            for (UUID uuid2 : this.players) {
                if (!serverplayer1.getUUID().equals(uuid2)) continue;
                flag1 = true;
                break;
            }
            if (flag1) continue;
            set1.add(serverplayer1);
        }
        for (UUID uuid1 : set) {
            for (ServerPlayer serverplayer3 : this.getPlayers()) {
                if (!serverplayer3.getUUID().equals(uuid1)) continue;
                this.removePlayer(serverplayer3);
                break;
            }
            this.players.remove(uuid1);
        }
        for (ServerPlayer serverplayer2 : set1) {
            this.addPlayer(serverplayer2);
        }
        return !set.isEmpty() || !set1.isEmpty();
    }

    public static CustomBossEvent load(ResourceLocation p_136274_, Packed p_405765_) {
        CustomBossEvent custombossevent = new CustomBossEvent(p_136274_, p_405765_.name);
        custombossevent.setVisible(p_405765_.visible);
        custombossevent.setValue(p_405765_.value);
        custombossevent.setMax(p_405765_.max);
        custombossevent.setColor(p_405765_.color);
        custombossevent.setOverlay(p_405765_.overlay);
        custombossevent.setDarkenScreen(p_405765_.darkenScreen);
        custombossevent.setPlayBossMusic(p_405765_.playBossMusic);
        custombossevent.setCreateWorldFog(p_405765_.createWorldFog);
        p_405765_.players.forEach(custombossevent::addOfflinePlayer);
        return custombossevent;
    }

    public Packed pack() {
        return new Packed(this.getName(), this.isVisible(), this.getValue(), this.getMax(), this.getColor(), this.getOverlay(), this.shouldDarkenScreen(), this.shouldPlayBossMusic(), this.shouldCreateWorldFog(), Set.copyOf(this.players));
    }

    public void onPlayerConnect(ServerPlayer p_136284_) {
        if (this.players.contains(p_136284_.getUUID())) {
            this.addPlayer(p_136284_);
        }
    }

    public void onPlayerDisconnect(ServerPlayer p_136287_) {
        super.removePlayer(p_136287_);
    }

    public record Packed(Component name, boolean visible, int value, int max, BossEvent.BossBarColor color, BossEvent.BossBarOverlay overlay, boolean darkenScreen, boolean playBossMusic, boolean createWorldFog, Set<UUID> players) {
        public static final Codec<Packed> CODEC = RecordCodecBuilder.create(p_405289_ -> p_405289_.group((App)ComponentSerialization.CODEC.fieldOf("Name").forGetter(Packed::name), (App)Codec.BOOL.optionalFieldOf("Visible", (Object)false).forGetter(Packed::visible), (App)Codec.INT.optionalFieldOf("Value", (Object)0).forGetter(Packed::value), (App)Codec.INT.optionalFieldOf("Max", (Object)100).forGetter(Packed::max), (App)BossEvent.BossBarColor.CODEC.optionalFieldOf("Color", (Object)BossEvent.BossBarColor.WHITE).forGetter(Packed::color), (App)BossEvent.BossBarOverlay.CODEC.optionalFieldOf("Overlay", (Object)BossEvent.BossBarOverlay.PROGRESS).forGetter(Packed::overlay), (App)Codec.BOOL.optionalFieldOf("DarkenScreen", (Object)false).forGetter(Packed::darkenScreen), (App)Codec.BOOL.optionalFieldOf("PlayBossMusic", (Object)false).forGetter(Packed::playBossMusic), (App)Codec.BOOL.optionalFieldOf("CreateWorldFog", (Object)false).forGetter(Packed::createWorldFog), (App)UUIDUtil.CODEC_SET.optionalFieldOf("Players", Set.of()).forGetter(Packed::players)).apply((Applicative)p_405289_, Packed::new));
    }
}

