/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import java.util.Queue;
import net.minecraft.util.ArrayListDeque;

public class SuppressedExceptionCollector {
    private static final int LATEST_ENTRY_COUNT = 8;
    private final Queue<LongEntry> latestEntries = new ArrayListDeque<LongEntry>();
    private final Object2IntLinkedOpenHashMap<ShortEntry> entryCounts = new Object2IntLinkedOpenHashMap();

    private static long currentTimeMs() {
        return System.currentTimeMillis();
    }

    public synchronized void addEntry(String p_363905_, Throwable p_364135_) {
        long i = SuppressedExceptionCollector.currentTimeMs();
        String s = p_364135_.getMessage();
        this.latestEntries.add(new LongEntry(i, p_363905_, p_364135_.getClass(), s));
        while (this.latestEntries.size() > 8) {
            this.latestEntries.remove();
        }
        ShortEntry suppressedexceptioncollector$shortentry = new ShortEntry(p_363905_, p_364135_.getClass());
        int j = this.entryCounts.getInt((Object)suppressedexceptioncollector$shortentry);
        this.entryCounts.putAndMoveToFirst((Object)suppressedexceptioncollector$shortentry, j + 1);
    }

    public synchronized String dump() {
        long i = SuppressedExceptionCollector.currentTimeMs();
        StringBuilder stringbuilder = new StringBuilder();
        if (!this.latestEntries.isEmpty()) {
            stringbuilder.append("\n\t\tLatest entries:\n");
            for (LongEntry suppressedexceptioncollector$longentry : this.latestEntries) {
                stringbuilder.append("\t\t\t").append(suppressedexceptioncollector$longentry.location).append(":").append(suppressedexceptioncollector$longentry.cls).append(": ").append(suppressedexceptioncollector$longentry.message).append(" (").append(i - suppressedexceptioncollector$longentry.timestampMs).append("ms ago)").append("\n");
            }
        }
        if (!this.entryCounts.isEmpty()) {
            if (stringbuilder.isEmpty()) {
                stringbuilder.append("\n");
            }
            stringbuilder.append("\t\tEntry counts:\n");
            for (Object2IntMap.Entry entry : Object2IntMaps.fastIterable(this.entryCounts)) {
                stringbuilder.append("\t\t\t").append(((ShortEntry)entry.getKey()).location).append(":").append(((ShortEntry)entry.getKey()).cls).append(" x ").append(entry.getIntValue()).append("\n");
            }
        }
        return stringbuilder.isEmpty() ? "~~NONE~~" : stringbuilder.toString();
    }

    record LongEntry(long timestampMs, String location, Class<? extends Throwable> cls, String message) {
    }

    record ShortEntry(String location, Class<? extends Throwable> cls) {
    }
}

