/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.AdvancementTree;
import net.minecraft.advancements.TreeNodePosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.profiling.ProfilerFiller;
import org.slf4j.Logger;

public class ServerAdvancementManager
extends SimpleJsonResourceReloadListener<Advancement> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private Map<ResourceLocation, AdvancementHolder> advancements = Map.of();
    private AdvancementTree tree = new AdvancementTree();
    private final HolderLookup.Provider registries;

    public ServerAdvancementManager(HolderLookup.Provider p_323943_) {
        super(p_323943_, Advancement.CODEC, Registries.ADVANCEMENT);
        this.registries = p_323943_;
    }

    @Override
    protected void apply(Map<ResourceLocation, Advancement> p_136034_, ResourceManager p_136035_, ProfilerFiller p_136036_) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        p_136034_.forEach((p_370393_, p_370394_) -> {
            this.validate((ResourceLocation)p_370393_, (Advancement)p_370394_);
            builder.put(p_370393_, (Object)new AdvancementHolder((ResourceLocation)p_370393_, (Advancement)p_370394_));
        });
        this.advancements = builder.buildOrThrow();
        AdvancementTree advancementtree = new AdvancementTree();
        advancementtree.addAll(this.advancements.values());
        for (AdvancementNode advancementnode : advancementtree.roots()) {
            if (!advancementnode.holder().value().display().isPresent()) continue;
            TreeNodePosition.run(advancementnode);
        }
        this.tree = advancementtree;
    }

    private void validate(ResourceLocation p_312696_, Advancement p_312110_) {
        ProblemReporter.Collector problemreporter$collector = new ProblemReporter.Collector();
        p_312110_.validate(problemreporter$collector, this.registries);
        if (!problemreporter$collector.isEmpty()) {
            LOGGER.warn("Found validation problems in advancement {}: \n{}", (Object)p_312696_, (Object)problemreporter$collector.getReport());
        }
    }

    @Nullable
    public AdvancementHolder get(ResourceLocation p_301079_) {
        return this.advancements.get(p_301079_);
    }

    public AdvancementTree tree() {
        return this.tree;
    }

    public Collection<AdvancementHolder> getAllAdvancements() {
        return this.advancements.values();
    }
}

