/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagLoader;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.event.EventHooks;
import org.slf4j.Logger;

public class ReloadableServerRegistries {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final RegistrationInfo DEFAULT_REGISTRATION_INFO = new RegistrationInfo(Optional.empty(), Lifecycle.experimental());

    public static CompletableFuture<LoadResult> reload(LayeredRegistryAccess<RegistryLayer> p_335950_, List<Registry.PendingTags<?>> p_363295_, ResourceManager p_335786_, Executor p_335516_) {
        List<HolderLookup.RegistryLookup<?>> list = TagLoader.buildUpdatedLookups(p_335950_.getAccessForLoading(RegistryLayer.RELOADABLE), p_363295_);
        HolderLookup.Provider holderlookup$provider = HolderLookup.Provider.create(list.stream());
        RegistryOps registryops = holderlookup$provider.createSerializationContext(JsonOps.INSTANCE);
        List<CompletableFuture> list1 = LootDataType.values().map(p_359506_ -> ReloadableServerRegistries.scheduleRegistryLoad(p_359506_, registryops, p_335786_, p_335516_)).toList();
        CompletableFuture completablefuture = Util.sequence(list1);
        return completablefuture.thenApplyAsync(p_359496_ -> ReloadableServerRegistries.createAndValidateFullContext(p_335950_, holderlookup$provider, p_359496_), p_335516_);
    }

    private static <T> CompletableFuture<WritableRegistry<?>> scheduleRegistryLoad(LootDataType<T> p_335741_, RegistryOps<JsonElement> p_336173_, ResourceManager p_335893_, Executor p_336104_) {
        return CompletableFuture.supplyAsync(() -> {
            MappedRegistry writableregistry = new MappedRegistry(p_335741_.registryKey(), Lifecycle.experimental());
            HashMap<ResourceLocation, Object> map = new HashMap<ResourceLocation, Object>();
            HolderLookup.Provider provider = CommonHooks.extractLookupProvider((RegistryOps)p_336173_);
            HashMap optionalMap = new HashMap();
            SimpleJsonResourceReloadListener.scanDirectoryWithOptionalValues(p_335893_, p_335741_.registryKey(), p_336173_, p_335741_.conditionalCodec(), optionalMap);
            optionalMap.forEach((rl, optionalEntry) -> {
                optionalEntry.ifPresent(entry -> p_335741_.idSetter().accept(entry, (ResourceLocation)rl));
                Object value = optionalEntry.orElse(p_335741_.defaultValue());
                if (value instanceof LootTable) {
                    LootTable lootTable = (LootTable)value;
                    value = EventHooks.loadLootTable((HolderLookup.Provider)provider, (ResourceLocation)rl, (LootTable)lootTable);
                }
                if (value != null) {
                    map.put((ResourceLocation)rl, value);
                }
            });
            map.forEach((p_335721_, p_335683_) -> writableregistry.register(ResourceKey.create(p_335741_.registryKey(), p_335721_), p_335683_, DEFAULT_REGISTRATION_INFO));
            TagLoader.loadTagsForRegistry(p_335893_, writableregistry);
            return writableregistry;
        }, p_336104_);
    }

    private static LoadResult createAndValidateFullContext(LayeredRegistryAccess<RegistryLayer> p_362306_, HolderLookup.Provider p_361687_, List<WritableRegistry<?>> p_361223_) {
        LayeredRegistryAccess<RegistryLayer> layeredregistryaccess = ReloadableServerRegistries.createUpdatedRegistries(p_362306_, p_361223_);
        HolderLookup.Provider holderlookup$provider = ReloadableServerRegistries.concatenateLookups(p_361687_, layeredregistryaccess.getLayer(RegistryLayer.RELOADABLE));
        ReloadableServerRegistries.validateLootRegistries(holderlookup$provider);
        return new LoadResult(layeredregistryaccess, holderlookup$provider);
    }

    private static HolderLookup.Provider concatenateLookups(HolderLookup.Provider p_363853_, HolderLookup.Provider p_363956_) {
        return HolderLookup.Provider.create(Stream.concat(p_363853_.listRegistries(), p_363956_.listRegistries()));
    }

    private static void validateLootRegistries(HolderLookup.Provider p_363971_) {
        ProblemReporter.Collector problemreporter$collector = new ProblemReporter.Collector();
        ValidationContext validationcontext = new ValidationContext(problemreporter$collector, LootContextParamSets.ALL_PARAMS, p_363971_);
        LootDataType.values().forEach(p_359499_ -> ReloadableServerRegistries.validateRegistry(validationcontext, p_359499_, p_363971_));
        problemreporter$collector.forEach((p_421316_, p_421317_) -> LOGGER.warn("Found loot table element validation problem in {}: {}", p_421316_, (Object)p_421317_.description()));
    }

    private static LayeredRegistryAccess<RegistryLayer> createUpdatedRegistries(LayeredRegistryAccess<RegistryLayer> p_335434_, List<WritableRegistry<?>> p_336097_) {
        return p_335434_.replaceFrom(RegistryLayer.RELOADABLE, new RegistryAccess.ImmutableRegistryAccess(p_336097_).freeze());
    }

    private static <T> void validateRegistry(ValidationContext p_335565_, LootDataType<T> p_335997_, HolderLookup.Provider p_360819_) {
        HolderGetter holderlookup = p_360819_.lookupOrThrow(p_335997_.registryKey());
        holderlookup.listElements().forEach(p_335842_ -> p_335997_.runValidation(p_335565_, p_335842_.key(), p_335842_.value()));
    }

    public record LoadResult(LayeredRegistryAccess<RegistryLayer> layers, HolderLookup.Provider lookupWithUpdatedTags) {
    }

    public static class Holder {
        private final HolderLookup.Provider registries;

        public Holder(HolderLookup.Provider p_361288_) {
            this.registries = p_361288_;
        }

        public HolderLookup.Provider lookup() {
            return this.registries;
        }

        public LootTable getLootTable(ResourceKey<LootTable> p_335504_) {
            return this.registries.lookup(Registries.LOOT_TABLE).flatMap(p_335799_ -> p_335799_.get(p_335504_)).map(net.minecraft.core.Holder::value).orElse(LootTable.EMPTY);
        }
    }
}

