/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.status;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import net.minecraft.SharedConstants;
import net.minecraft.WorldVersion;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;

public record ServerStatus(Component description, Optional<Players> players, Optional<Version> version, Optional<Favicon> favicon, boolean enforcesSecureChat, boolean isModded) {
    public static final Codec<ServerStatus> CODEC = RecordCodecBuilder.create(p_337519_ -> p_337519_.group((App)ComponentSerialization.CODEC.lenientOptionalFieldOf("description", (Object)CommonComponents.EMPTY).forGetter(ServerStatus::description), (App)Players.CODEC.lenientOptionalFieldOf("players").forGetter(ServerStatus::players), (App)Version.CODEC.lenientOptionalFieldOf("version").forGetter(ServerStatus::version), (App)Favicon.CODEC.lenientOptionalFieldOf("favicon").forGetter(ServerStatus::favicon), (App)Codec.BOOL.lenientOptionalFieldOf("enforcesSecureChat", (Object)false).forGetter(ServerStatus::enforcesSecureChat), (App)Codec.BOOL.lenientOptionalFieldOf("isModded", (Object)Boolean.FALSE).forGetter(ServerStatus::isModded)).apply((Applicative)p_337519_, ServerStatus::new));

    @Deprecated
    public ServerStatus(Component description, Optional<Players> players, Optional<Version> version, Optional<Favicon> favicon, boolean enforcesSecureChat) {
        this(description, players, version, favicon, enforcesSecureChat, false);
    }

    public record Players(int max, int online, List<GameProfile> sample) {
        private static final Codec<GameProfile> PROFILE_CODEC = RecordCodecBuilder.create(p_272926_ -> p_272926_.group((App)UUIDUtil.STRING_CODEC.fieldOf("id").forGetter(GameProfile::getId), (App)Codec.STRING.fieldOf("name").forGetter(GameProfile::getName)).apply((Applicative)p_272926_, GameProfile::new));
        public static final Codec<Players> CODEC = RecordCodecBuilder.create(p_337520_ -> p_337520_.group((App)Codec.INT.fieldOf("max").forGetter(Players::max), (App)Codec.INT.fieldOf("online").forGetter(Players::online), (App)PROFILE_CODEC.listOf().lenientOptionalFieldOf("sample", List.of()).forGetter(Players::sample)).apply((Applicative)p_337520_, Players::new));
    }

    public record Version(String name, int protocol) {
        public static final Codec<Version> CODEC = RecordCodecBuilder.create(p_273157_ -> p_273157_.group((App)Codec.STRING.fieldOf("name").forGetter(Version::name), (App)Codec.INT.fieldOf("protocol").forGetter(Version::protocol)).apply((Applicative)p_273157_, Version::new));

        public static Version current() {
            WorldVersion worldversion = SharedConstants.getCurrentVersion();
            return new Version(worldversion.name(), worldversion.protocolVersion());
        }
    }

    public record Favicon(byte[] iconBytes) {
        private static final String PREFIX = "data:image/png;base64,";
        public static final Codec<Favicon> CODEC = Codec.STRING.comapFlatMap(p_274795_ -> {
            if (!p_274795_.startsWith(PREFIX)) {
                return DataResult.error(() -> "Unknown format");
            }
            try {
                String s = p_274795_.substring(PREFIX.length()).replaceAll("\n", "");
                byte[] abyte = Base64.getDecoder().decode(s.getBytes(StandardCharsets.UTF_8));
                return DataResult.success((Object)new Favicon(abyte));
            }
            catch (IllegalArgumentException illegalargumentexception) {
                return DataResult.error(() -> "Malformed base64 server icon");
            }
        }, p_273258_ -> PREFIX + new String(Base64.getEncoder().encode(p_273258_.iconBytes), StandardCharsets.UTF_8));
    }
}

