/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;

public class ClientboundSetPlayerTeamPacket
implements Packet<ClientGamePacketListener> {
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundSetPlayerTeamPacket> STREAM_CODEC = Packet.codec(ClientboundSetPlayerTeamPacket::write, ClientboundSetPlayerTeamPacket::new);
    private static final int METHOD_ADD = 0;
    private static final int METHOD_REMOVE = 1;
    private static final int METHOD_CHANGE = 2;
    private static final int METHOD_JOIN = 3;
    private static final int METHOD_LEAVE = 4;
    private static final int MAX_VISIBILITY_LENGTH = 40;
    private static final int MAX_COLLISION_LENGTH = 40;
    private final int method;
    private final String name;
    private final Collection<String> players;
    private final Optional<Parameters> parameters;

    private ClientboundSetPlayerTeamPacket(String p_179318_, int p_179319_, Optional<Parameters> p_179320_, Collection<String> p_179321_) {
        this.name = p_179318_;
        this.method = p_179319_;
        this.parameters = p_179320_;
        this.players = ImmutableList.copyOf(p_179321_);
    }

    public static ClientboundSetPlayerTeamPacket createAddOrModifyPacket(PlayerTeam p_179333_, boolean p_179334_) {
        return new ClientboundSetPlayerTeamPacket(p_179333_.getName(), p_179334_ ? 0 : 2, Optional.of(new Parameters(p_179333_)), p_179334_ ? p_179333_.getPlayers() : ImmutableList.of());
    }

    public static ClientboundSetPlayerTeamPacket createRemovePacket(PlayerTeam p_179327_) {
        return new ClientboundSetPlayerTeamPacket(p_179327_.getName(), 1, Optional.empty(), (Collection<String>)ImmutableList.of());
    }

    public static ClientboundSetPlayerTeamPacket createPlayerPacket(PlayerTeam p_179329_, String p_179330_, Action p_179331_) {
        return new ClientboundSetPlayerTeamPacket(p_179329_.getName(), p_179331_ == Action.ADD ? 3 : 4, Optional.empty(), (Collection<String>)ImmutableList.of((Object)p_179330_));
    }

    private ClientboundSetPlayerTeamPacket(RegistryFriendlyByteBuf p_323831_) {
        this.name = p_323831_.readUtf();
        this.method = p_323831_.readByte();
        this.parameters = ClientboundSetPlayerTeamPacket.shouldHaveParameters(this.method) ? Optional.of(new Parameters(p_323831_)) : Optional.empty();
        this.players = ClientboundSetPlayerTeamPacket.shouldHavePlayerList(this.method) ? p_323831_.readList(FriendlyByteBuf::readUtf) : ImmutableList.of();
    }

    private void write(RegistryFriendlyByteBuf p_323648_) {
        p_323648_.writeUtf(this.name);
        p_323648_.writeByte(this.method);
        if (ClientboundSetPlayerTeamPacket.shouldHaveParameters(this.method)) {
            this.parameters.orElseThrow(() -> new IllegalStateException("Parameters not present, but method is" + this.method)).write(p_323648_);
        }
        if (ClientboundSetPlayerTeamPacket.shouldHavePlayerList(this.method)) {
            p_323648_.writeCollection(this.players, FriendlyByteBuf::writeUtf);
        }
    }

    private static boolean shouldHavePlayerList(int p_179325_) {
        return p_179325_ == 0 || p_179325_ == 3 || p_179325_ == 4;
    }

    private static boolean shouldHaveParameters(int p_179337_) {
        return p_179337_ == 0 || p_179337_ == 2;
    }

    @Nullable
    public Action getPlayerAction() {
        return switch (this.method) {
            case 0, 3 -> Action.ADD;
            default -> null;
            case 4 -> Action.REMOVE;
        };
    }

    @Nullable
    public Action getTeamAction() {
        return switch (this.method) {
            case 0 -> Action.ADD;
            case 1 -> Action.REMOVE;
            default -> null;
        };
    }

    @Override
    public PacketType<ClientboundSetPlayerTeamPacket> type() {
        return GamePacketTypes.CLIENTBOUND_SET_PLAYER_TEAM;
    }

    @Override
    public void handle(ClientGamePacketListener p_133310_) {
        p_133310_.handleSetPlayerTeamPacket(this);
    }

    public String getName() {
        return this.name;
    }

    public Collection<String> getPlayers() {
        return this.players;
    }

    public Optional<Parameters> getParameters() {
        return this.parameters;
    }

    public static class Parameters {
        private final Component displayName;
        private final Component playerPrefix;
        private final Component playerSuffix;
        private final Team.Visibility nametagVisibility;
        private final Team.CollisionRule collisionRule;
        private final ChatFormatting color;
        private final int options;

        public Parameters(PlayerTeam p_179360_) {
            this.displayName = p_179360_.getDisplayName();
            this.options = p_179360_.packOptions();
            this.nametagVisibility = p_179360_.getNameTagVisibility();
            this.collisionRule = p_179360_.getCollisionRule();
            this.color = p_179360_.getColor();
            this.playerPrefix = p_179360_.getPlayerPrefix();
            this.playerSuffix = p_179360_.getPlayerSuffix();
        }

        public Parameters(RegistryFriendlyByteBuf p_323739_) {
            this.displayName = (Component)ComponentSerialization.TRUSTED_STREAM_CODEC.decode(p_323739_);
            this.options = p_323739_.readByte();
            this.nametagVisibility = (Team.Visibility)Team.Visibility.STREAM_CODEC.decode(p_323739_);
            this.collisionRule = (Team.CollisionRule)Team.CollisionRule.STREAM_CODEC.decode(p_323739_);
            this.color = p_323739_.readEnum(ChatFormatting.class);
            this.playerPrefix = (Component)ComponentSerialization.TRUSTED_STREAM_CODEC.decode(p_323739_);
            this.playerSuffix = (Component)ComponentSerialization.TRUSTED_STREAM_CODEC.decode(p_323739_);
        }

        public Component getDisplayName() {
            return this.displayName;
        }

        public int getOptions() {
            return this.options;
        }

        public ChatFormatting getColor() {
            return this.color;
        }

        public Team.Visibility getNametagVisibility() {
            return this.nametagVisibility;
        }

        public Team.CollisionRule getCollisionRule() {
            return this.collisionRule;
        }

        public Component getPlayerPrefix() {
            return this.playerPrefix;
        }

        public Component getPlayerSuffix() {
            return this.playerSuffix;
        }

        public void write(RegistryFriendlyByteBuf p_323527_) {
            ComponentSerialization.TRUSTED_STREAM_CODEC.encode(p_323527_, this.displayName);
            p_323527_.writeByte(this.options);
            Team.Visibility.STREAM_CODEC.encode(p_323527_, this.nametagVisibility);
            Team.CollisionRule.STREAM_CODEC.encode(p_323527_, this.collisionRule);
            p_323527_.writeEnum(this.color);
            ComponentSerialization.TRUSTED_STREAM_CODEC.encode(p_323527_, this.playerPrefix);
            ComponentSerialization.TRUSTED_STREAM_CODEC.encode(p_323527_, this.playerSuffix);
        }
    }

    public static enum Action {
        ADD,
        REMOVE;

    }
}

