/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.resources.ResourceLocation;

public class ClientboundCommandsPacket
implements Packet<ClientGamePacketListener> {
    public static final StreamCodec<FriendlyByteBuf, ClientboundCommandsPacket> STREAM_CODEC = Packet.codec(ClientboundCommandsPacket::write, ClientboundCommandsPacket::new);
    private static final byte MASK_TYPE = 3;
    private static final byte FLAG_EXECUTABLE = 4;
    private static final byte FLAG_REDIRECT = 8;
    private static final byte FLAG_CUSTOM_SUGGESTIONS = 16;
    private static final byte FLAG_RESTRICTED = 32;
    private static final byte TYPE_ROOT = 0;
    private static final byte TYPE_LITERAL = 1;
    private static final byte TYPE_ARGUMENT = 2;
    private final int rootIndex;
    private final List<Entry> entries;

    public <S> ClientboundCommandsPacket(RootCommandNode<S> p_131861_, NodeInspector<S> p_426113_) {
        Object2IntMap<CommandNode<S>> object2intmap = ClientboundCommandsPacket.enumerateNodes(p_131861_);
        this.entries = ClientboundCommandsPacket.createEntries(object2intmap, p_426113_);
        this.rootIndex = object2intmap.getInt(p_131861_);
    }

    private ClientboundCommandsPacket(FriendlyByteBuf p_178805_) {
        this.entries = p_178805_.readList(ClientboundCommandsPacket::readNode);
        this.rootIndex = p_178805_.readVarInt();
        ClientboundCommandsPacket.validateEntries(this.entries);
    }

    private void write(FriendlyByteBuf p_131886_) {
        p_131886_.writeCollection(this.entries, (p_237642_, p_237643_) -> p_237643_.write((FriendlyByteBuf)((Object)p_237642_)));
        p_131886_.writeVarInt(this.rootIndex);
    }

    private static void validateEntries(List<Entry> p_237631_, BiPredicate<Entry, IntSet> p_237632_) {
        IntOpenHashSet intset = new IntOpenHashSet((IntCollection)IntSets.fromTo((int)0, (int)p_237631_.size()));
        while (!intset.isEmpty()) {
            boolean flag = intset.removeIf(arg_0 -> ClientboundCommandsPacket.lambda$validateEntries$1(p_237632_, p_237631_, (IntSet)intset, arg_0));
            if (flag) continue;
            throw new IllegalStateException("Server sent an impossible command tree");
        }
    }

    private static void validateEntries(List<Entry> p_237629_) {
        ClientboundCommandsPacket.validateEntries(p_237629_, Entry::canBuild);
        ClientboundCommandsPacket.validateEntries(p_237629_, Entry::canResolve);
    }

    private static <S> Object2IntMap<CommandNode<S>> enumerateNodes(RootCommandNode<S> p_131863_) {
        CommandNode commandnode;
        Object2IntOpenHashMap object2intmap = new Object2IntOpenHashMap();
        ArrayDeque<Object> queue = new ArrayDeque<Object>();
        queue.add(p_131863_);
        while ((commandnode = (CommandNode)queue.poll()) != null) {
            if (object2intmap.containsKey((Object)commandnode)) continue;
            int i = object2intmap.size();
            object2intmap.put((Object)commandnode, i);
            queue.addAll(commandnode.getChildren());
            if (commandnode.getRedirect() == null) continue;
            queue.add(commandnode.getRedirect());
        }
        return object2intmap;
    }

    private static <S> List<Entry> createEntries(Object2IntMap<CommandNode<S>> p_237627_, NodeInspector<S> p_425698_) {
        ObjectArrayList objectarraylist = new ObjectArrayList(p_237627_.size());
        objectarraylist.size(p_237627_.size());
        for (Object2IntMap.Entry entry : Object2IntMaps.fastIterable(p_237627_)) {
            objectarraylist.set(entry.getIntValue(), (Object)ClientboundCommandsPacket.createEntry((CommandNode)entry.getKey(), p_425698_, p_237627_));
        }
        return objectarraylist;
    }

    private static Entry readNode(FriendlyByteBuf p_131888_) {
        byte b0 = p_131888_.readByte();
        int[] aint = p_131888_.readVarIntArray();
        int i = (b0 & 8) != 0 ? p_131888_.readVarInt() : 0;
        NodeStub clientboundcommandspacket$nodestub = ClientboundCommandsPacket.read(p_131888_, b0);
        return new Entry(clientboundcommandspacket$nodestub, b0, i, aint);
    }

    @Nullable
    private static NodeStub read(FriendlyByteBuf p_237639_, byte p_237640_) {
        int i = p_237640_ & 3;
        if (i == 2) {
            String s1 = p_237639_.readUtf();
            int j = p_237639_.readVarInt();
            ArgumentTypeInfo argumenttypeinfo = (ArgumentTypeInfo)BuiltInRegistries.COMMAND_ARGUMENT_TYPE.byId(j);
            if (argumenttypeinfo == null) {
                return null;
            }
            Object template = argumenttypeinfo.deserializeFromNetwork(p_237639_);
            ResourceLocation resourcelocation = (p_237640_ & 0x10) != 0 ? p_237639_.readResourceLocation() : null;
            return new ArgumentNodeStub(s1, (ArgumentTypeInfo.Template<?>)template, resourcelocation);
        }
        if (i == 1) {
            String s = p_237639_.readUtf();
            return new LiteralNodeStub(s);
        }
        return null;
    }

    private static <S> Entry createEntry(CommandNode<S> p_237622_, NodeInspector<S> p_425626_, Object2IntMap<CommandNode<S>> p_237623_) {
        Record clientboundcommandspacket$nodestub;
        int j;
        int i = 0;
        if (p_237622_.getRedirect() != null) {
            i |= 8;
            j = p_237623_.getInt((Object)p_237622_.getRedirect());
        } else {
            j = 0;
        }
        if (p_425626_.isExecutable(p_237622_)) {
            i |= 4;
        }
        if (p_425626_.isRestricted(p_237622_)) {
            i |= 0x20;
        }
        CommandNode<S> commandNode = p_237622_;
        Objects.requireNonNull(commandNode);
        CommandNode<S> commandNode2 = commandNode;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RootCommandNode.class, ArgumentCommandNode.class, LiteralCommandNode.class}, commandNode2, n)) {
            case 0: {
                RootCommandNode rootcommandnode = (RootCommandNode)commandNode2;
                i |= 0;
                clientboundcommandspacket$nodestub = null;
                break;
            }
            case 1: {
                ArgumentCommandNode argumentcommandnode = (ArgumentCommandNode)commandNode2;
                ResourceLocation resourcelocation = p_425626_.suggestionId(argumentcommandnode);
                clientboundcommandspacket$nodestub = new ArgumentNodeStub(argumentcommandnode.getName(), ArgumentTypeInfos.unpack(argumentcommandnode.getType()), resourcelocation);
                i |= 2;
                if (resourcelocation != null) {
                    i |= 0x10;
                }
                break;
            }
            case 2: {
                LiteralCommandNode literalcommandnode = (LiteralCommandNode)commandNode2;
                clientboundcommandspacket$nodestub = new LiteralNodeStub(literalcommandnode.getLiteral());
                i |= 1;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown node type " + String.valueOf(p_237622_));
            }
        }
        int[] aint = p_237622_.getChildren().stream().mapToInt(arg_0 -> p_237623_.getInt(arg_0)).toArray();
        return new Entry((NodeStub)((Object)clientboundcommandspacket$nodestub), i, j, aint);
    }

    @Override
    public PacketType<ClientboundCommandsPacket> type() {
        return GamePacketTypes.CLIENTBOUND_COMMANDS;
    }

    @Override
    public void handle(ClientGamePacketListener p_131878_) {
        p_131878_.handleCommands(this);
    }

    public <S> RootCommandNode<S> getRoot(CommandBuildContext p_237625_, NodeBuilder<S> p_426329_) {
        return (RootCommandNode)new NodeResolver<S>(p_237625_, p_426329_, this.entries).resolve(this.rootIndex);
    }

    private static /* synthetic */ boolean lambda$validateEntries$1(BiPredicate p_237632_, List p_237631_, IntSet intset, int p_237637_) {
        return p_237632_.test((Entry)p_237631_.get(p_237637_), intset);
    }

    public static interface NodeInspector<S> {
        @Nullable
        public ResourceLocation suggestionId(ArgumentCommandNode<S, ?> var1);

        public boolean isExecutable(CommandNode<S> var1);

        public boolean isRestricted(CommandNode<S> var1);
    }

    record Entry(@Nullable NodeStub stub, int flags, int redirect, int[] children) {
        public void write(FriendlyByteBuf p_237675_) {
            p_237675_.writeByte(this.flags);
            p_237675_.writeVarIntArray(this.children);
            if ((this.flags & 8) != 0) {
                p_237675_.writeVarInt(this.redirect);
            }
            if (this.stub != null) {
                this.stub.write(p_237675_);
            }
        }

        public boolean canBuild(IntSet p_237673_) {
            return (this.flags & 8) != 0 ? !p_237673_.contains(this.redirect) : true;
        }

        public boolean canResolve(IntSet p_237677_) {
            for (int i : this.children) {
                if (!p_237677_.contains(i)) continue;
                return false;
            }
            return true;
        }
    }

    static interface NodeStub {
        public <S> ArgumentBuilder<S, ?> build(CommandBuildContext var1, NodeBuilder<S> var2);

        public void write(FriendlyByteBuf var1);
    }

    record ArgumentNodeStub(String id, ArgumentTypeInfo.Template<?> argumentType, @Nullable ResourceLocation suggestionId) implements NodeStub
    {
        @Override
        public <S> ArgumentBuilder<S, ?> build(CommandBuildContext p_237656_, NodeBuilder<S> p_426292_) {
            Object argumenttype = this.argumentType.instantiate(p_237656_);
            return p_426292_.createArgument(this.id, (ArgumentType<?>)argumenttype, this.suggestionId);
        }

        @Override
        public void write(FriendlyByteBuf p_237658_) {
            p_237658_.writeUtf(this.id);
            ArgumentNodeStub.serializeCap(p_237658_, this.argumentType);
            if (this.suggestionId != null) {
                p_237658_.writeResourceLocation(this.suggestionId);
            }
        }

        private static <A extends ArgumentType<?>> void serializeCap(FriendlyByteBuf p_237660_, ArgumentTypeInfo.Template<A> p_237661_) {
            ArgumentNodeStub.serializeCap(p_237660_, p_237661_.type(), p_237661_);
        }

        private static <A extends ArgumentType<?>, T extends ArgumentTypeInfo.Template<A>> void serializeCap(FriendlyByteBuf p_237663_, ArgumentTypeInfo<A, T> p_237664_, ArgumentTypeInfo.Template<A> p_237665_) {
            p_237663_.writeVarInt(BuiltInRegistries.COMMAND_ARGUMENT_TYPE.getId(p_237664_));
            p_237664_.serializeToNetwork(p_237665_, p_237663_);
        }
    }

    record LiteralNodeStub(String id) implements NodeStub
    {
        @Override
        public <S> ArgumentBuilder<S, ?> build(CommandBuildContext p_237682_, NodeBuilder<S> p_426272_) {
            return p_426272_.createLiteral(this.id);
        }

        @Override
        public void write(FriendlyByteBuf p_237684_) {
            p_237684_.writeUtf(this.id);
        }
    }

    static class NodeResolver<S> {
        private final CommandBuildContext context;
        private final NodeBuilder<S> builder;
        private final List<Entry> entries;
        private final List<CommandNode<S>> nodes;

        NodeResolver(CommandBuildContext p_237689_, NodeBuilder<S> p_425914_, List<Entry> p_237690_) {
            this.context = p_237689_;
            this.builder = p_425914_;
            this.entries = p_237690_;
            ObjectArrayList objectarraylist = new ObjectArrayList();
            objectarraylist.size(p_237690_.size());
            this.nodes = objectarraylist;
        }

        public CommandNode<S> resolve(int p_237692_) {
            RootCommandNode commandnode1;
            CommandNode<S> commandnode = this.nodes.get(p_237692_);
            if (commandnode != null) {
                return commandnode;
            }
            Entry clientboundcommandspacket$entry = this.entries.get(p_237692_);
            if (clientboundcommandspacket$entry.stub == null) {
                commandnode1 = new RootCommandNode();
            } else {
                ArgumentBuilder<S, ?> argumentbuilder = clientboundcommandspacket$entry.stub.build(this.context, this.builder);
                if ((clientboundcommandspacket$entry.flags & 8) != 0) {
                    argumentbuilder.redirect(this.resolve(clientboundcommandspacket$entry.redirect));
                }
                boolean flag = (clientboundcommandspacket$entry.flags & 4) != 0;
                boolean flag1 = (clientboundcommandspacket$entry.flags & 0x20) != 0;
                commandnode1 = this.builder.configure(argumentbuilder, flag, flag1).build();
            }
            this.nodes.set(p_237692_, (CommandNode<S>)commandnode1);
            for (int i : clientboundcommandspacket$entry.children) {
                CommandNode<S> commandnode2 = this.resolve(i);
                if (commandnode2 instanceof RootCommandNode) continue;
                commandnode1.addChild(commandnode2);
            }
            return commandnode1;
        }
    }

    public static interface NodeBuilder<S> {
        public ArgumentBuilder<S, ?> createLiteral(String var1);

        public ArgumentBuilder<S, ?> createArgument(String var1, ArgumentType<?> var2, @Nullable ResourceLocation var3);

        public ArgumentBuilder<S, ?> configure(ArgumentBuilder<S, ?> var1, boolean var2, boolean var3);
    }
}

