/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.common.custom;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.codec.StreamDecoder;
import net.minecraft.network.codec.StreamMemberEncoder;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.registration.NetworkRegistry;

public interface CustomPacketPayload {
    public Type<? extends CustomPacketPayload> type();

    public static <B extends ByteBuf, T extends CustomPacketPayload> StreamCodec<B, T> codec(StreamMemberEncoder<B, T> p_319960_, StreamDecoder<B, T> p_320047_) {
        return StreamCodec.ofMember(p_319960_, p_320047_);
    }

    public static <T extends CustomPacketPayload> Type<T> createType(String p_319908_) {
        return new Type(ResourceLocation.withDefaultNamespace(p_319908_));
    }

    public static <B extends FriendlyByteBuf> StreamCodec<B, CustomPacketPayload> codec(final FallbackProvider<B> p_319839_, List<TypeAndCodec<? super B, ?>> p_320495_, final ConnectionProtocol protocol, final PacketFlow packetFlow) {
        final Map<ResourceLocation, StreamCodec> map = p_320495_.stream().collect(Collectors.toUnmodifiableMap(p_320895_ -> p_320895_.type().id(), TypeAndCodec::codec));
        return new StreamCodec<B, CustomPacketPayload>(){

            private StreamCodec<? super B, ? extends CustomPacketPayload> findCodec(ResourceLocation p_320938_) {
                StreamCodec streamcodec = (StreamCodec)map.get(p_320938_);
                if (streamcodec == null) {
                    streamcodec = NetworkRegistry.getCodec((ResourceLocation)p_320938_, (ConnectionProtocol)protocol, (PacketFlow)packetFlow);
                }
                return streamcodec != null ? streamcodec : p_319839_.create(p_320938_);
            }

            private <T extends CustomPacketPayload> void writeCap(B p_320565_, Type<T> p_320917_, CustomPacketPayload p_320112_) {
                ((FriendlyByteBuf)((Object)p_320565_)).writeResourceLocation(p_320917_.id());
                StreamCodec streamcodec = this.findCodec(p_320917_.id);
                try {
                    streamcodec.encode(p_320565_, p_320112_);
                }
                catch (RuntimeException e) {
                    throw new RuntimeException("Failed encoding custom payload " + String.valueOf(p_320917_.id()) + ": " + String.valueOf(e), e);
                }
            }

            @Override
            public void encode(B p_320490_, CustomPacketPayload p_319776_) {
                this.writeCap(p_320490_, p_319776_.type(), p_319776_);
            }

            @Override
            public CustomPacketPayload decode(B p_320227_) {
                ResourceLocation resourcelocation = ((FriendlyByteBuf)((Object)p_320227_)).readResourceLocation();
                try {
                    return (CustomPacketPayload)this.findCodec(resourcelocation).decode(p_320227_);
                }
                catch (RuntimeException e) {
                    throw new RuntimeException("Failed decoding custom payload " + String.valueOf(resourcelocation) + ": " + String.valueOf(e), e);
                }
            }
        };
    }

    default public ClientboundCustomPayloadPacket toVanillaClientbound() {
        return new ClientboundCustomPayloadPacket(this);
    }

    default public ServerboundCustomPayloadPacket toVanillaServerbound() {
        return new ServerboundCustomPayloadPacket(this);
    }

    public record Type<T extends CustomPacketPayload>(ResourceLocation id) {
    }

    public static interface FallbackProvider<B extends FriendlyByteBuf> {
        public StreamCodec<B, ? extends CustomPacketPayload> create(ResourceLocation var1);
    }

    public record TypeAndCodec<B extends FriendlyByteBuf, T extends CustomPacketPayload>(Type<T> type, StreamCodec<B, T> codec) {
    }
}

