/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol;

import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.BundleDelimiterPacket;
import net.minecraft.network.protocol.BundlePacket;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.neoforged.neoforge.network.registration.NetworkRegistry;

public interface BundlerInfo {
    public static final int BUNDLE_SIZE_LIMIT = 4096;

    public static <T extends PacketListener, P extends BundlePacket<? super T>> BundlerInfo createForPacket(final PacketType<P> p_320816_, final Function<Iterable<Packet<? super T>>, P> p_265627_, final BundleDelimiterPacket<? super T> p_265373_) {
        return new BundlerInfo(){

            @Override
            public void unbundlePacket(Packet<?> p_265538_, Consumer<Packet<?>> p_265064_) {
                if (p_265538_.type() == p_320816_) {
                    BundlePacket p = (BundlePacket)p_265538_;
                    p_265064_.accept(p_265373_);
                    p.subPackets().forEach(p_265064_);
                    p_265064_.accept(p_265373_);
                } else {
                    p_265064_.accept(p_265538_);
                }
            }

            @Override
            public void unbundlePacket(Packet<?> bundlePacket, Consumer<Packet<?>> packetSender, ChannelHandlerContext context) {
                if (bundlePacket.type() == p_320816_) {
                    BundlePacket p = (BundlePacket)bundlePacket;
                    List packets = NetworkRegistry.filterGameBundlePackets((ChannelHandlerContext)context, p.subPackets());
                    if (packets.isEmpty()) {
                        return;
                    }
                    if (packets.size() == 1) {
                        packetSender.accept((Packet)packets.get(0));
                        return;
                    }
                    packetSender.accept(p_265373_);
                    packets.forEach(packetSender);
                    packetSender.accept(p_265373_);
                } else {
                    packetSender.accept(bundlePacket);
                }
            }

            @Override
            @Nullable
            public Bundler startPacketBundling(Packet<?> p_265749_) {
                return p_265749_ == p_265373_ ? new Bundler(){
                    private final List<Packet<? super T>> bundlePackets = new ArrayList();

                    @Override
                    @Nullable
                    public Packet<?> addPacket(Packet<?> p_320276_) {
                        if (p_320276_ == p_265373_) {
                            return (Packet)p_265627_.apply(this.bundlePackets);
                        }
                        if (this.bundlePackets.size() >= 4096) {
                            throw new IllegalStateException("Too many packets in a bundle");
                        }
                        this.bundlePackets.add(p_320276_);
                        return null;
                    }
                } : null;
            }
        };
    }

    @Deprecated
    public void unbundlePacket(Packet<?> var1, Consumer<Packet<?>> var2);

    default public void unbundlePacket(Packet<?> bundlePacket, Consumer<Packet<?>> packetSender, ChannelHandlerContext context) {
        this.unbundlePacket(bundlePacket, packetSender);
    }

    @Nullable
    public Bundler startPacketBundling(Packet<?> var1);

    public static interface Bundler {
        @Nullable
        public Packet<?> addPacket(Packet<?> var1);
    }
}

