/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.codec;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.network.VarInt;
import net.minecraft.network.codec.StreamCodec;

public class IdDispatchCodec<B extends ByteBuf, V, T>
implements StreamCodec<B, V> {
    private static final int UNKNOWN_TYPE = -1;
    private final Function<V, ? extends T> typeGetter;
    private final List<Entry<B, V, T>> byId;
    private final Object2IntMap<T> toId;

    IdDispatchCodec(Function<V, ? extends T> p_320468_, List<Entry<B, V, T>> p_320536_, Object2IntMap<T> p_320597_) {
        this.typeGetter = p_320468_;
        this.byId = p_320536_;
        this.toId = p_320597_;
    }

    @Override
    public V decode(B p_320374_) {
        int i = VarInt.read(p_320374_);
        if (i >= 0 && i < this.byId.size()) {
            Entry<B, V, T> entry = this.byId.get(i);
            try {
                return (V)entry.serializer.decode(p_320374_);
            }
            catch (Exception exception) {
                if (exception instanceof DontDecorateException) {
                    throw exception;
                }
                throw new DecoderException("Failed to decode packet '" + String.valueOf(entry.type) + "'", (Throwable)exception);
            }
        }
        throw new DecoderException("Received unknown packet id " + i);
    }

    @Override
    public void encode(B p_319955_, V p_320138_) {
        T t = this.typeGetter.apply(p_320138_);
        int i = this.toId.getOrDefault(t, -1);
        if (i == -1) {
            throw new EncoderException("Sending unknown packet '" + String.valueOf(t) + "'");
        }
        VarInt.write(p_319955_, i);
        Entry<B, V, T> entry = this.byId.get(i);
        try {
            StreamCodec streamcodec = entry.serializer;
            streamcodec.encode(p_319955_, p_320138_);
        }
        catch (Exception exception) {
            if (exception instanceof DontDecorateException) {
                throw exception;
            }
            throw new EncoderException("Failed to encode packet '" + String.valueOf(t) + "'", (Throwable)exception);
        }
    }

    public static <B extends ByteBuf, V, T> Builder<B, V, T> builder(Function<V, ? extends T> p_319781_) {
        return new Builder(p_319781_);
    }

    record Entry<B, V, T>(StreamCodec<? super B, ? extends V> serializer, T type) {
    }

    public static interface DontDecorateException {
    }

    public static class Builder<B extends ByteBuf, V, T> {
        private final List<Entry<B, V, T>> entries = new ArrayList<Entry<B, V, T>>();
        private final Function<V, ? extends T> typeGetter;

        Builder(Function<V, ? extends T> p_320009_) {
            this.typeGetter = p_320009_;
        }

        public Builder<B, V, T> add(T p_320423_, StreamCodec<? super B, ? extends V> p_320781_) {
            this.entries.add(new Entry<B, V, T>(p_320781_, p_320423_));
            return this;
        }

        public IdDispatchCodec<B, V, T> build() {
            Object2IntOpenHashMap object2intopenhashmap = new Object2IntOpenHashMap();
            object2intopenhashmap.defaultReturnValue(-2);
            for (Entry<B, V, T> entry : this.entries) {
                int i = object2intopenhashmap.size();
                int j = object2intopenhashmap.putIfAbsent(entry.type, i);
                if (j == -2) continue;
                throw new IllegalStateException("Duplicate registration for type " + String.valueOf(entry.type));
            }
            return new IdDispatchCodec<B, V, T>(this.typeGetter, List.copyOf(this.entries), object2intopenhashmap);
        }
    }
}

