/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat.contents;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.NbtPathArgument;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.DataSource;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.entity.Entity;
import org.slf4j.Logger;

public class NbtContents
implements ComponentContents {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final MapCodec<NbtContents> CODEC = RecordCodecBuilder.mapCodec(p_337510_ -> p_337510_.group((App)Codec.STRING.fieldOf("nbt").forGetter(NbtContents::getNbtPath), (App)Codec.BOOL.lenientOptionalFieldOf("interpret", (Object)false).forGetter(NbtContents::isInterpreting), (App)ComponentSerialization.CODEC.lenientOptionalFieldOf("separator").forGetter(NbtContents::getSeparator), (App)DataSource.CODEC.forGetter(NbtContents::getDataSource)).apply((Applicative)p_337510_, NbtContents::new));
    public static final ComponentContents.Type<NbtContents> TYPE = new ComponentContents.Type<NbtContents>(CODEC, "nbt");
    private final boolean interpreting;
    private final Optional<Component> separator;
    private final String nbtPathPattern;
    private final DataSource dataSource;
    @Nullable
    protected final NbtPathArgument.NbtPath compiledNbtPath;

    public NbtContents(String p_237395_, boolean p_237396_, Optional<Component> p_237397_, DataSource p_237398_) {
        this(p_237395_, NbtContents.compileNbtPath(p_237395_), p_237396_, p_237397_, p_237398_);
    }

    private NbtContents(String p_237389_, @Nullable NbtPathArgument.NbtPath p_237390_, boolean p_237391_, Optional<Component> p_237392_, DataSource p_237393_) {
        this.nbtPathPattern = p_237389_;
        this.compiledNbtPath = p_237390_;
        this.interpreting = p_237391_;
        this.separator = p_237392_;
        this.dataSource = p_237393_;
    }

    @Nullable
    private static NbtPathArgument.NbtPath compileNbtPath(String p_237410_) {
        try {
            return new NbtPathArgument().parse(new StringReader(p_237410_));
        }
        catch (CommandSyntaxException commandsyntaxexception) {
            return null;
        }
    }

    public String getNbtPath() {
        return this.nbtPathPattern;
    }

    public boolean isInterpreting() {
        return this.interpreting;
    }

    public Optional<Component> getSeparator() {
        return this.separator;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object p_237430_) {
        if (this == p_237430_) {
            return true;
        }
        if (!(p_237430_ instanceof NbtContents)) return false;
        NbtContents nbtcontents = (NbtContents)p_237430_;
        if (!this.dataSource.equals(nbtcontents.dataSource)) return false;
        if (!this.separator.equals(nbtcontents.separator)) return false;
        if (this.interpreting != nbtcontents.interpreting) return false;
        if (!this.nbtPathPattern.equals(nbtcontents.nbtPathPattern)) return false;
        return true;
    }

    public int hashCode() {
        int i = this.interpreting ? 1 : 0;
        i = 31 * i + this.separator.hashCode();
        i = 31 * i + this.nbtPathPattern.hashCode();
        return 31 * i + this.dataSource.hashCode();
    }

    public String toString() {
        return "nbt{" + String.valueOf(this.dataSource) + ", interpreting=" + this.interpreting + ", separator=" + String.valueOf(this.separator) + "}";
    }

    @Override
    public MutableComponent resolve(@Nullable CommandSourceStack p_237401_, @Nullable Entity p_237402_, int p_237403_) throws CommandSyntaxException {
        if (p_237401_ != null && this.compiledNbtPath != null) {
            Stream<String> stream = this.dataSource.getData(p_237401_).flatMap(p_237417_ -> {
                try {
                    return this.compiledNbtPath.get((Tag)p_237417_).stream();
                }
                catch (CommandSyntaxException commandsyntaxexception) {
                    return Stream.empty();
                }
            });
            if (this.interpreting) {
                RegistryOps<Tag> registryops = p_237401_.registryAccess().createSerializationContext(NbtOps.INSTANCE);
                Component component = (Component)DataFixUtils.orElse(ComponentUtils.updateForEntity(p_237401_, this.separator, p_237402_, p_237403_), (Object)ComponentUtils.DEFAULT_NO_STYLE_SEPARATOR);
                return stream.flatMap(p_392622_ -> {
                    try {
                        Component component1 = (Component)ComponentSerialization.CODEC.parse((DynamicOps)registryops, p_392622_).getOrThrow();
                        return Stream.of(ComponentUtils.updateForEntity(p_237401_, component1, p_237402_, p_237403_));
                    }
                    catch (Exception exception) {
                        LOGGER.warn("Failed to parse component: {}", p_392622_, (Object)exception);
                        return Stream.of(new MutableComponent[0]);
                    }
                }).reduce((p_237420_, p_237421_) -> p_237420_.append(component).append((Component)p_237421_)).orElseGet(Component::empty);
            }
            Stream<String> stream1 = stream.map(NbtContents::asString);
            return ComponentUtils.updateForEntity(p_237401_, this.separator, p_237402_, p_237403_).map(p_237415_ -> stream1.map(Component::literal).reduce((p_237424_, p_237425_) -> p_237424_.append((Component)p_237415_).append((Component)p_237425_)).orElseGet(Component::empty)).orElseGet(() -> Component.literal(stream1.collect(Collectors.joining(", "))));
        }
        return Component.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String asString(Tag p_409593_) {
        String string;
        if (!(p_409593_ instanceof StringTag)) {
            string = p_409593_.toString();
            return string;
        }
        StringTag stringTag = (StringTag)p_409593_;
        try {
            String string2;
            String s;
            string = s = (string2 = stringTag.value());
            return string;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    @Override
    public ComponentContents.Type<?> type() {
        return TYPE;
    }
}

