/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.mojang.logging.LogUtils;
import java.time.Instant;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FilterMask;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.chat.SignedMessageBody;
import net.minecraft.network.chat.SignedMessageLink;
import net.minecraft.network.chat.ThrowingComponent;
import net.minecraft.util.SignatureValidator;
import net.minecraft.util.Signer;
import net.minecraft.world.entity.player.ProfilePublicKey;
import org.slf4j.Logger;

public class SignedMessageChain {
    static final Logger LOGGER = LogUtils.getLogger();
    @Nullable
    SignedMessageLink nextLink;
    Instant lastTimeStamp = Instant.EPOCH;

    public SignedMessageChain(UUID p_250050_, UUID p_249127_) {
        this.nextLink = SignedMessageLink.root(p_250050_, p_249127_);
    }

    public Encoder encoder(Signer p_248636_) {
        return p_337505_ -> {
            SignedMessageLink signedmessagelink = this.nextLink;
            if (signedmessagelink == null) {
                return null;
            }
            this.nextLink = signedmessagelink.advance();
            return new MessageSignature(p_248636_.sign(p_248065_ -> PlayerChatMessage.updateSignature(p_248065_, signedmessagelink, p_337505_)));
        };
    }

    public Decoder decoder(final ProfilePublicKey p_249122_) {
        final SignatureValidator signaturevalidator = p_249122_.createSignatureValidator();
        return new Decoder(){

            @Override
            public PlayerChatMessage unpack(@Nullable MessageSignature p_338553_, SignedMessageBody p_338592_) throws DecodeException {
                if (p_338553_ == null) {
                    throw new DecodeException(DecodeException.MISSING_PROFILE_KEY);
                }
                if (p_249122_.data().hasExpired()) {
                    throw new DecodeException(DecodeException.EXPIRED_PROFILE_KEY);
                }
                SignedMessageLink signedmessagelink = SignedMessageChain.this.nextLink;
                if (signedmessagelink == null) {
                    throw new DecodeException(DecodeException.CHAIN_BROKEN);
                }
                if (p_338592_.timeStamp().isBefore(SignedMessageChain.this.lastTimeStamp)) {
                    this.setChainBroken();
                    throw new DecodeException(DecodeException.OUT_OF_ORDER_CHAT);
                }
                SignedMessageChain.this.lastTimeStamp = p_338592_.timeStamp();
                PlayerChatMessage playerchatmessage = new PlayerChatMessage(signedmessagelink, p_338553_, p_338592_, null, FilterMask.PASS_THROUGH);
                if (!playerchatmessage.verify(signaturevalidator)) {
                    this.setChainBroken();
                    throw new DecodeException(DecodeException.INVALID_SIGNATURE);
                }
                if (playerchatmessage.hasExpiredServer(Instant.now())) {
                    LOGGER.warn("Received expired chat: '{}'. Is the client/server system time unsynchronized?", (Object)p_338592_.content());
                }
                SignedMessageChain.this.nextLink = signedmessagelink.advance();
                return playerchatmessage;
            }

            @Override
            public void setChainBroken() {
                SignedMessageChain.this.nextLink = null;
            }
        };
    }

    @FunctionalInterface
    public static interface Encoder {
        public static final Encoder UNSIGNED = p_250548_ -> null;

        @Nullable
        public MessageSignature pack(SignedMessageBody var1);
    }

    @FunctionalInterface
    public static interface Decoder {
        public static Decoder unsigned(UUID p_251747_, BooleanSupplier p_315009_) {
            return (p_337508_, p_337509_) -> {
                if (p_315009_.getAsBoolean()) {
                    throw new DecodeException(DecodeException.MISSING_PROFILE_KEY);
                }
                return PlayerChatMessage.unsigned(p_251747_, p_337509_.content());
            };
        }

        public PlayerChatMessage unpack(@Nullable MessageSignature var1, SignedMessageBody var2) throws DecodeException;

        default public void setChainBroken() {
        }
    }

    public static class DecodeException
    extends ThrowingComponent {
        static final Component MISSING_PROFILE_KEY = Component.translatable("chat.disabled.missingProfileKey");
        static final Component CHAIN_BROKEN = Component.translatable("chat.disabled.chain_broken");
        static final Component EXPIRED_PROFILE_KEY = Component.translatable("chat.disabled.expiredProfileKey");
        static final Component INVALID_SIGNATURE = Component.translatable("chat.disabled.invalid_signature");
        static final Component OUT_OF_ORDER_CHAT = Component.translatable("chat.disabled.out_of_order_chat");

        public DecodeException(Component p_249149_) {
            super(p_249149_);
        }
    }
}

