/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayDeque;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.SignedMessageBody;
import org.jetbrains.annotations.VisibleForTesting;

public class MessageSignatureCache {
    public static final int NOT_FOUND = -1;
    private static final int DEFAULT_CAPACITY = 128;
    private final MessageSignature[] entries;

    public MessageSignatureCache(int p_250894_) {
        this.entries = new MessageSignature[p_250894_];
    }

    public static MessageSignatureCache createDefault() {
        return new MessageSignatureCache(128);
    }

    public int pack(MessageSignature p_254157_) {
        for (int i = 0; i < this.entries.length; ++i) {
            if (!p_254157_.equals(this.entries[i])) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    public MessageSignature unpack(int p_253967_) {
        return this.entries[p_253967_];
    }

    public void push(SignedMessageBody p_314937_, @Nullable MessageSignature p_314936_) {
        List<MessageSignature> list = p_314937_.lastSeen().entries();
        ArrayDeque<MessageSignature> arraydeque = new ArrayDeque<MessageSignature>(list.size() + 1);
        arraydeque.addAll(list);
        if (p_314936_ != null) {
            arraydeque.add(p_314936_);
        }
        this.push(arraydeque);
    }

    @VisibleForTesting
    void push(List<MessageSignature> p_248560_) {
        this.push(new ArrayDeque<MessageSignature>(p_248560_));
    }

    private void push(ArrayDeque<MessageSignature> p_251419_) {
        ObjectOpenHashSet set = new ObjectOpenHashSet(p_251419_);
        for (int i = 0; !p_251419_.isEmpty() && i < this.entries.length; ++i) {
            MessageSignature messagesignature = this.entries[i];
            this.entries[i] = p_251419_.removeLast();
            if (messagesignature == null || set.contains(messagesignature)) continue;
            p_251419_.addFirst(messagesignature);
        }
    }
}

