/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.LastSeenMessages;
import net.minecraft.network.chat.LastSeenTrackedEntry;
import net.minecraft.network.chat.MessageSignature;

public class LastSeenMessagesValidator {
    private final int lastSeenCount;
    private final ObjectList<LastSeenTrackedEntry> trackedMessages = new ObjectArrayList();
    @Nullable
    private MessageSignature lastPendingMessage;

    public LastSeenMessagesValidator(int p_249951_) {
        this.lastSeenCount = p_249951_;
        for (int i = 0; i < p_249951_; ++i) {
            this.trackedMessages.add(null);
        }
    }

    public void addPending(MessageSignature p_248841_) {
        if (!p_248841_.equals(this.lastPendingMessage)) {
            this.trackedMessages.add((Object)new LastSeenTrackedEntry(p_248841_, true));
            this.lastPendingMessage = p_248841_;
        }
    }

    public int trackedMessagesCount() {
        return this.trackedMessages.size();
    }

    public void applyOffset(int p_251273_) throws ValidationException {
        int i = this.trackedMessages.size() - this.lastSeenCount;
        if (p_251273_ < 0 || p_251273_ > i) {
            throw new ValidationException("Advanced last seen window by " + p_251273_ + " messages, but expected at most " + i);
        }
        this.trackedMessages.removeElements(0, p_251273_);
    }

    public LastSeenMessages applyUpdate(LastSeenMessages.Update p_248868_) throws ValidationException {
        this.applyOffset(p_248868_.offset());
        ObjectArrayList objectlist = new ObjectArrayList(p_248868_.acknowledged().cardinality());
        if (p_248868_.acknowledged().length() > this.lastSeenCount) {
            throw new ValidationException("Last seen update contained " + p_248868_.acknowledged().length() + " messages, but maximum window size is " + this.lastSeenCount);
        }
        for (int i = 0; i < this.lastSeenCount; ++i) {
            boolean flag = p_248868_.acknowledged().get(i);
            LastSeenTrackedEntry lastseentrackedentry = (LastSeenTrackedEntry)this.trackedMessages.get(i);
            if (flag) {
                if (lastseentrackedentry == null) {
                    throw new ValidationException("Last seen update acknowledged unknown or previously ignored message at index " + i);
                }
                this.trackedMessages.set(i, (Object)lastseentrackedentry.acknowledge());
                objectlist.add((Object)lastseentrackedentry.signature());
                continue;
            }
            if (lastseentrackedentry != null && !lastseentrackedentry.pending()) {
                throw new ValidationException("Last seen update ignored previously acknowledged message at index " + i + " and signature " + String.valueOf(lastseentrackedentry.signature()));
            }
            this.trackedMessages.set(i, null);
        }
        LastSeenMessages lastseenmessages = new LastSeenMessages((List<MessageSignature>)objectlist);
        if (!p_248868_.verifyChecksum(lastseenmessages)) {
            throw new ValidationException("Checksum mismatch on last seen update: the client and server must have desynced");
        }
        return lastseenmessages;
    }

    public static class ValidationException
    extends Exception {
        public ValidationException(String p_412680_) {
            super(p_412680_);
        }
    }
}

