/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.network.chat.LastSeenMessages;
import net.minecraft.network.chat.LastSeenTrackedEntry;
import net.minecraft.network.chat.MessageSignature;

public class LastSeenMessagesTracker {
    private final LastSeenTrackedEntry[] trackedMessages;
    private int tail;
    private int offset;
    @Nullable
    private MessageSignature lastTrackedMessage;

    public LastSeenMessagesTracker(int p_242388_) {
        this.trackedMessages = new LastSeenTrackedEntry[p_242388_];
    }

    public boolean addPending(MessageSignature p_248926_, boolean p_250312_) {
        if (Objects.equals(p_248926_, this.lastTrackedMessage)) {
            return false;
        }
        this.lastTrackedMessage = p_248926_;
        this.addEntry(p_250312_ ? new LastSeenTrackedEntry(p_248926_, true) : null);
        return true;
    }

    private void addEntry(@Nullable LastSeenTrackedEntry p_250255_) {
        int i = this.tail;
        this.tail = (i + 1) % this.trackedMessages.length;
        ++this.offset;
        this.trackedMessages[i] = p_250255_;
    }

    public void ignorePending(MessageSignature p_251020_) {
        for (int i = 0; i < this.trackedMessages.length; ++i) {
            LastSeenTrackedEntry lastseentrackedentry = this.trackedMessages[i];
            if (lastseentrackedentry == null || !lastseentrackedentry.pending() || !p_251020_.equals(lastseentrackedentry.signature())) continue;
            this.trackedMessages[i] = null;
            break;
        }
    }

    public int getAndClearOffset() {
        int i = this.offset;
        this.offset = 0;
        return i;
    }

    public Update generateAndApplyUpdate() {
        int i = this.getAndClearOffset();
        BitSet bitset = new BitSet(this.trackedMessages.length);
        ObjectArrayList objectlist = new ObjectArrayList(this.trackedMessages.length);
        for (int j = 0; j < this.trackedMessages.length; ++j) {
            int k = (this.tail + j) % this.trackedMessages.length;
            LastSeenTrackedEntry lastseentrackedentry = this.trackedMessages[k];
            if (lastseentrackedentry == null) continue;
            bitset.set(j, true);
            objectlist.add((Object)lastseentrackedentry.signature());
            this.trackedMessages[k] = lastseentrackedentry.acknowledge();
        }
        LastSeenMessages lastseenmessages = new LastSeenMessages((List<MessageSignature>)objectlist);
        LastSeenMessages.Update lastseenmessages$update = new LastSeenMessages.Update(i, bitset, lastseenmessages.computeChecksum());
        return new Update(lastseenmessages, lastseenmessages$update);
    }

    public int offset() {
        return this.offset;
    }

    public record Update(LastSeenMessages lastSeen, LastSeenMessages.Update update) {
    }
}

