/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;

public interface HoverEvent {
    public static final Codec<HoverEvent> CODEC = Action.CODEC.dispatch("action", HoverEvent::action, p_392615_ -> p_392615_.codec);

    public Action action();

    public static enum Action implements StringRepresentable
    {
        SHOW_TEXT("show_text", true, ShowText.CODEC),
        SHOW_ITEM("show_item", true, ShowItem.CODEC),
        SHOW_ENTITY("show_entity", true, ShowEntity.CODEC);

        public static final Codec<Action> UNSAFE_CODEC;
        public static final Codec<Action> CODEC;
        private final String name;
        private final boolean allowFromServer;
        final MapCodec<? extends HoverEvent> codec;

        private Action(String p_393532_, boolean p_130843_, MapCodec<? extends HoverEvent> p_393857_) {
            this.name = p_393532_;
            this.allowFromServer = p_130843_;
            this.codec = p_393857_;
        }

        public boolean isAllowedFromServer() {
            return this.allowFromServer;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        public String toString() {
            return "<action " + this.name + ">";
        }

        private static DataResult<Action> filterForSerialization(Action p_304784_) {
            return !p_304784_.isAllowedFromServer() ? DataResult.error(() -> "Action not allowed: " + String.valueOf(p_304784_)) : DataResult.success((Object)p_304784_, (Lifecycle)Lifecycle.stable());
        }

        static {
            UNSAFE_CODEC = StringRepresentable.fromValues(Action::values);
            CODEC = UNSAFE_CODEC.validate(Action::filterForSerialization);
        }
    }

    public record ShowText(Component value) implements HoverEvent
    {
        public static final MapCodec<ShowText> CODEC = RecordCodecBuilder.mapCodec(p_393562_ -> p_393562_.group((App)ComponentSerialization.CODEC.fieldOf("value").forGetter(ShowText::value)).apply((Applicative)p_393562_, ShowText::new));

        @Override
        public Action action() {
            return Action.SHOW_TEXT;
        }
    }

    public record ShowItem(ItemStack item) implements HoverEvent
    {
        public static final MapCodec<ShowItem> CODEC = ItemStack.MAP_CODEC.xmap(ShowItem::new, ShowItem::item);

        public ShowItem(ItemStack item) {
            this.item = item = item.copy();
        }

        @Override
        public Action action() {
            return Action.SHOW_ITEM;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object p_394568_) {
            if (!(p_394568_ instanceof ShowItem)) return false;
            ShowItem hoverevent$showitem = (ShowItem)p_394568_;
            if (!ItemStack.matches(this.item, hoverevent$showitem.item)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return ItemStack.hashItemAndComponents(this.item);
        }
    }

    public record ShowEntity(EntityTooltipInfo entity) implements HoverEvent
    {
        public static final MapCodec<ShowEntity> CODEC = RecordCodecBuilder.mapCodec(p_394451_ -> p_394451_.group((App)EntityTooltipInfo.CODEC.forGetter(ShowEntity::entity)).apply((Applicative)p_394451_, ShowEntity::new));

        @Override
        public Action action() {
            return Action.SHOW_ENTITY;
        }
    }

    public static class EntityTooltipInfo {
        public static final MapCodec<EntityTooltipInfo> CODEC = RecordCodecBuilder.mapCodec(p_392616_ -> p_392616_.group((App)BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("id").forGetter(p_304417_ -> p_304417_.type), (App)UUIDUtil.LENIENT_CODEC.fieldOf("uuid").forGetter(p_392617_ -> p_392617_.uuid), (App)ComponentSerialization.CODEC.optionalFieldOf("name").forGetter(p_304585_ -> p_304585_.name)).apply((Applicative)p_392616_, EntityTooltipInfo::new));
        public final EntityType<?> type;
        public final UUID uuid;
        public final Optional<Component> name;
        @Nullable
        private List<Component> linesCache;

        public EntityTooltipInfo(EntityType<?> p_130876_, UUID p_130877_, @Nullable Component p_130878_) {
            this(p_130876_, p_130877_, Optional.ofNullable(p_130878_));
        }

        public EntityTooltipInfo(EntityType<?> p_304581_, UUID p_304712_, Optional<Component> p_304973_) {
            this.type = p_304581_;
            this.uuid = p_304712_;
            this.name = p_304973_;
        }

        public List<Component> getTooltipLines() {
            if (this.linesCache == null) {
                this.linesCache = new ArrayList<Component>();
                this.name.ifPresent(this.linesCache::add);
                this.linesCache.add(Component.translatable("gui.entity_tooltip.type", this.type.getDescription()));
                this.linesCache.add(Component.literal(this.uuid.toString()));
            }
            return this.linesCache;
        }

        public boolean equals(Object p_130886_) {
            if (this == p_130886_) {
                return true;
            }
            if (p_130886_ != null && this.getClass() == p_130886_.getClass()) {
                EntityTooltipInfo hoverevent$entitytooltipinfo = (EntityTooltipInfo)p_130886_;
                return this.type.equals(hoverevent$entitytooltipinfo.type) && this.uuid.equals(hoverevent$entitytooltipinfo.uuid) && this.name.equals(hoverevent$entitytooltipinfo.name);
            }
            return false;
        }

        public int hashCode() {
            int i = this.type.hashCode();
            i = 31 * i + this.uuid.hashCode();
            return 31 * i + this.name.hashCode();
        }
    }
}

