/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.BitSet;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import org.apache.commons.lang3.StringUtils;

public class FilterMask {
    public static final Codec<FilterMask> CODEC = StringRepresentable.fromEnum(Type::values).dispatch(FilterMask::type, Type::codec);
    public static final FilterMask FULLY_FILTERED = new FilterMask(new BitSet(0), Type.FULLY_FILTERED);
    public static final FilterMask PASS_THROUGH = new FilterMask(new BitSet(0), Type.PASS_THROUGH);
    public static final Style FILTERED_STYLE = Style.EMPTY.withColor(ChatFormatting.DARK_GRAY).withHoverEvent(new HoverEvent.ShowText(Component.translatable("chat.filtered")));
    static final MapCodec<FilterMask> PASS_THROUGH_CODEC = MapCodec.unit((Object)PASS_THROUGH);
    static final MapCodec<FilterMask> FULLY_FILTERED_CODEC = MapCodec.unit((Object)FULLY_FILTERED);
    static final MapCodec<FilterMask> PARTIALLY_FILTERED_CODEC = ExtraCodecs.BIT_SET.xmap(FilterMask::new, FilterMask::mask).fieldOf("value");
    private static final char HASH = '#';
    private final BitSet mask;
    private final Type type;

    private FilterMask(BitSet p_243243_, Type p_243249_) {
        this.mask = p_243243_;
        this.type = p_243249_;
    }

    private FilterMask(BitSet p_253780_) {
        this.mask = p_253780_;
        this.type = Type.PARTIALLY_FILTERED;
    }

    public FilterMask(int p_243210_) {
        this(new BitSet(p_243210_), Type.PARTIALLY_FILTERED);
    }

    private Type type() {
        return this.type;
    }

    private BitSet mask() {
        return this.mask;
    }

    public static FilterMask read(FriendlyByteBuf p_243205_) {
        Type filtermask$type = p_243205_.readEnum(Type.class);
        return switch (filtermask$type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> PASS_THROUGH;
            case 1 -> FULLY_FILTERED;
            case 2 -> new FilterMask(p_243205_.readBitSet(), Type.PARTIALLY_FILTERED);
        };
    }

    public static void write(FriendlyByteBuf p_243308_, FilterMask p_243231_) {
        p_243308_.writeEnum(p_243231_.type);
        if (p_243231_.type == Type.PARTIALLY_FILTERED) {
            p_243308_.writeBitSet(p_243231_.mask);
        }
    }

    public void setFiltered(int p_243202_) {
        this.mask.set(p_243202_);
    }

    @Nullable
    public String apply(String p_243317_) {
        return switch (this.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> p_243317_;
            case 1 -> null;
            case 2 -> {
                char[] achar = p_243317_.toCharArray();
                for (int i = 0; i < achar.length && i < this.mask.length(); ++i) {
                    if (!this.mask.get(i)) continue;
                    achar[i] = 35;
                }
                yield new String(achar);
            }
        };
    }

    @Nullable
    public Component applyWithFormatting(String p_251709_) {
        MutableComponent mutableComponent;
        block0 : switch (this.type.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                mutableComponent = Component.literal(p_251709_);
                break;
            }
            case 1: {
                mutableComponent = null;
                break;
            }
            case 2: {
                MutableComponent mutablecomponent = Component.empty();
                int i = 0;
                boolean flag = this.mask.get(0);
                while (true) {
                    int j = flag ? this.mask.nextClearBit(i) : this.mask.nextSetBit(i);
                    int n = j = j < 0 ? p_251709_.length() : j;
                    if (j == i) {
                        mutableComponent = mutablecomponent;
                        break block0;
                    }
                    if (flag) {
                        mutablecomponent.append(Component.literal(StringUtils.repeat((char)'#', (int)(j - i))).withStyle(FILTERED_STYLE));
                    } else {
                        mutablecomponent.append(p_251709_.substring(i, j));
                    }
                    flag = !flag;
                    i = j;
                }
            }
        }
        return mutableComponent;
    }

    public boolean isEmpty() {
        return this.type == Type.PASS_THROUGH;
    }

    public boolean isFullyFiltered() {
        return this.type == Type.FULLY_FILTERED;
    }

    public boolean equals(Object p_254275_) {
        if (this == p_254275_) {
            return true;
        }
        if (p_254275_ != null && this.getClass() == p_254275_.getClass()) {
            FilterMask filtermask = (FilterMask)p_254275_;
            return this.mask.equals(filtermask.mask) && this.type == filtermask.type;
        }
        return false;
    }

    public int hashCode() {
        int i = this.mask.hashCode();
        return 31 * i + this.type.hashCode();
    }

    static enum Type implements StringRepresentable
    {
        PASS_THROUGH("pass_through", () -> PASS_THROUGH_CODEC),
        FULLY_FILTERED("fully_filtered", () -> FULLY_FILTERED_CODEC),
        PARTIALLY_FILTERED("partially_filtered", () -> PARTIALLY_FILTERED_CODEC);

        private final String serializedName;
        private final Supplier<MapCodec<FilterMask>> codec;

        private Type(String p_253679_, Supplier<MapCodec<FilterMask>> p_253988_) {
            this.serializedName = p_253679_;
            this.codec = p_253988_;
        }

        @Override
        public String getSerializedName() {
            return this.serializedName;
        }

        private MapCodec<FilterMask> codec() {
            return this.codec.get();
        }
    }
}

