/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.collect.Lists;
import com.mojang.brigadier.Message;
import com.mojang.datafixers.util.Either;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.selector.SelectorPattern;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.DataSource;
import net.minecraft.network.chat.contents.KeybindContents;
import net.minecraft.network.chat.contents.NbtContents;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.chat.contents.ScoreContents;
import net.minecraft.network.chat.contents.SelectorContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.ChunkPos;

public interface Component
extends Message,
FormattedText {
    public Style getStyle();

    public ComponentContents getContents();

    @Override
    default public String getString() {
        return FormattedText.super.getString();
    }

    default public String getString(int p_130669_) {
        StringBuilder stringbuilder = new StringBuilder();
        this.visit(p_130673_ -> {
            int i = p_130669_ - stringbuilder.length();
            if (i <= 0) {
                return STOP_ITERATION;
            }
            stringbuilder.append(p_130673_.length() <= i ? p_130673_ : p_130673_.substring(0, i));
            return Optional.empty();
        });
        return stringbuilder.toString();
    }

    public List<Component> getSiblings();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    default public String tryCollapseToString() {
        ComponentContents componentContents = this.getContents();
        if (!(componentContents instanceof PlainTextContents)) return null;
        PlainTextContents plaintextcontents = (PlainTextContents)componentContents;
        if (!this.getSiblings().isEmpty()) return null;
        if (!this.getStyle().isEmpty()) return null;
        String string = plaintextcontents.text();
        return string;
    }

    default public MutableComponent plainCopy() {
        return MutableComponent.create(this.getContents());
    }

    default public MutableComponent copy() {
        return new MutableComponent(this.getContents(), new ArrayList<Component>(this.getSiblings()), this.getStyle());
    }

    public FormattedCharSequence getVisualOrderText();

    @Override
    default public <T> Optional<T> visit(FormattedText.StyledContentConsumer<T> p_130679_, Style p_130680_) {
        Style style = this.getStyle().applyTo(p_130680_);
        Optional<T> optional = this.getContents().visit(p_130679_, style);
        if (optional.isPresent()) {
            return optional;
        }
        for (Component component : this.getSiblings()) {
            Optional<T> optional1 = component.visit(p_130679_, style);
            if (!optional1.isPresent()) continue;
            return optional1;
        }
        return Optional.empty();
    }

    @Override
    default public <T> Optional<T> visit(FormattedText.ContentConsumer<T> p_130677_) {
        Optional<T> optional = this.getContents().visit(p_130677_);
        if (optional.isPresent()) {
            return optional;
        }
        for (Component component : this.getSiblings()) {
            Optional<T> optional1 = component.visit(p_130677_);
            if (!optional1.isPresent()) continue;
            return optional1;
        }
        return Optional.empty();
    }

    default public List<Component> toFlatList() {
        return this.toFlatList(Style.EMPTY);
    }

    default public List<Component> toFlatList(Style p_178406_) {
        ArrayList list = Lists.newArrayList();
        this.visit((p_178403_, p_178404_) -> {
            if (!p_178404_.isEmpty()) {
                list.add(Component.literal(p_178404_).withStyle(p_178403_));
            }
            return Optional.empty();
        }, p_178406_);
        return list;
    }

    default public boolean contains(Component p_240571_) {
        List<Component> list1;
        if (this.equals(p_240571_)) {
            return true;
        }
        List<Component> list = this.toFlatList();
        return Collections.indexOfSubList(list, list1 = p_240571_.toFlatList(this.getStyle())) != -1;
    }

    public static Component nullToEmpty(@Nullable String p_130675_) {
        return p_130675_ != null ? Component.literal(p_130675_) : CommonComponents.EMPTY;
    }

    public static MutableComponent literal(String p_237114_) {
        return MutableComponent.create(PlainTextContents.create(p_237114_));
    }

    public static MutableComponent translatable(String p_237116_) {
        return MutableComponent.create(new TranslatableContents(p_237116_, null, TranslatableContents.NO_ARGS));
    }

    public static MutableComponent translatable(String p_237111_, Object ... p_237112_) {
        return MutableComponent.create(new TranslatableContents(p_237111_, null, p_237112_));
    }

    public static MutableComponent translatableEscape(String p_304683_, Object ... p_304399_) {
        for (int i = 0; i < p_304399_.length; ++i) {
            Object object = p_304399_[i];
            if (TranslatableContents.isAllowedPrimitiveArgument(object) || object instanceof Component) continue;
            p_304399_[i] = String.valueOf(object);
        }
        return Component.translatable(p_304683_, p_304399_);
    }

    public static MutableComponent translatableWithFallback(String p_265747_, @Nullable String p_265287_) {
        return MutableComponent.create(new TranslatableContents(p_265747_, p_265287_, TranslatableContents.NO_ARGS));
    }

    public static MutableComponent translatableWithFallback(String p_265449_, @Nullable String p_265281_, Object ... p_265785_) {
        return MutableComponent.create(new TranslatableContents(p_265449_, p_265281_, p_265785_));
    }

    public static MutableComponent empty() {
        return MutableComponent.create(PlainTextContents.EMPTY);
    }

    public static MutableComponent keybind(String p_237118_) {
        return MutableComponent.create(new KeybindContents(p_237118_));
    }

    public static MutableComponent nbt(String p_237106_, boolean p_237107_, Optional<Component> p_237108_, DataSource p_237109_) {
        return MutableComponent.create(new NbtContents(p_237106_, p_237107_, p_237108_, p_237109_));
    }

    public static MutableComponent score(SelectorPattern p_363804_, String p_362439_) {
        return MutableComponent.create(new ScoreContents((Either<SelectorPattern, String>)Either.left((Object)p_363804_), p_362439_));
    }

    public static MutableComponent score(String p_237100_, String p_237101_) {
        return MutableComponent.create(new ScoreContents((Either<SelectorPattern, String>)Either.right((Object)p_237100_), p_237101_));
    }

    public static MutableComponent selector(SelectorPattern p_362718_, Optional<Component> p_237104_) {
        return MutableComponent.create(new SelectorContents(p_362718_, p_237104_));
    }

    public static Component translationArg(Date p_304461_) {
        return Component.literal(p_304461_.toString());
    }

    public static Component translationArg(Message p_304620_) {
        Component component;
        if (p_304620_ instanceof Component) {
            Component component2 = (Component)p_304620_;
            component = component2;
        } else {
            component = Component.literal(p_304620_.getString());
        }
        return component;
    }

    public static Component translationArg(UUID p_304730_) {
        return Component.literal(p_304730_.toString());
    }

    public static Component translationArg(ResourceLocation p_304849_) {
        return Component.literal(p_304849_.toString());
    }

    public static Component translationArg(ChunkPos p_304675_) {
        return Component.literal(p_304675_.toString());
    }

    public static Component translationArg(URI p_352152_) {
        return Component.literal(p_352152_.toString());
    }
}

