/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import io.netty.buffer.ByteBuf;

public class VarLong {
    private static final int MAX_VARLONG_SIZE = 10;
    private static final int DATA_BITS_MASK = 127;
    private static final int CONTINUATION_BIT_MASK = 128;
    private static final int DATA_BITS_PER_BYTE = 7;

    public static int getByteSize(long p_295931_) {
        for (int i = 1; i < 10; ++i) {
            if ((p_295931_ & -1L << i * 7) != 0L) continue;
            return i;
        }
        return 10;
    }

    public static boolean hasContinuationBit(byte p_294159_) {
        return (p_294159_ & 0x80) == 128;
    }

    public static long read(ByteBuf p_294443_) {
        byte b0;
        long i = 0L;
        int j = 0;
        do {
            b0 = p_294443_.readByte();
            i |= (long)(b0 & 0x7F) << j++ * 7;
            if (j <= 10) continue;
            throw new RuntimeException("VarLong too big");
        } while (VarLong.hasContinuationBit(b0));
        return i;
    }

    public static ByteBuf write(ByteBuf p_296144_, long p_295377_) {
        while ((p_295377_ & 0xFFFFFFFFFFFFFF80L) != 0L) {
            p_296144_.writeByte((int)(p_295377_ & 0x7FL) | 0x80);
            p_295377_ >>>= 7;
        }
        p_296144_.writeByte((int)p_295377_);
        return p_296144_;
    }
}

