/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.mojang.datafixers.DataFixUtils;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.HashedPatchMap;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface HashedStack {
    public static final HashedStack EMPTY = new HashedStack(){

        public String toString() {
            return "<empty>";
        }

        @Override
        public boolean matches(ItemStack p_412039_, HashedPatchMap.HashGenerator p_412698_) {
            return p_412039_.isEmpty();
        }
    };
    public static final StreamCodec<RegistryFriendlyByteBuf, HashedStack> STREAM_CODEC = ByteBufCodecs.optional(ActualItem.STREAM_CODEC).map(p_412528_ -> (HashedStack)DataFixUtils.orElse((Optional)p_412528_, (Object)EMPTY), p_412104_ -> {
        Optional<Object> optional;
        if (p_412104_ instanceof ActualItem) {
            ActualItem hashedstack$actualitem = (ActualItem)p_412104_;
            optional = Optional.of(hashedstack$actualitem);
        } else {
            optional = Optional.empty();
        }
        return optional;
    });

    public boolean matches(ItemStack var1, HashedPatchMap.HashGenerator var2);

    public static HashedStack create(ItemStack p_412136_, HashedPatchMap.HashGenerator p_412663_) {
        return p_412136_.isEmpty() ? EMPTY : new ActualItem(p_412136_.getItemHolder(), p_412136_.getCount(), HashedPatchMap.create(p_412136_.getComponentsPatch(), p_412663_));
    }

    public record ActualItem(Holder<Item> item, int count, HashedPatchMap components) implements HashedStack
    {
        public static final StreamCodec<RegistryFriendlyByteBuf, ActualItem> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.holderRegistry(Registries.ITEM), ActualItem::item, ByteBufCodecs.VAR_INT, ActualItem::count, HashedPatchMap.STREAM_CODEC, ActualItem::components, ActualItem::new);

        @Override
        public boolean matches(ItemStack p_412763_, HashedPatchMap.HashGenerator p_412137_) {
            if (this.count != p_412763_.getCount()) {
                return false;
            }
            return !this.item.equals(p_412763_.getItemHolder()) ? false : this.components.matches(p_412763_.getComponentsPatch(), p_412137_);
        }
    }
}

