/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.IOException;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.Tag;

public interface TagType<T extends Tag> {
    public T load(DataInput var1, NbtAccounter var2) throws IOException;

    public StreamTagVisitor.ValueResult parse(DataInput var1, StreamTagVisitor var2, NbtAccounter var3) throws IOException;

    default public void parseRoot(DataInput p_197581_, StreamTagVisitor p_197582_, NbtAccounter p_302373_) throws IOException {
        switch (p_197582_.visitRootEntry(this)) {
            case CONTINUE: {
                this.parse(p_197581_, p_197582_, p_302373_);
            }
            default: {
                break;
            }
            case BREAK: {
                this.skip(p_197581_, p_302373_);
            }
        }
    }

    public void skip(DataInput var1, int var2, NbtAccounter var3) throws IOException;

    public void skip(DataInput var1, NbtAccounter var2) throws IOException;

    public String getName();

    public String getPrettyName();

    public static TagType<EndTag> createInvalid(final int p_129378_) {
        return new TagType<EndTag>(){

            private IOException createException() {
                return new IOException("Invalid tag id: " + p_129378_);
            }

            @Override
            public EndTag load(DataInput p_129387_, NbtAccounter p_129389_) throws IOException {
                throw this.createException();
            }

            @Override
            public StreamTagVisitor.ValueResult parse(DataInput p_197589_, StreamTagVisitor p_197590_, NbtAccounter p_302377_) throws IOException {
                throw this.createException();
            }

            @Override
            public void skip(DataInput p_197586_, int p_197587_, NbtAccounter p_302342_) throws IOException {
                throw this.createException();
            }

            @Override
            public void skip(DataInput p_197584_, NbtAccounter p_302343_) throws IOException {
                throw this.createException();
            }

            @Override
            public String getName() {
                return "INVALID[" + p_129378_ + "]";
            }

            @Override
            public String getPrettyName() {
                return "UNKNOWN_" + p_129378_;
            }
        };
    }

    public static interface VariableSize<T extends Tag>
    extends TagType<T> {
        @Override
        default public void skip(DataInput p_197600_, int p_197601_, NbtAccounter p_302386_) throws IOException {
            for (int i = 0; i < p_197601_; ++i) {
                this.skip(p_197600_, p_302386_);
            }
        }
    }

    public static interface StaticSize<T extends Tag>
    extends TagType<T> {
        @Override
        default public void skip(DataInput p_197595_, NbtAccounter p_302323_) throws IOException {
            p_197595_.skipBytes(this.size());
        }

        @Override
        default public void skip(DataInput p_197597_, int p_197598_, NbtAccounter p_302393_) throws IOException {
            p_197597_.skipBytes(this.size() * p_197598_);
        }

        public int size();
    }
}

