/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.UnsignedBytes;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JavaOps;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.chars.CharList;
import java.lang.runtime.SwitchBootstraps;
import java.nio.ByteBuffer;
import java.util.HexFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import javax.annotation.Nullable;
import net.minecraft.nbt.SnbtOperations;
import net.minecraft.network.chat.Component;
import net.minecraft.util.parsing.packrat.Atom;
import net.minecraft.util.parsing.packrat.DelayedException;
import net.minecraft.util.parsing.packrat.Dictionary;
import net.minecraft.util.parsing.packrat.NamedRule;
import net.minecraft.util.parsing.packrat.ParseState;
import net.minecraft.util.parsing.packrat.Scope;
import net.minecraft.util.parsing.packrat.Term;
import net.minecraft.util.parsing.packrat.commands.Grammar;
import net.minecraft.util.parsing.packrat.commands.GreedyPatternParseRule;
import net.minecraft.util.parsing.packrat.commands.GreedyPredicateParseRule;
import net.minecraft.util.parsing.packrat.commands.NumberRunParseRule;
import net.minecraft.util.parsing.packrat.commands.StringReaderTerms;
import net.minecraft.util.parsing.packrat.commands.UnquotedStringParseRule;

public class SnbtGrammar {
    private static final DynamicCommandExceptionType ERROR_NUMBER_PARSE_FAILURE = new DynamicCommandExceptionType(p_410234_ -> Component.translatableEscape("snbt.parser.number_parse_failure", p_410234_));
    static final DynamicCommandExceptionType ERROR_EXPECTED_HEX_ESCAPE = new DynamicCommandExceptionType(p_410336_ -> Component.translatableEscape("snbt.parser.expected_hex_escape", p_410336_));
    private static final DynamicCommandExceptionType ERROR_INVALID_CODEPOINT = new DynamicCommandExceptionType(p_411037_ -> Component.translatableEscape("snbt.parser.invalid_codepoint", p_411037_));
    private static final DynamicCommandExceptionType ERROR_NO_SUCH_OPERATION = new DynamicCommandExceptionType(p_411036_ -> Component.translatableEscape("snbt.parser.no_such_operation", p_411036_));
    static final DelayedException<CommandSyntaxException> ERROR_EXPECTED_INTEGER_TYPE = DelayedException.create(new SimpleCommandExceptionType((Message)Component.translatable("snbt.parser.expected_integer_type")));
    private static final DelayedException<CommandSyntaxException> ERROR_EXPECTED_FLOAT_TYPE = DelayedException.create(new SimpleCommandExceptionType((Message)Component.translatable("snbt.parser.expected_float_type")));
    static final DelayedException<CommandSyntaxException> ERROR_EXPECTED_NON_NEGATIVE_NUMBER = DelayedException.create(new SimpleCommandExceptionType((Message)Component.translatable("snbt.parser.expected_non_negative_number")));
    private static final DelayedException<CommandSyntaxException> ERROR_INVALID_CHARACTER_NAME = DelayedException.create(new SimpleCommandExceptionType((Message)Component.translatable("snbt.parser.invalid_character_name")));
    static final DelayedException<CommandSyntaxException> ERROR_INVALID_ARRAY_ELEMENT_TYPE = DelayedException.create(new SimpleCommandExceptionType((Message)Component.translatable("snbt.parser.invalid_array_element_type")));
    private static final DelayedException<CommandSyntaxException> ERROR_INVALID_UNQUOTED_START = DelayedException.create(new SimpleCommandExceptionType((Message)Component.translatable("snbt.parser.invalid_unquoted_start")));
    private static final DelayedException<CommandSyntaxException> ERROR_EXPECTED_UNQUOTED_STRING = DelayedException.create(new SimpleCommandExceptionType((Message)Component.translatable("snbt.parser.expected_unquoted_string")));
    private static final DelayedException<CommandSyntaxException> ERROR_INVALID_STRING_CONTENTS = DelayedException.create(new SimpleCommandExceptionType((Message)Component.translatable("snbt.parser.invalid_string_contents")));
    private static final DelayedException<CommandSyntaxException> ERROR_EXPECTED_BINARY_NUMERAL = DelayedException.create(new SimpleCommandExceptionType((Message)Component.translatable("snbt.parser.expected_binary_numeral")));
    private static final DelayedException<CommandSyntaxException> ERROR_UNDESCORE_NOT_ALLOWED = DelayedException.create(new SimpleCommandExceptionType((Message)Component.translatable("snbt.parser.underscore_not_allowed")));
    private static final DelayedException<CommandSyntaxException> ERROR_EXPECTED_DECIMAL_NUMERAL = DelayedException.create(new SimpleCommandExceptionType((Message)Component.translatable("snbt.parser.expected_decimal_numeral")));
    private static final DelayedException<CommandSyntaxException> ERROR_EXPECTED_HEX_NUMERAL = DelayedException.create(new SimpleCommandExceptionType((Message)Component.translatable("snbt.parser.expected_hex_numeral")));
    private static final DelayedException<CommandSyntaxException> ERROR_EMPTY_KEY = DelayedException.create(new SimpleCommandExceptionType((Message)Component.translatable("snbt.parser.empty_key")));
    private static final DelayedException<CommandSyntaxException> ERROR_LEADING_ZERO_NOT_ALLOWED = DelayedException.create(new SimpleCommandExceptionType((Message)Component.translatable("snbt.parser.leading_zero_not_allowed")));
    private static final DelayedException<CommandSyntaxException> ERROR_INFINITY_NOT_ALLOWED = DelayedException.create(new SimpleCommandExceptionType((Message)Component.translatable("snbt.parser.infinity_not_allowed")));
    private static final HexFormat HEX_ESCAPE = HexFormat.of().withUpperCase();
    private static final NumberRunParseRule BINARY_NUMERAL = new NumberRunParseRule((DelayedException)ERROR_EXPECTED_BINARY_NUMERAL, (DelayedException)ERROR_UNDESCORE_NOT_ALLOWED){

        @Override
        protected boolean isAccepted(char p_409763_) {
            return switch (p_409763_) {
                case '0', '1', '_' -> true;
                default -> false;
            };
        }
    };
    private static final NumberRunParseRule DECIMAL_NUMERAL = new NumberRunParseRule((DelayedException)ERROR_EXPECTED_DECIMAL_NUMERAL, (DelayedException)ERROR_UNDESCORE_NOT_ALLOWED){

        @Override
        protected boolean isAccepted(char p_410507_) {
            return switch (p_410507_) {
                case '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '_' -> true;
                default -> false;
            };
        }
    };
    private static final NumberRunParseRule HEX_NUMERAL = new NumberRunParseRule((DelayedException)ERROR_EXPECTED_HEX_NUMERAL, (DelayedException)ERROR_UNDESCORE_NOT_ALLOWED){

        @Override
        protected boolean isAccepted(char p_410332_) {
            return switch (p_410332_) {
                case '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', '_', 'a', 'b', 'c', 'd', 'e', 'f' -> true;
                default -> false;
            };
        }
    };
    private static final GreedyPredicateParseRule PLAIN_STRING_CHUNK = new GreedyPredicateParseRule(1, (DelayedException)ERROR_INVALID_STRING_CONTENTS){

        @Override
        protected boolean isAccepted(char p_410102_) {
            return switch (p_410102_) {
                case '\"', '\'', '\\' -> false;
                default -> true;
            };
        }
    };
    private static final StringReaderTerms.TerminalCharacters NUMBER_LOOKEAHEAD = new StringReaderTerms.TerminalCharacters(CharList.of()){

        @Override
        protected boolean isAccepted(char p_410066_) {
            return SnbtGrammar.canStartNumber(p_410066_);
        }
    };
    private static final Pattern UNICODE_NAME = Pattern.compile("[-a-zA-Z0-9 ]+");

    static DelayedException<CommandSyntaxException> createNumberParseError(NumberFormatException p_410491_) {
        return DelayedException.create(ERROR_NUMBER_PARSE_FAILURE, p_410491_.getMessage());
    }

    @Nullable
    public static String escapeControlCharacters(char p_410776_) {
        return switch (p_410776_) {
            case '\b' -> "b";
            case '\t' -> "t";
            case '\n' -> "n";
            default -> {
                if (p_410776_ < ' ') {
                    yield "x" + HEX_ESCAPE.toHexDigits((byte)p_410776_);
                }
                yield null;
            }
            case '\f' -> "f";
            case '\r' -> "r";
        };
    }

    private static boolean isAllowedToStartUnquotedString(char p_410198_) {
        return !SnbtGrammar.canStartNumber(p_410198_);
    }

    static boolean canStartNumber(char p_410692_) {
        return switch (p_410692_) {
            case '+', '-', '.', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9' -> true;
            default -> false;
        };
    }

    static boolean needsUnderscoreRemoval(String p_410362_) {
        return p_410362_.indexOf(95) != -1;
    }

    private static void cleanAndAppend(StringBuilder p_409818_, String p_410616_) {
        SnbtGrammar.cleanAndAppend(p_409818_, p_410616_, SnbtGrammar.needsUnderscoreRemoval(p_410616_));
    }

    static void cleanAndAppend(StringBuilder p_410205_, String p_410044_, boolean p_410535_) {
        if (p_410535_) {
            for (char c0 : p_410044_.toCharArray()) {
                if (c0 == '_') continue;
                p_410205_.append(c0);
            }
        } else {
            p_410205_.append(p_410044_);
        }
    }

    static short parseUnsignedShort(String p_410720_, int p_409913_) {
        int i = Integer.parseInt(p_410720_, p_409913_);
        if (i >> 16 == 0) {
            return (short)i;
        }
        throw new NumberFormatException("out of range: " + i);
    }

    @Nullable
    private static <T> T createFloat(DynamicOps<T> p_410880_, Sign p_409652_, @Nullable String p_410345_, @Nullable String p_410114_, @Nullable Signed<String> p_409756_, @Nullable TypeSuffix p_410824_, ParseState<?> p_410041_) {
        StringBuilder stringbuilder = new StringBuilder();
        p_409652_.append(stringbuilder);
        if (p_410345_ != null) {
            SnbtGrammar.cleanAndAppend(stringbuilder, p_410345_);
        }
        if (p_410114_ != null) {
            stringbuilder.append('.');
            SnbtGrammar.cleanAndAppend(stringbuilder, p_410114_);
        }
        if (p_409756_ != null) {
            stringbuilder.append('e');
            p_409756_.sign().append(stringbuilder);
            SnbtGrammar.cleanAndAppend(stringbuilder, (String)p_409756_.value);
        }
        try {
            String s = stringbuilder.toString();
            TypeSuffix typeSuffix = p_410824_;
            int n = 0;
            return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"FLOAT", "DOUBLE"}, (TypeSuffix)typeSuffix, n)) {
                case -1 -> SnbtGrammar.convertDouble(p_410880_, p_410041_, s);
                case 0 -> SnbtGrammar.convertFloat(p_410880_, p_410041_, s);
                case 1 -> SnbtGrammar.convertDouble(p_410880_, p_410041_, s);
                default -> {
                    p_410041_.errorCollector().store(p_410041_.mark(), ERROR_EXPECTED_FLOAT_TYPE);
                    yield null;
                }
            };
        }
        catch (NumberFormatException numberformatexception) {
            p_410041_.errorCollector().store(p_410041_.mark(), SnbtGrammar.createNumberParseError(numberformatexception));
            return null;
        }
    }

    @Nullable
    private static <T> T convertFloat(DynamicOps<T> p_411050_, ParseState<?> p_411078_, String p_411046_) {
        float f = Float.parseFloat(p_411046_);
        if (!Float.isFinite(f)) {
            p_411078_.errorCollector().store(p_411078_.mark(), ERROR_INFINITY_NOT_ALLOWED);
            return null;
        }
        return (T)p_411050_.createFloat(f);
    }

    @Nullable
    private static <T> T convertDouble(DynamicOps<T> p_411053_, ParseState<?> p_411063_, String p_411059_) {
        double d0 = Double.parseDouble(p_411059_);
        if (!Double.isFinite(d0)) {
            p_411063_.errorCollector().store(p_411063_.mark(), ERROR_INFINITY_NOT_ALLOWED);
            return null;
        }
        return (T)p_411053_.createDouble(d0);
    }

    private static String joinList(List<String> p_409729_) {
        return switch (p_409729_.size()) {
            case 0 -> "";
            case 1 -> p_409729_.getFirst();
            default -> String.join((CharSequence)"", p_409729_);
        };
    }

    public static <T> Grammar<T> createParser(DynamicOps<T> p_409979_) {
        Object t = p_409979_.createBoolean(true);
        Object t1 = p_409979_.createBoolean(false);
        Object t2 = p_409979_.emptyMap();
        Object t3 = p_409979_.emptyList();
        Dictionary<StringReader> dictionary = new Dictionary<StringReader>();
        Atom atom = Atom.of("sign");
        dictionary.put(atom, Term.alternative(Term.sequence(StringReaderTerms.character('+'), Term.marker(atom, Sign.PLUS)), Term.sequence(StringReaderTerms.character('-'), Term.marker(atom, Sign.MINUS))), p_410526_ -> (Sign)((Object)((Object)p_410526_.getOrThrow(atom))));
        Atom atom1 = Atom.of("integer_suffix");
        dictionary.put(atom1, Term.alternative(Term.sequence(StringReaderTerms.characters('u', 'U'), Term.alternative(Term.sequence(StringReaderTerms.characters('b', 'B'), Term.marker(atom1, new IntegerSuffix(SignedPrefix.UNSIGNED, TypeSuffix.BYTE))), Term.sequence(StringReaderTerms.characters('s', 'S'), Term.marker(atom1, new IntegerSuffix(SignedPrefix.UNSIGNED, TypeSuffix.SHORT))), Term.sequence(StringReaderTerms.characters('i', 'I'), Term.marker(atom1, new IntegerSuffix(SignedPrefix.UNSIGNED, TypeSuffix.INT))), Term.sequence(StringReaderTerms.characters('l', 'L'), Term.marker(atom1, new IntegerSuffix(SignedPrefix.UNSIGNED, TypeSuffix.LONG))))), Term.sequence(StringReaderTerms.characters('s', 'S'), Term.alternative(Term.sequence(StringReaderTerms.characters('b', 'B'), Term.marker(atom1, new IntegerSuffix(SignedPrefix.SIGNED, TypeSuffix.BYTE))), Term.sequence(StringReaderTerms.characters('s', 'S'), Term.marker(atom1, new IntegerSuffix(SignedPrefix.SIGNED, TypeSuffix.SHORT))), Term.sequence(StringReaderTerms.characters('i', 'I'), Term.marker(atom1, new IntegerSuffix(SignedPrefix.SIGNED, TypeSuffix.INT))), Term.sequence(StringReaderTerms.characters('l', 'L'), Term.marker(atom1, new IntegerSuffix(SignedPrefix.SIGNED, TypeSuffix.LONG))))), Term.sequence(StringReaderTerms.characters('b', 'B'), Term.marker(atom1, new IntegerSuffix(null, TypeSuffix.BYTE))), Term.sequence(StringReaderTerms.characters('s', 'S'), Term.marker(atom1, new IntegerSuffix(null, TypeSuffix.SHORT))), Term.sequence(StringReaderTerms.characters('i', 'I'), Term.marker(atom1, new IntegerSuffix(null, TypeSuffix.INT))), Term.sequence(StringReaderTerms.characters('l', 'L'), Term.marker(atom1, new IntegerSuffix(null, TypeSuffix.LONG)))), p_409993_ -> (IntegerSuffix)p_409993_.getOrThrow(atom1));
        Atom atom2 = Atom.of("binary_numeral");
        dictionary.put(atom2, BINARY_NUMERAL);
        Atom atom3 = Atom.of("decimal_numeral");
        dictionary.put(atom3, DECIMAL_NUMERAL);
        Atom atom4 = Atom.of("hex_numeral");
        dictionary.put(atom4, HEX_NUMERAL);
        Atom atom5 = Atom.of("integer_literal");
        NamedRule namedrule = dictionary.put(atom5, Term.sequence(Term.optional(dictionary.named(atom)), Term.alternative(Term.sequence(StringReaderTerms.character('0'), Term.cut(), Term.alternative(Term.sequence(StringReaderTerms.characters('x', 'X'), Term.cut(), dictionary.named(atom4)), Term.sequence(StringReaderTerms.characters('b', 'B'), dictionary.named(atom2)), Term.sequence(dictionary.named(atom3), Term.cut(), Term.fail(ERROR_LEADING_ZERO_NOT_ALLOWED)), Term.marker(atom3, "0"))), dictionary.named(atom3)), Term.optional(dictionary.named(atom1))), p_409716_ -> {
            IntegerSuffix snbtgrammar$integersuffix = p_409716_.getOrDefault(atom1, IntegerSuffix.EMPTY);
            Sign snbtgrammar$sign = p_409716_.getOrDefault(atom, Sign.PLUS);
            String s = (String)p_409716_.get(atom3);
            if (s != null) {
                return new IntegerLiteral(snbtgrammar$sign, Base.DECIMAL, s, snbtgrammar$integersuffix);
            }
            String s1 = (String)p_409716_.get(atom4);
            if (s1 != null) {
                return new IntegerLiteral(snbtgrammar$sign, Base.HEX, s1, snbtgrammar$integersuffix);
            }
            String s2 = (String)p_409716_.getOrThrow(atom2);
            return new IntegerLiteral(snbtgrammar$sign, Base.BINARY, s2, snbtgrammar$integersuffix);
        });
        Atom atom6 = Atom.of("float_type_suffix");
        dictionary.put(atom6, Term.alternative(Term.sequence(StringReaderTerms.characters('f', 'F'), Term.marker(atom6, TypeSuffix.FLOAT)), Term.sequence(StringReaderTerms.characters('d', 'D'), Term.marker(atom6, TypeSuffix.DOUBLE))), p_410191_ -> (TypeSuffix)((Object)((Object)p_410191_.getOrThrow(atom6))));
        Atom atom7 = Atom.of("float_exponent_part");
        dictionary.put(atom7, Term.sequence(StringReaderTerms.characters('e', 'E'), Term.optional(dictionary.named(atom)), dictionary.named(atom3)), p_410211_ -> new Signed<String>(p_410211_.getOrDefault(atom, Sign.PLUS), (String)p_410211_.getOrThrow(atom3)));
        Atom atom8 = Atom.of("float_whole_part");
        Atom atom9 = Atom.of("float_fraction_part");
        Atom atom10 = Atom.of("float_literal");
        dictionary.putComplex(atom10, Term.sequence(Term.optional(dictionary.named(atom)), Term.alternative(Term.sequence(dictionary.namedWithAlias(atom3, atom8), StringReaderTerms.character('.'), Term.cut(), Term.optional(dictionary.namedWithAlias(atom3, atom9)), Term.optional(dictionary.named(atom7)), Term.optional(dictionary.named(atom6))), Term.sequence(StringReaderTerms.character('.'), Term.cut(), dictionary.namedWithAlias(atom3, atom9), Term.optional(dictionary.named(atom7)), Term.optional(dictionary.named(atom6))), Term.sequence(dictionary.namedWithAlias(atom3, atom8), dictionary.named(atom7), Term.cut(), Term.optional(dictionary.named(atom6))), Term.sequence(dictionary.namedWithAlias(atom3, atom8), Term.optional(dictionary.named(atom7)), dictionary.named(atom6)))), p_410250_ -> {
            Scope scope = p_410250_.scope();
            Sign snbtgrammar$sign = scope.getOrDefault(atom, Sign.PLUS);
            String s = (String)scope.get(atom8);
            String s1 = (String)scope.get(atom9);
            Signed signed = (Signed)scope.get(atom7);
            TypeSuffix snbtgrammar$typesuffix = (TypeSuffix)((Object)((Object)scope.get(atom6)));
            return SnbtGrammar.createFloat(p_409979_, snbtgrammar$sign, s, s1, signed, snbtgrammar$typesuffix, p_410250_);
        });
        Atom atom11 = Atom.of("string_hex_2");
        dictionary.put(atom11, new SimpleHexLiteralParseRule(2));
        Atom atom12 = Atom.of("string_hex_4");
        dictionary.put(atom12, new SimpleHexLiteralParseRule(4));
        Atom atom13 = Atom.of("string_hex_8");
        dictionary.put(atom13, new SimpleHexLiteralParseRule(8));
        Atom atom14 = Atom.of("string_unicode_name");
        dictionary.put(atom14, new GreedyPatternParseRule(UNICODE_NAME, ERROR_INVALID_CHARACTER_NAME));
        Atom atom15 = Atom.of("string_escape_sequence");
        dictionary.putComplex(atom15, Term.alternative(Term.sequence(StringReaderTerms.character('b'), Term.marker(atom15, "\b")), Term.sequence(StringReaderTerms.character('s'), Term.marker(atom15, " ")), Term.sequence(StringReaderTerms.character('t'), Term.marker(atom15, "\t")), Term.sequence(StringReaderTerms.character('n'), Term.marker(atom15, "\n")), Term.sequence(StringReaderTerms.character('f'), Term.marker(atom15, "\f")), Term.sequence(StringReaderTerms.character('r'), Term.marker(atom15, "\r")), Term.sequence(StringReaderTerms.character('\\'), Term.marker(atom15, "\\")), Term.sequence(StringReaderTerms.character('\''), Term.marker(atom15, "'")), Term.sequence(StringReaderTerms.character('\"'), Term.marker(atom15, "\"")), Term.sequence(StringReaderTerms.character('x'), dictionary.named(atom11)), Term.sequence(StringReaderTerms.character('u'), dictionary.named(atom12)), Term.sequence(StringReaderTerms.character('U'), dictionary.named(atom13)), Term.sequence(StringReaderTerms.character('N'), StringReaderTerms.character('{'), dictionary.named(atom14), StringReaderTerms.character('}'))), p_411035_ -> {
            int i;
            Scope scope = p_411035_.scope();
            String s = (String)scope.getAny(atom15);
            if (s != null) {
                return s;
            }
            String s1 = (String)scope.getAny(atom11, atom12, atom13);
            if (s1 != null) {
                int j = HexFormat.fromHexDigits(s1);
                if (!Character.isValidCodePoint(j)) {
                    p_411035_.errorCollector().store(p_411035_.mark(), DelayedException.create(ERROR_INVALID_CODEPOINT, String.format(Locale.ROOT, "U+%08X", j)));
                    return null;
                }
                return Character.toString(j);
            }
            String s2 = (String)scope.getOrThrow(atom14);
            try {
                i = Character.codePointOf(s2);
            }
            catch (IllegalArgumentException illegalargumentexception) {
                p_411035_.errorCollector().store(p_411035_.mark(), ERROR_INVALID_CHARACTER_NAME);
                return null;
            }
            return Character.toString(i);
        });
        Atom atom16 = Atom.of("string_plain_contents");
        dictionary.put(atom16, PLAIN_STRING_CHUNK);
        Atom atom17 = Atom.of("string_chunks");
        Atom atom18 = Atom.of("string_contents");
        Atom atom19 = Atom.of("single_quoted_string_chunk");
        NamedRule namedrule1 = dictionary.put(atom19, Term.alternative(dictionary.namedWithAlias(atom16, atom18), Term.sequence(StringReaderTerms.character('\\'), dictionary.namedWithAlias(atom15, atom18)), Term.sequence(StringReaderTerms.character('\"'), Term.marker(atom18, "\""))), p_409868_ -> (String)p_409868_.getOrThrow(atom18));
        Atom atom20 = Atom.of("single_quoted_string_contents");
        dictionary.put(atom20, Term.repeated(namedrule1, atom17), p_410457_ -> SnbtGrammar.joinList((List)p_410457_.getOrThrow(atom17)));
        Atom atom21 = Atom.of("double_quoted_string_chunk");
        NamedRule namedrule2 = dictionary.put(atom21, Term.alternative(dictionary.namedWithAlias(atom16, atom18), Term.sequence(StringReaderTerms.character('\\'), dictionary.namedWithAlias(atom15, atom18)), Term.sequence(StringReaderTerms.character('\''), Term.marker(atom18, "'"))), p_410420_ -> (String)p_410420_.getOrThrow(atom18));
        Atom atom22 = Atom.of("double_quoted_string_contents");
        dictionary.put(atom22, Term.repeated(namedrule2, atom17), p_409731_ -> SnbtGrammar.joinList((List)p_409731_.getOrThrow(atom17)));
        Atom atom23 = Atom.of("quoted_string_literal");
        dictionary.put(atom23, Term.alternative(Term.sequence(StringReaderTerms.character('\"'), Term.cut(), Term.optional(dictionary.namedWithAlias(atom22, atom18)), StringReaderTerms.character('\"')), Term.sequence(StringReaderTerms.character('\''), Term.optional(dictionary.namedWithAlias(atom20, atom18)), StringReaderTerms.character('\''))), p_410273_ -> (String)p_410273_.getOrThrow(atom18));
        Atom atom24 = Atom.of("unquoted_string");
        dictionary.put(atom24, new UnquotedStringParseRule(1, ERROR_EXPECTED_UNQUOTED_STRING));
        Atom atom25 = Atom.of("literal");
        Atom atom26 = Atom.of("arguments");
        dictionary.put(atom26, Term.repeatedWithTrailingSeparator(dictionary.forward(atom25), atom26, StringReaderTerms.character(',')), p_410707_ -> (List)p_410707_.getOrThrow(atom26));
        Atom atom27 = Atom.of("unquoted_string_or_builtin");
        dictionary.putComplex(atom27, Term.sequence(dictionary.named(atom24), Term.optional(Term.sequence(StringReaderTerms.character('('), dictionary.named(atom26), StringReaderTerms.character(')')))), p_411043_ -> {
            Scope scope = p_411043_.scope();
            String s = (String)scope.getOrThrow(atom24);
            if (!s.isEmpty() && SnbtGrammar.isAllowedToStartUnquotedString(s.charAt(0))) {
                List list = (List)scope.get(atom26);
                if (list != null) {
                    SnbtOperations.BuiltinKey snbtoperations$builtinkey = new SnbtOperations.BuiltinKey(s, list.size());
                    SnbtOperations.BuiltinOperation snbtoperations$builtinoperation = SnbtOperations.BUILTIN_OPERATIONS.get(snbtoperations$builtinkey);
                    if (snbtoperations$builtinoperation != null) {
                        return snbtoperations$builtinoperation.run(p_409979_, list, p_411043_);
                    }
                    p_411043_.errorCollector().store(p_411043_.mark(), DelayedException.create(ERROR_NO_SUCH_OPERATION, snbtoperations$builtinkey.toString()));
                    return null;
                }
                if (s.equalsIgnoreCase("true")) {
                    return t;
                }
                return s.equalsIgnoreCase("false") ? t1 : p_409979_.createString(s);
            }
            p_411043_.errorCollector().store(p_411043_.mark(), SnbtOperations.BUILTIN_IDS, ERROR_INVALID_UNQUOTED_START);
            return null;
        });
        Atom atom28 = Atom.of("map_key");
        dictionary.put(atom28, Term.alternative(dictionary.named(atom23), dictionary.named(atom24)), p_410385_ -> (String)p_410385_.getAnyOrThrow(atom23, atom24));
        Atom atom29 = Atom.of("map_entry");
        NamedRule namedrule3 = dictionary.putComplex(atom29, Term.sequence(dictionary.named(atom28), StringReaderTerms.character(':'), dictionary.named(atom25)), p_410737_ -> {
            Scope scope = p_410737_.scope();
            String s = (String)scope.getOrThrow(atom28);
            if (s.isEmpty()) {
                p_410737_.errorCollector().store(p_410737_.mark(), ERROR_EMPTY_KEY);
                return null;
            }
            Object t4 = scope.getOrThrow(atom25);
            return Map.entry(s, t4);
        });
        Atom atom30 = Atom.of("map_entries");
        dictionary.put(atom30, Term.repeatedWithTrailingSeparator(namedrule3, atom30, StringReaderTerms.character(',')), p_410706_ -> (List)p_410706_.getOrThrow(atom30));
        Atom atom31 = Atom.of("map_literal");
        dictionary.put(atom31, Term.sequence(StringReaderTerms.character('{'), dictionary.named(atom30), StringReaderTerms.character('}')), p_409658_ -> {
            List list = (List)p_409658_.getOrThrow(atom30);
            if (list.isEmpty()) {
                return t2;
            }
            ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)list.size());
            for (Map.Entry entry : list) {
                builder.put(p_409979_.createString((String)entry.getKey()), entry.getValue());
            }
            return p_409979_.createMap((Map)builder.buildKeepingLast());
        });
        Atom atom32 = Atom.of("list_entries");
        dictionary.put(atom32, Term.repeatedWithTrailingSeparator(dictionary.forward(atom25), atom32, StringReaderTerms.character(',')), p_410645_ -> (List)p_410645_.getOrThrow(atom32));
        Atom atom33 = Atom.of("array_prefix");
        dictionary.put(atom33, Term.alternative(Term.sequence(StringReaderTerms.character('B'), Term.marker(atom33, ArrayPrefix.BYTE)), Term.sequence(StringReaderTerms.character('L'), Term.marker(atom33, ArrayPrefix.LONG)), Term.sequence(StringReaderTerms.character('I'), Term.marker(atom33, ArrayPrefix.INT))), p_409638_ -> (ArrayPrefix)((Object)((Object)p_409638_.getOrThrow(atom33))));
        Atom atom34 = Atom.of("int_array_entries");
        dictionary.put(atom34, Term.repeatedWithTrailingSeparator(namedrule, atom34, StringReaderTerms.character(',')), p_411029_ -> (List)p_411029_.getOrThrow(atom34));
        Atom atom35 = Atom.of("list_literal");
        dictionary.putComplex(atom35, Term.sequence(StringReaderTerms.character('['), Term.alternative(Term.sequence(dictionary.named(atom33), StringReaderTerms.character(';'), dictionary.named(atom34)), dictionary.named(atom32)), StringReaderTerms.character(']')), p_410065_ -> {
            Scope scope = p_410065_.scope();
            ArrayPrefix snbtgrammar$arrayprefix = (ArrayPrefix)((Object)((Object)scope.get(atom33)));
            if (snbtgrammar$arrayprefix != null) {
                List list1 = (List)scope.getOrThrow(atom34);
                return list1.isEmpty() ? snbtgrammar$arrayprefix.create(p_409979_) : snbtgrammar$arrayprefix.create(p_409979_, list1, p_410065_);
            }
            List list = (List)scope.getOrThrow(atom32);
            return list.isEmpty() ? t3 : p_409979_.createList(list.stream());
        });
        NamedRule namedrule4 = dictionary.putComplex(atom25, Term.alternative(Term.sequence(Term.positiveLookahead(NUMBER_LOOKEAHEAD), Term.alternative(dictionary.namedWithAlias(atom10, atom25), dictionary.named(atom5))), Term.sequence(Term.positiveLookahead(StringReaderTerms.characters('\"', '\'')), Term.cut(), dictionary.named(atom23)), Term.sequence(Term.positiveLookahead(StringReaderTerms.character('{')), Term.cut(), dictionary.namedWithAlias(atom31, atom25)), Term.sequence(Term.positiveLookahead(StringReaderTerms.character('[')), Term.cut(), dictionary.namedWithAlias(atom35, atom25)), dictionary.namedWithAlias(atom27, atom25)), p_410054_ -> {
            Scope scope = p_410054_.scope();
            String s = (String)scope.get(atom23);
            if (s != null) {
                return p_409979_.createString(s);
            }
            IntegerLiteral snbtgrammar$integerliteral = (IntegerLiteral)scope.get(atom5);
            return snbtgrammar$integerliteral != null ? snbtgrammar$integerliteral.create(p_409979_, p_410054_) : scope.getOrThrow(atom25);
        });
        return new Grammar<Object>(dictionary, namedrule4);
    }

    static enum Sign {
        PLUS,
        MINUS;


        public void append(StringBuilder p_410045_) {
            if (this == MINUS) {
                p_410045_.append("-");
            }
        }
    }

    record Signed<T>(Sign sign, T value) {
    }

    static enum TypeSuffix {
        FLOAT,
        DOUBLE,
        BYTE,
        SHORT,
        INT,
        LONG;

    }

    record IntegerSuffix(@Nullable SignedPrefix signed, @Nullable TypeSuffix type) {
        public static final IntegerSuffix EMPTY = new IntegerSuffix(null, null);
    }

    static enum SignedPrefix {
        SIGNED,
        UNSIGNED;

    }

    static class SimpleHexLiteralParseRule
    extends GreedyPredicateParseRule {
        public SimpleHexLiteralParseRule(int p_410732_) {
            super(p_410732_, p_410732_, DelayedException.create(ERROR_EXPECTED_HEX_ESCAPE, String.valueOf(p_410732_)));
        }

        @Override
        protected boolean isAccepted(char p_410209_) {
            return switch (p_410209_) {
                case '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'a', 'b', 'c', 'd', 'e', 'f' -> true;
                default -> false;
            };
        }
    }

    static enum ArrayPrefix {
        BYTE(TypeSuffix.BYTE, new TypeSuffix[0]){
            private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.wrap(new byte[0]);

            @Override
            public <T> T create(DynamicOps<T> p_410524_) {
                return (T)p_410524_.createByteList(EMPTY_BUFFER);
            }

            @Override
            @Nullable
            public <T> T create(DynamicOps<T> p_410319_, List<IntegerLiteral> p_410656_, ParseState<?> p_410578_) {
                ByteArrayList bytelist = new ByteArrayList();
                for (IntegerLiteral snbtgrammar$integerliteral : p_410656_) {
                    Number number = this.buildNumber(snbtgrammar$integerliteral, p_410578_);
                    if (number == null) {
                        return null;
                    }
                    bytelist.add(number.byteValue());
                }
                return (T)p_410319_.createByteList(ByteBuffer.wrap(bytelist.toByteArray()));
            }
        }
        ,
        INT(TypeSuffix.INT, new TypeSuffix[]{TypeSuffix.BYTE, TypeSuffix.SHORT}){

            @Override
            public <T> T create(DynamicOps<T> p_409691_) {
                return (T)p_409691_.createIntList(IntStream.empty());
            }

            @Override
            @Nullable
            public <T> T create(DynamicOps<T> p_409890_, List<IntegerLiteral> p_410031_, ParseState<?> p_409844_) {
                IntStream.Builder builder = IntStream.builder();
                for (IntegerLiteral snbtgrammar$integerliteral : p_410031_) {
                    Number number = this.buildNumber(snbtgrammar$integerliteral, p_409844_);
                    if (number == null) {
                        return null;
                    }
                    builder.add(number.intValue());
                }
                return (T)p_409890_.createIntList(builder.build());
            }
        }
        ,
        LONG(TypeSuffix.LONG, new TypeSuffix[]{TypeSuffix.BYTE, TypeSuffix.SHORT, TypeSuffix.INT}){

            @Override
            public <T> T create(DynamicOps<T> p_410179_) {
                return (T)p_410179_.createLongList(LongStream.empty());
            }

            @Override
            @Nullable
            public <T> T create(DynamicOps<T> p_410327_, List<IntegerLiteral> p_409793_, ParseState<?> p_410839_) {
                LongStream.Builder builder = LongStream.builder();
                for (IntegerLiteral snbtgrammar$integerliteral : p_409793_) {
                    Number number = this.buildNumber(snbtgrammar$integerliteral, p_410839_);
                    if (number == null) {
                        return null;
                    }
                    builder.add(number.longValue());
                }
                return (T)p_410327_.createLongList(builder.build());
            }
        };

        private final TypeSuffix defaultType;
        private final Set<TypeSuffix> additionalTypes;

        private ArrayPrefix(TypeSuffix p_410014_, TypeSuffix ... p_410215_) {
            this.additionalTypes = Set.of(p_410215_);
            this.defaultType = p_410014_;
        }

        public boolean isAllowed(TypeSuffix p_410024_) {
            return p_410024_ == this.defaultType || this.additionalTypes.contains((Object)p_410024_);
        }

        public abstract <T> T create(DynamicOps<T> var1);

        @Nullable
        public abstract <T> T create(DynamicOps<T> var1, List<IntegerLiteral> var2, ParseState<?> var3);

        @Nullable
        protected Number buildNumber(IntegerLiteral p_410128_, ParseState<?> p_410405_) {
            TypeSuffix snbtgrammar$typesuffix = this.computeType(p_410128_.suffix);
            if (snbtgrammar$typesuffix == null) {
                p_410405_.errorCollector().store(p_410405_.mark(), ERROR_INVALID_ARRAY_ELEMENT_TYPE);
                return null;
            }
            return (Number)p_410128_.create(JavaOps.INSTANCE, snbtgrammar$typesuffix, p_410405_);
        }

        @Nullable
        private TypeSuffix computeType(IntegerSuffix p_409627_) {
            TypeSuffix snbtgrammar$typesuffix = p_409627_.type();
            if (snbtgrammar$typesuffix == null) {
                return this.defaultType;
            }
            return !this.isAllowed(snbtgrammar$typesuffix) ? null : snbtgrammar$typesuffix;
        }
    }

    record IntegerLiteral(Sign sign, Base base, String digits, IntegerSuffix suffix) {
        private SignedPrefix signedOrDefault() {
            if (this.suffix.signed != null) {
                return this.suffix.signed;
            }
            return switch (this.base.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0, 2 -> SignedPrefix.UNSIGNED;
                case 1 -> SignedPrefix.SIGNED;
            };
        }

        private String cleanupDigits(Sign p_409828_) {
            boolean flag = SnbtGrammar.needsUnderscoreRemoval(this.digits);
            if (p_409828_ != Sign.MINUS && !flag) {
                return this.digits;
            }
            StringBuilder stringbuilder = new StringBuilder();
            p_409828_.append(stringbuilder);
            SnbtGrammar.cleanAndAppend(stringbuilder, this.digits, flag);
            return stringbuilder.toString();
        }

        @Nullable
        public <T> T create(DynamicOps<T> p_410386_, ParseState<?> p_409584_) {
            return this.create(p_410386_, Objects.requireNonNullElse(this.suffix.type, TypeSuffix.INT), p_409584_);
        }

        @Nullable
        public <T> T create(DynamicOps<T> p_409628_, TypeSuffix p_410472_, ParseState<?> p_410023_) {
            boolean flag;
            boolean bl = flag = this.signedOrDefault() == SignedPrefix.SIGNED;
            if (!flag && this.sign == Sign.MINUS) {
                p_410023_.errorCollector().store(p_410023_.mark(), ERROR_EXPECTED_NON_NEGATIVE_NUMBER);
                return null;
            }
            String s = this.cleanupDigits(this.sign);
            int i = switch (this.base.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> 2;
                case 1 -> 10;
                case 2 -> 16;
            };
            try {
                if (flag) {
                    return (T)(switch (p_410472_.ordinal()) {
                        case 2 -> p_409628_.createByte(Byte.parseByte(s, i));
                        case 3 -> p_409628_.createShort(Short.parseShort(s, i));
                        case 4 -> p_409628_.createInt(Integer.parseInt(s, i));
                        case 5 -> p_409628_.createLong(Long.parseLong(s, i));
                        default -> {
                            p_410023_.errorCollector().store(p_410023_.mark(), ERROR_EXPECTED_INTEGER_TYPE);
                            yield null;
                        }
                    });
                }
                return (T)(switch (p_410472_.ordinal()) {
                    case 2 -> p_409628_.createByte(UnsignedBytes.parseUnsignedByte((String)s, (int)i));
                    case 3 -> p_409628_.createShort(SnbtGrammar.parseUnsignedShort(s, i));
                    case 4 -> p_409628_.createInt(Integer.parseUnsignedInt(s, i));
                    case 5 -> p_409628_.createLong(Long.parseUnsignedLong(s, i));
                    default -> {
                        p_410023_.errorCollector().store(p_410023_.mark(), ERROR_EXPECTED_INTEGER_TYPE);
                        yield null;
                    }
                });
            }
            catch (NumberFormatException numberformatexception) {
                p_410023_.errorCollector().store(p_410023_.mark(), SnbtGrammar.createNumberParseError(numberformatexception));
                return null;
            }
        }
    }

    static enum Base {
        BINARY,
        DECIMAL,
        HEX;

    }
}

