/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.lang.runtime.SwitchBootstraps;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class NbtOps
implements DynamicOps<Tag> {
    public static final NbtOps INSTANCE = new NbtOps();

    private NbtOps() {
    }

    public Tag empty() {
        return EndTag.INSTANCE;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <U> U convertTo(DynamicOps<U> p_128980_, Tag p_128981_) {
        Tag tag = p_128981_;
        Objects.requireNonNull(tag);
        Tag tag2 = tag;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EndTag.class, ByteTag.class, ShortTag.class, IntTag.class, LongTag.class, FloatTag.class, DoubleTag.class, ByteArrayTag.class, StringTag.class, ListTag.class, CompoundTag.class, IntArrayTag.class, LongArrayTag.class}, (Object)tag2, n)) {
            case 0: {
                EndTag endtag = (EndTag)tag2;
                Object object = p_128980_.empty();
                return (U)object;
            }
            case 1: {
                byte b0;
                ByteTag byteTag = (ByteTag)tag2;
                try {
                    byte by;
                    b0 = by = byteTag.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                Object object = p_128980_.createByte(b0);
                return (U)object;
            }
            case 2: {
                short short1;
                ShortTag shortTag = (ShortTag)tag2;
                {
                    short s;
                    short1 = s = shortTag.value();
                }
                Object object = p_128980_.createShort(short1);
                return (U)object;
            }
            case 3: {
                int i;
                IntTag intTag = (IntTag)tag2;
                {
                    int n2;
                    i = n2 = intTag.value();
                }
                Object object = p_128980_.createInt(i);
                return (U)object;
            }
            case 4: {
                long j;
                LongTag longTag = (LongTag)tag2;
                {
                    long l;
                    j = l = longTag.value();
                }
                Object object = p_128980_.createLong(j);
                return (U)object;
            }
            case 5: {
                float f2;
                FloatTag floatTag = (FloatTag)tag2;
                {
                    float f;
                    f2 = f = floatTag.value();
                }
                Object object = p_128980_.createFloat(f2);
                return (U)object;
            }
            case 6: {
                double d0;
                DoubleTag doubleTag = (DoubleTag)tag2;
                {
                    double d;
                    d0 = d = doubleTag.value();
                }
                Object object = p_128980_.createDouble(d0);
                return (U)object;
            }
            case 7: {
                ByteArrayTag bytearraytag = (ByteArrayTag)tag2;
                Object object = p_128980_.createByteList(ByteBuffer.wrap(bytearraytag.getAsByteArray()));
                return (U)object;
            }
            case 8: {
                String s;
                StringTag stringTag = (StringTag)tag2;
                {
                    String string;
                    s = string = stringTag.value();
                }
                Object object = p_128980_.createString(s);
                return (U)object;
            }
            case 9: {
                ListTag listtag = (ListTag)tag2;
                Object object = this.convertList(p_128980_, listtag);
                return (U)object;
            }
            case 10: {
                CompoundTag compoundtag = (CompoundTag)tag2;
                Object object = this.convertMap(p_128980_, compoundtag);
                return (U)object;
            }
            case 11: {
                IntArrayTag intarraytag = (IntArrayTag)tag2;
                Object object = p_128980_.createIntList(Arrays.stream(intarraytag.getAsIntArray()));
                return (U)object;
            }
            case 12: {
                LongArrayTag longarraytag = (LongArrayTag)tag2;
                Object object = p_128980_.createLongList(Arrays.stream(longarraytag.getAsLongArray()));
                return (U)object;
            }
        }
        throw new MatchException(null, null);
    }

    public DataResult<Number> getNumberValue(Tag p_129030_) {
        return p_129030_.asNumber().map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Not a number"));
    }

    public Tag createNumeric(Number p_128983_) {
        return DoubleTag.valueOf(p_128983_.doubleValue());
    }

    public Tag createByte(byte p_128963_) {
        return ByteTag.valueOf(p_128963_);
    }

    public Tag createShort(short p_129048_) {
        return ShortTag.valueOf(p_129048_);
    }

    public Tag createInt(int p_128976_) {
        return IntTag.valueOf(p_128976_);
    }

    public Tag createLong(long p_128978_) {
        return LongTag.valueOf(p_128978_);
    }

    public Tag createFloat(float p_128974_) {
        return FloatTag.valueOf(p_128974_);
    }

    public Tag createDouble(double p_128972_) {
        return DoubleTag.valueOf(p_128972_);
    }

    public Tag createBoolean(boolean p_129050_) {
        return ByteTag.valueOf(p_129050_);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DataResult<String> getStringValue(Tag p_129061_) {
        String s;
        DataResult dataResult;
        if (!(p_129061_ instanceof StringTag)) {
            dataResult = DataResult.error(() -> "Not a string");
            return dataResult;
        }
        StringTag stringTag = (StringTag)p_129061_;
        try {
            String string;
            s = string = stringTag.value();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        dataResult = DataResult.success((Object)s);
        return dataResult;
    }

    public Tag createString(String p_128985_) {
        return StringTag.valueOf(p_128985_);
    }

    public DataResult<Tag> mergeToList(Tag p_129041_, Tag p_129042_) {
        return NbtOps.createCollector(p_129041_).map(p_248053_ -> DataResult.success((Object)p_248053_.accept(p_129042_).result())).orElseGet(() -> DataResult.error(() -> "mergeToList called with not a list: " + String.valueOf(p_129041_), (Object)p_129041_));
    }

    public DataResult<Tag> mergeToList(Tag p_129038_, List<Tag> p_129039_) {
        return NbtOps.createCollector(p_129038_).map(p_248048_ -> DataResult.success((Object)p_248048_.acceptAll(p_129039_).result())).orElseGet(() -> DataResult.error(() -> "mergeToList called with not a list: " + String.valueOf(p_129038_), (Object)p_129038_));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DataResult<Tag> mergeToMap(Tag p_129044_, Tag p_129045_, Tag p_129046_) {
        CompoundTag compoundTag;
        String $$5;
        if (!(p_129044_ instanceof CompoundTag) && !(p_129044_ instanceof EndTag)) {
            return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(p_129044_), (Object)p_129044_);
        }
        if (!(p_129045_ instanceof StringTag)) return DataResult.error(() -> "key is not a string: " + String.valueOf(p_129045_), (Object)p_129044_);
        StringTag stringTag = (StringTag)p_129045_;
        try {
            String string;
            String s1;
            $$5 = s1 = (string = stringTag.value());
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        if (p_129044_ instanceof CompoundTag) {
            CompoundTag compoundtag1 = (CompoundTag)p_129044_;
            compoundTag = compoundtag1.shallowCopy();
        } else {
            compoundTag = new CompoundTag();
        }
        CompoundTag compoundtag = compoundTag;
        compoundtag.put($$5, p_129046_);
        return DataResult.success((Object)compoundtag);
    }

    public DataResult<Tag> mergeToMap(Tag p_129032_, MapLike<Tag> p_129033_) {
        CompoundTag compoundTag;
        if (!(p_129032_ instanceof CompoundTag) && !(p_129032_ instanceof EndTag)) {
            return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(p_129032_), (Object)p_129032_);
        }
        if (p_129032_ instanceof CompoundTag) {
            CompoundTag compoundtag1 = (CompoundTag)p_129032_;
            compoundTag = compoundtag1.shallowCopy();
        } else {
            compoundTag = new CompoundTag();
        }
        CompoundTag compoundtag = compoundTag;
        ArrayList list = new ArrayList();
        p_129033_.entries().forEach(p_409125_ -> {
            Tag tag = (Tag)p_409125_.getFirst();
            if (!(tag instanceof StringTag)) {
                list.add(tag);
                return;
            }
            StringTag $b$0 = (StringTag)tag;
            try {
                String patt1$temp;
                String s = patt1$temp = $b$0.value();
                compoundtag.put(s, (Tag)p_409125_.getSecond());
                return;
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        });
        return !list.isEmpty() ? DataResult.error(() -> "some keys are not strings: " + String.valueOf(list), (Object)compoundtag) : DataResult.success((Object)compoundtag);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DataResult<Tag> mergeToMap(Tag p_341945_, Map<Tag, Tag> p_341920_) {
        DataResult dataResult;
        CompoundTag compoundTag;
        if (!(p_341945_ instanceof CompoundTag) && !(p_341945_ instanceof EndTag)) {
            return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(p_341945_), (Object)p_341945_);
        }
        if (p_341945_ instanceof CompoundTag) {
            CompoundTag compoundtag1 = (CompoundTag)p_341945_;
            compoundTag = compoundtag1.shallowCopy();
        } else {
            compoundTag = new CompoundTag();
        }
        CompoundTag compoundtag = compoundTag;
        ArrayList<Tag> list = new ArrayList<Tag>();
        for (Map.Entry<Tag, Tag> entry : p_341920_.entrySet()) {
            Tag tag = entry.getKey();
            if (tag instanceof StringTag) {
                StringTag stringTag = (StringTag)tag;
                try {
                    String string;
                    String s = string = stringTag.value();
                    compoundtag.put(s, entry.getValue());
                    continue;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            list.add(tag);
        }
        if (!list.isEmpty()) {
            dataResult = DataResult.error(() -> "some keys are not strings: " + String.valueOf(list), (Object)compoundtag);
            return dataResult;
        }
        dataResult = DataResult.success((Object)compoundtag);
        return dataResult;
    }

    public DataResult<Stream<Pair<Tag, Tag>>> getMapValues(Tag p_129070_) {
        DataResult dataResult;
        if (p_129070_ instanceof CompoundTag) {
            CompoundTag compoundtag = (CompoundTag)p_129070_;
            dataResult = DataResult.success(compoundtag.entrySet().stream().map(p_341872_ -> Pair.of((Object)this.createString((String)p_341872_.getKey()), (Object)((Tag)p_341872_.getValue()))));
        } else {
            dataResult = DataResult.error(() -> "Not a map: " + String.valueOf(p_129070_));
        }
        return dataResult;
    }

    public DataResult<Consumer<BiConsumer<Tag, Tag>>> getMapEntries(Tag p_129103_) {
        DataResult dataResult;
        if (p_129103_ instanceof CompoundTag) {
            CompoundTag compoundtag = (CompoundTag)p_129103_;
            dataResult = DataResult.success(p_341867_ -> {
                for (Map.Entry<String, Tag> entry : compoundtag.entrySet()) {
                    p_341867_.accept(this.createString(entry.getKey()), entry.getValue());
                }
            });
        } else {
            dataResult = DataResult.error(() -> "Not a map: " + String.valueOf(p_129103_));
        }
        return dataResult;
    }

    public DataResult<MapLike<Tag>> getMap(Tag p_129105_) {
        DataResult dataResult;
        if (p_129105_ instanceof CompoundTag) {
            final CompoundTag compoundtag = (CompoundTag)p_129105_;
            dataResult = DataResult.success((Object)new MapLike<Tag>(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public Tag get(Tag p_129174_) {
                    if (!(p_129174_ instanceof StringTag)) throw new UnsupportedOperationException("Cannot get map entry with non-string key: " + String.valueOf(p_129174_));
                    StringTag stringTag = (StringTag)p_129174_;
                    try {
                        String string;
                        String s = string = stringTag.value();
                        return compoundtag.get(s);
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                }

                @Nullable
                public Tag get(String p_129169_) {
                    return compoundtag.get(p_129169_);
                }

                public Stream<Pair<Tag, Tag>> entries() {
                    return compoundtag.entrySet().stream().map(p_341873_ -> Pair.of((Object)NbtOps.this.createString((String)p_341873_.getKey()), (Object)((Tag)p_341873_.getValue())));
                }

                public String toString() {
                    return "MapLike[" + String.valueOf(compoundtag) + "]";
                }
            });
        } else {
            dataResult = DataResult.error(() -> "Not a map: " + String.valueOf(p_129105_));
        }
        return dataResult;
    }

    public Tag createMap(Stream<Pair<Tag, Tag>> p_129004_) {
        CompoundTag compoundtag = new CompoundTag();
        p_129004_.forEach(p_409127_ -> {
            Tag tag = (Tag)p_409127_.getFirst();
            Tag tag1 = (Tag)p_409127_.getSecond();
            if (!(tag instanceof StringTag)) throw new UnsupportedOperationException("Cannot create map with non-string key: " + String.valueOf(tag));
            StringTag $b$0 = (StringTag)tag;
            try {
                String patt1$temp;
                String s = patt1$temp = $b$0.value();
                compoundtag.put(s, tag1);
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        });
        return compoundtag;
    }

    public DataResult<Stream<Tag>> getStream(Tag p_129108_) {
        DataResult dataResult;
        if (p_129108_ instanceof CollectionTag) {
            CollectionTag collectiontag = (CollectionTag)p_129108_;
            dataResult = DataResult.success(collectiontag.stream());
        } else {
            dataResult = DataResult.error(() -> "Not a list");
        }
        return dataResult;
    }

    public DataResult<Consumer<Consumer<Tag>>> getList(Tag p_129110_) {
        DataResult dataResult;
        if (p_129110_ instanceof CollectionTag) {
            CollectionTag collectiontag = (CollectionTag)p_129110_;
            dataResult = DataResult.success(collectiontag::forEach);
        } else {
            dataResult = DataResult.error(() -> "Not a list: " + String.valueOf(p_129110_));
        }
        return dataResult;
    }

    public DataResult<ByteBuffer> getByteBuffer(Tag p_129132_) {
        DataResult dataResult;
        if (p_129132_ instanceof ByteArrayTag) {
            ByteArrayTag bytearraytag = (ByteArrayTag)p_129132_;
            dataResult = DataResult.success((Object)ByteBuffer.wrap(bytearraytag.getAsByteArray()));
        } else {
            dataResult = super.getByteBuffer((Object)p_129132_);
        }
        return dataResult;
    }

    public Tag createByteList(ByteBuffer p_128990_) {
        ByteBuffer bytebuffer = p_128990_.duplicate().clear();
        byte[] abyte = new byte[p_128990_.capacity()];
        bytebuffer.get(0, abyte, 0, abyte.length);
        return new ByteArrayTag(abyte);
    }

    public DataResult<IntStream> getIntStream(Tag p_129134_) {
        DataResult dataResult;
        if (p_129134_ instanceof IntArrayTag) {
            IntArrayTag intarraytag = (IntArrayTag)p_129134_;
            dataResult = DataResult.success((Object)Arrays.stream(intarraytag.getAsIntArray()));
        } else {
            dataResult = super.getIntStream((Object)p_129134_);
        }
        return dataResult;
    }

    public Tag createIntList(IntStream p_129000_) {
        return new IntArrayTag(p_129000_.toArray());
    }

    public DataResult<LongStream> getLongStream(Tag p_129136_) {
        DataResult dataResult;
        if (p_129136_ instanceof LongArrayTag) {
            LongArrayTag longarraytag = (LongArrayTag)p_129136_;
            dataResult = DataResult.success((Object)Arrays.stream(longarraytag.getAsLongArray()));
        } else {
            dataResult = super.getLongStream((Object)p_129136_);
        }
        return dataResult;
    }

    public Tag createLongList(LongStream p_129002_) {
        return new LongArrayTag(p_129002_.toArray());
    }

    public Tag createList(Stream<Tag> p_129052_) {
        return new ListTag(p_129052_.collect(Util.toMutableList()));
    }

    public Tag remove(Tag p_129035_, String p_129036_) {
        if (p_129035_ instanceof CompoundTag) {
            CompoundTag compoundtag = (CompoundTag)p_129035_;
            CompoundTag compoundtag1 = compoundtag.shallowCopy();
            compoundtag1.remove(p_129036_);
            return compoundtag1;
        }
        return p_129035_;
    }

    public String toString() {
        return "NBT";
    }

    public RecordBuilder<Tag> mapBuilder() {
        return new NbtRecordBuilder(this);
    }

    private static Optional<ListCollector> createCollector(Tag p_249503_) {
        if (p_249503_ instanceof EndTag) {
            return Optional.of(new GenericListCollector());
        }
        if (p_249503_ instanceof CollectionTag) {
            CollectionTag collectiontag = (CollectionTag)p_249503_;
            if (collectiontag.isEmpty()) {
                return Optional.of(new GenericListCollector());
            }
            CollectionTag collectionTag = collectiontag;
            Objects.requireNonNull(collectionTag);
            CollectionTag collectionTag2 = collectionTag;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ListTag.class, ByteArrayTag.class, IntArrayTag.class, LongArrayTag.class}, (Object)collectionTag2, n)) {
                case 0 -> {
                    ListTag listtag = (ListTag)collectionTag2;
                    yield Optional.of(new GenericListCollector(listtag));
                }
                case 1 -> {
                    ByteArrayTag bytearraytag = (ByteArrayTag)collectionTag2;
                    yield Optional.of(new ByteListCollector(bytearraytag.getAsByteArray()));
                }
                case 2 -> {
                    IntArrayTag intarraytag = (IntArrayTag)collectionTag2;
                    yield Optional.of(new IntListCollector(intarraytag.getAsIntArray()));
                }
                case 3 -> {
                    LongArrayTag longarraytag = (LongArrayTag)collectionTag2;
                    yield Optional.of(new LongListCollector(longarraytag.getAsLongArray()));
                }
                default -> throw new MatchException(null, null);
            };
        }
        return Optional.empty();
    }

    class NbtRecordBuilder
    extends RecordBuilder.AbstractStringBuilder<Tag, CompoundTag> {
        protected NbtRecordBuilder(NbtOps this$0) {
            super((DynamicOps)this$0);
        }

        protected CompoundTag initBuilder() {
            return new CompoundTag();
        }

        protected CompoundTag append(String p_129186_, Tag p_129187_, CompoundTag p_129188_) {
            p_129188_.put(p_129186_, p_129187_);
            return p_129188_;
        }

        protected DataResult<Tag> build(CompoundTag p_129190_, Tag p_129191_) {
            if (p_129191_ == null || p_129191_ == EndTag.INSTANCE) {
                return DataResult.success((Object)p_129190_);
            }
            if (!(p_129191_ instanceof CompoundTag)) {
                return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(p_129191_), (Object)p_129191_);
            }
            CompoundTag compoundtag = (CompoundTag)p_129191_;
            CompoundTag compoundtag1 = compoundtag.shallowCopy();
            for (Map.Entry<String, Tag> entry : p_129190_.entrySet()) {
                compoundtag1.put(entry.getKey(), entry.getValue());
            }
            return DataResult.success((Object)compoundtag1);
        }
    }

    static class GenericListCollector
    implements ListCollector {
        private final ListTag result = new ListTag();

        GenericListCollector() {
        }

        GenericListCollector(ListTag p_410808_) {
            this.result.addAll(p_410808_);
        }

        public GenericListCollector(IntArrayList p_410408_) {
            p_410408_.forEach(p_410063_ -> this.result.add(IntTag.valueOf(p_410063_)));
        }

        public GenericListCollector(ByteArrayList p_410684_) {
            p_410684_.forEach(p_410068_ -> this.result.add(ByteTag.valueOf(p_410068_)));
        }

        public GenericListCollector(LongArrayList p_410197_) {
            p_410197_.forEach(p_409796_ -> this.result.add(LongTag.valueOf(p_409796_)));
        }

        @Override
        public ListCollector accept(Tag p_409877_) {
            this.result.add(p_409877_);
            return this;
        }

        @Override
        public Tag result() {
            return this.result;
        }
    }

    static class ByteListCollector
    implements ListCollector {
        private final ByteArrayList values = new ByteArrayList();

        public ByteListCollector(byte[] p_250457_) {
            this.values.addElements(0, p_250457_);
        }

        @Override
        public ListCollector accept(Tag p_250723_) {
            if (p_250723_ instanceof ByteTag) {
                ByteTag bytetag = (ByteTag)p_250723_;
                this.values.add(bytetag.byteValue());
                return this;
            }
            return new GenericListCollector(this.values).accept(p_250723_);
        }

        @Override
        public Tag result() {
            return new ByteArrayTag(this.values.toByteArray());
        }
    }

    static class IntListCollector
    implements ListCollector {
        private final IntArrayList values = new IntArrayList();

        public IntListCollector(int[] p_249489_) {
            this.values.addElements(0, p_249489_);
        }

        @Override
        public ListCollector accept(Tag p_251372_) {
            if (p_251372_ instanceof IntTag) {
                IntTag inttag = (IntTag)p_251372_;
                this.values.add(inttag.intValue());
                return this;
            }
            return new GenericListCollector(this.values).accept(p_251372_);
        }

        @Override
        public Tag result() {
            return new IntArrayTag(this.values.toIntArray());
        }
    }

    static class LongListCollector
    implements ListCollector {
        private final LongArrayList values = new LongArrayList();

        public LongListCollector(long[] p_251409_) {
            this.values.addElements(0, p_251409_);
        }

        @Override
        public ListCollector accept(Tag p_252167_) {
            if (p_252167_ instanceof LongTag) {
                LongTag longtag = (LongTag)p_252167_;
                this.values.add(longtag.longValue());
                return this;
            }
            return new GenericListCollector(this.values).accept(p_252167_);
        }

        @Override
        public Tag result() {
            return new LongArrayTag(this.values.toLongArray());
        }
    }

    static interface ListCollector {
        public ListCollector accept(Tag var1);

        default public ListCollector acceptAll(Iterable<Tag> p_249781_) {
            ListCollector nbtops$listcollector = this;
            for (Tag tag : p_249781_) {
                nbtops$listcollector = nbtops$listcollector.accept(tag);
            }
            return nbtops$listcollector;
        }

        default public ListCollector acceptAll(Stream<Tag> p_249876_) {
            return this.acceptAll(p_249876_::iterator);
        }

        public Tag result();
    }
}

