/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.StringTagVisitor;
import net.minecraft.nbt.TagType;
import net.minecraft.nbt.TagVisitor;
import net.minecraft.util.Mth;

public record FloatTag(float value) implements NumericTag
{
    private static final int SELF_SIZE_IN_BYTES = 12;
    public static final FloatTag ZERO = new FloatTag(0.0f);
    public static final TagType<FloatTag> TYPE = new TagType.StaticSize<FloatTag>(){

        @Override
        public FloatTag load(DataInput p_128590_, NbtAccounter p_128592_) throws IOException {
            return FloatTag.valueOf(1.readAccounted(p_128590_, p_128592_));
        }

        @Override
        public StreamTagVisitor.ValueResult parse(DataInput p_197470_, StreamTagVisitor p_197471_, NbtAccounter p_302329_) throws IOException {
            return p_197471_.visit(1.readAccounted(p_197470_, p_302329_));
        }

        private static float readAccounted(DataInput p_302328_, NbtAccounter p_302359_) throws IOException {
            p_302359_.accountBytes(12L);
            return p_302328_.readFloat();
        }

        @Override
        public int size() {
            return 4;
        }

        @Override
        public String getName() {
            return "FLOAT";
        }

        @Override
        public String getPrettyName() {
            return "TAG_Float";
        }
    };

    public static FloatTag valueOf(float p_128567_) {
        return p_128567_ == 0.0f ? ZERO : new FloatTag(p_128567_);
    }

    @Override
    public void write(DataOutput p_128569_) throws IOException {
        p_128569_.writeFloat(this.value);
    }

    @Override
    public int sizeInBytes() {
        return 12;
    }

    @Override
    public byte getId() {
        return 5;
    }

    public TagType<FloatTag> getType() {
        return TYPE;
    }

    @Override
    public FloatTag copy() {
        return this;
    }

    @Override
    public void accept(TagVisitor p_177866_) {
        p_177866_.visitFloat(this);
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public int intValue() {
        return Mth.floor(this.value);
    }

    @Override
    public short shortValue() {
        return (short)(Mth.floor(this.value) & 0xFFFF);
    }

    @Override
    public byte byteValue() {
        return (byte)(Mth.floor(this.value) & 0xFF);
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public Number box() {
        return Float.valueOf(this.value);
    }

    @Override
    public StreamTagVisitor.ValueResult accept(StreamTagVisitor p_197468_) {
        return p_197468_.visit(this.value);
    }

    @Override
    public String toString() {
        StringTagVisitor stringtagvisitor = new StringTagVisitor();
        stringtagvisitor.visitFloat(this);
        return stringtagvisitor.build();
    }
}

