/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.ResourceSelectorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.gametest.framework.FailedTestTracker;
import net.minecraft.gametest.framework.GameTestBatch;
import net.minecraft.gametest.framework.GameTestBatchFactory;
import net.minecraft.gametest.framework.GameTestBatchListener;
import net.minecraft.gametest.framework.GameTestInfo;
import net.minecraft.gametest.framework.GameTestInstance;
import net.minecraft.gametest.framework.GameTestListener;
import net.minecraft.gametest.framework.GameTestRunner;
import net.minecraft.gametest.framework.GameTestTicker;
import net.minecraft.gametest.framework.MultipleTestTracker;
import net.minecraft.gametest.framework.RetryOptions;
import net.minecraft.gametest.framework.StructureGridSpawner;
import net.minecraft.gametest.framework.StructureUtils;
import net.minecraft.gametest.framework.TestFinder;
import net.minecraft.gametest.framework.TestInstanceFinder;
import net.minecraft.gametest.framework.TestPosFinder;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.commands.InCommandFunction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.TestInstanceBlockEntity;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.BlockHitResult;
import org.apache.commons.lang3.mutable.MutableInt;

public class TestCommand {
    public static final int TEST_NEARBY_SEARCH_RADIUS = 15;
    public static final int TEST_FULL_SEARCH_RADIUS = 200;
    public static final int VERIFY_TEST_GRID_AXIS_SIZE = 10;
    public static final int VERIFY_TEST_BATCH_SIZE = 100;
    private static final int DEFAULT_CLEAR_RADIUS = 200;
    private static final int MAX_CLEAR_RADIUS = 1024;
    private static final int TEST_POS_Z_OFFSET_FROM_PLAYER = 3;
    private static final int SHOW_POS_DURATION_MS = 10000;
    private static final int DEFAULT_X_SIZE = 5;
    private static final int DEFAULT_Y_SIZE = 5;
    private static final int DEFAULT_Z_SIZE = 5;
    private static final SimpleCommandExceptionType CLEAR_NO_TESTS = new SimpleCommandExceptionType((Message)Component.translatable("commands.test.clear.error.no_tests"));
    private static final SimpleCommandExceptionType RESET_NO_TESTS = new SimpleCommandExceptionType((Message)Component.translatable("commands.test.reset.error.no_tests"));
    private static final SimpleCommandExceptionType TEST_INSTANCE_COULD_NOT_BE_FOUND = new SimpleCommandExceptionType((Message)Component.translatable("commands.test.error.test_instance_not_found"));
    private static final SimpleCommandExceptionType NO_STRUCTURES_TO_EXPORT = new SimpleCommandExceptionType((Message)Component.literal("Could not find any structures to export"));
    private static final SimpleCommandExceptionType NO_TEST_INSTANCES = new SimpleCommandExceptionType((Message)Component.translatable("commands.test.error.no_test_instances"));
    private static final Dynamic3CommandExceptionType NO_TEST_CONTAINING = new Dynamic3CommandExceptionType((p_396466_, p_396467_, p_396468_) -> Component.translatableEscape("commands.test.error.no_test_containing_pos", p_396466_, p_396467_, p_396468_));
    private static final DynamicCommandExceptionType TOO_LARGE = new DynamicCommandExceptionType(p_399389_ -> Component.translatableEscape("commands.test.error.too_large", p_399389_));

    private static int reset(TestFinder p_397649_) throws CommandSyntaxException {
        TestCommand.stopTests();
        int i = TestCommand.toGameTestInfos(p_397649_.source(), RetryOptions.noRetries(), p_397649_).map(p_396435_ -> TestCommand.resetGameTestInfo(p_397649_.source(), p_396435_)).toList().size();
        if (i == 0) {
            throw CLEAR_NO_TESTS.create();
        }
        p_397649_.source().sendSuccess(() -> Component.translatable("commands.test.reset.success", i), true);
        return i;
    }

    private static int clear(TestFinder p_397313_) throws CommandSyntaxException {
        TestCommand.stopTests();
        CommandSourceStack commandsourcestack = p_397313_.source();
        ServerLevel serverlevel = commandsourcestack.getLevel();
        GameTestRunner.clearMarkers(serverlevel);
        List<BoundingBox> list = p_397313_.findTestPos().flatMap(p_404172_ -> serverlevel.getBlockEntity((BlockPos)p_404172_, BlockEntityType.TEST_INSTANCE_BLOCK).stream()).map(TestInstanceBlockEntity::getStructureBoundingBox).toList();
        list.forEach(p_404174_ -> StructureUtils.clearSpaceForStructure(p_404174_, serverlevel));
        if (list.isEmpty()) {
            throw CLEAR_NO_TESTS.create();
        }
        commandsourcestack.sendSuccess(() -> Component.translatable("commands.test.clear.success", list.size()), true);
        return list.size();
    }

    private static int export(TestFinder p_397687_) throws CommandSyntaxException {
        CommandSourceStack commandsourcestack = p_397687_.source();
        ServerLevel serverlevel = commandsourcestack.getLevel();
        int i = 0;
        boolean flag = true;
        Iterator iterator = p_397687_.findTestPos().iterator();
        while (iterator.hasNext()) {
            BlockPos blockpos = (BlockPos)iterator.next();
            BlockEntity blockEntity = serverlevel.getBlockEntity(blockpos);
            if (!(blockEntity instanceof TestInstanceBlockEntity)) {
                throw TEST_INSTANCE_COULD_NOT_BE_FOUND.create();
            }
            TestInstanceBlockEntity testinstanceblockentity = (TestInstanceBlockEntity)blockEntity;
            if (!testinstanceblockentity.exportTest(commandsourcestack::sendSystemMessage)) {
                flag = false;
            }
            ++i;
        }
        if (i == 0) {
            throw NO_STRUCTURES_TO_EXPORT.create();
        }
        String s = "Exported " + i + " structures";
        p_397687_.source().sendSuccess(() -> Component.literal(s), true);
        return flag ? 0 : 1;
    }

    private static int verify(TestFinder p_397193_) {
        TestCommand.stopTests();
        CommandSourceStack commandsourcestack = p_397193_.source();
        ServerLevel serverlevel = commandsourcestack.getLevel();
        BlockPos blockpos = TestCommand.createTestPositionAround(commandsourcestack);
        List<GameTestInfo> collection = Stream.concat(TestCommand.toGameTestInfos(commandsourcestack, RetryOptions.noRetries(), p_397193_), TestCommand.toGameTestInfo(commandsourcestack, RetryOptions.noRetries(), p_397193_, 0)).toList();
        GameTestRunner.clearMarkers(serverlevel);
        FailedTestTracker.forgetFailedTests();
        ArrayList<GameTestBatch> collection1 = new ArrayList<GameTestBatch>();
        for (GameTestInfo gametestinfo : collection) {
            for (Rotation rotation : Rotation.values()) {
                ArrayList<GameTestInfo> collection2 = new ArrayList<GameTestInfo>();
                for (int i = 0; i < 100; ++i) {
                    GameTestInfo gametestinfo1 = new GameTestInfo(gametestinfo.getTestHolder(), rotation, serverlevel, new RetryOptions(1, true));
                    gametestinfo1.setTestBlockPos(gametestinfo.getTestBlockPos());
                    collection2.add(gametestinfo1);
                }
                GameTestBatch gametestbatch = GameTestBatchFactory.toGameTestBatch(collection2, gametestinfo.getTest().batch(), rotation.ordinal());
                collection1.add(gametestbatch);
            }
        }
        StructureGridSpawner structuregridspawner = new StructureGridSpawner(blockpos, 10, true);
        GameTestRunner gametestrunner = GameTestRunner.Builder.fromBatches(collection1, serverlevel).batcher(GameTestBatchFactory.fromGameTestInfo(100)).newStructureSpawner(structuregridspawner).existingStructureSpawner(structuregridspawner).haltOnError(true).build();
        return TestCommand.trackAndStartRunner(commandsourcestack, gametestrunner);
    }

    private static int run(TestFinder p_397551_, RetryOptions p_397983_, int p_397852_, int p_397200_) {
        TestCommand.stopTests();
        CommandSourceStack commandsourcestack = p_397551_.source();
        ServerLevel serverlevel = commandsourcestack.getLevel();
        BlockPos blockpos = TestCommand.createTestPositionAround(commandsourcestack);
        List<GameTestInfo> collection = Stream.concat(TestCommand.toGameTestInfos(commandsourcestack, p_397983_, p_397551_), TestCommand.toGameTestInfo(commandsourcestack, p_397983_, p_397551_, p_397852_)).toList();
        if (collection.isEmpty()) {
            commandsourcestack.sendSuccess(() -> Component.translatable("commands.test.no_tests"), false);
            return 0;
        }
        GameTestRunner.clearMarkers(serverlevel);
        FailedTestTracker.forgetFailedTests();
        commandsourcestack.sendSuccess(() -> Component.translatable("commands.test.run.running", collection.size()), false);
        GameTestRunner gametestrunner = GameTestRunner.Builder.fromInfo(collection, serverlevel).newStructureSpawner(new StructureGridSpawner(blockpos, p_397200_, false)).build();
        return TestCommand.trackAndStartRunner(commandsourcestack, gametestrunner);
    }

    private static int locate(TestFinder p_398025_) throws CommandSyntaxException {
        p_398025_.source().sendSystemMessage(Component.translatable("commands.test.locate.started"));
        MutableInt mutableint = new MutableInt(0);
        BlockPos blockpos = BlockPos.containing(p_398025_.source().getPosition());
        p_398025_.findTestPos().forEach(p_396478_ -> {
            BlockEntity patt0$temp = p_398025_.source().getLevel().getBlockEntity((BlockPos)p_396478_);
            if (patt0$temp instanceof TestInstanceBlockEntity) {
                TestInstanceBlockEntity testinstanceblockentity = (TestInstanceBlockEntity)patt0$temp;
                Direction direction = testinstanceblockentity.getRotation().rotate(Direction.NORTH);
                BlockPos $$8 = testinstanceblockentity.getBlockPos().relative(direction, 2);
                int $$9 = (int)direction.getOpposite().toYRot();
                String $$10 = String.format(Locale.ROOT, "/tp @s %d %d %d %d 0", $$8.getX(), $$8.getY(), $$8.getZ(), $$9);
                int $$11 = blockpos.getX() - p_396478_.getX();
                int $$12 = blockpos.getZ() - p_396478_.getZ();
                int $$13 = Mth.floor(Mth.sqrt($$11 * $$11 + $$12 * $$12));
                MutableComponent $$14 = ComponentUtils.wrapInSquareBrackets(Component.translatable("chat.coordinates", p_396478_.getX(), p_396478_.getY(), p_396478_.getZ())).withStyle(p_396438_ -> p_396438_.withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent.SuggestCommand($$10)).withHoverEvent(new HoverEvent.ShowText(Component.translatable("chat.coordinates.tooltip"))));
                p_398025_.source().sendSuccess(() -> Component.translatable("commands.test.locate.found", $$14, $$13), false);
                mutableint.increment();
            }
        });
        int i = mutableint.intValue();
        if (i == 0) {
            throw NO_TEST_INSTANCES.create();
        }
        p_398025_.source().sendSuccess(() -> Component.translatable("commands.test.locate.done", i), true);
        return i;
    }

    private static ArgumentBuilder<CommandSourceStack, ?> runWithRetryOptions(ArgumentBuilder<CommandSourceStack, ?> p_320965_, InCommandFunction<CommandContext<CommandSourceStack>, TestFinder> p_397601_, Function<ArgumentBuilder<CommandSourceStack, ?>, ArgumentBuilder<CommandSourceStack, ?>> p_320702_) {
        return p_320965_.executes(p_396451_ -> TestCommand.run((TestFinder)p_397601_.apply(p_396451_), RetryOptions.noRetries(), 0, 8)).then(((RequiredArgumentBuilder)Commands.argument("numberOfTimes", IntegerArgumentType.integer((int)0)).executes(p_396459_ -> TestCommand.run((TestFinder)p_397601_.apply(p_396459_), new RetryOptions(IntegerArgumentType.getInteger((CommandContext)p_396459_, (String)"numberOfTimes"), false), 0, 8))).then(p_320702_.apply(Commands.argument("untilFailed", BoolArgumentType.bool()).executes(p_396440_ -> TestCommand.run((TestFinder)p_397601_.apply(p_396440_), new RetryOptions(IntegerArgumentType.getInteger((CommandContext)p_396440_, (String)"numberOfTimes"), BoolArgumentType.getBool((CommandContext)p_396440_, (String)"untilFailed")), 0, 8)))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> runWithRetryOptions(ArgumentBuilder<CommandSourceStack, ?> p_320397_, InCommandFunction<CommandContext<CommandSourceStack>, TestFinder> p_397514_) {
        return TestCommand.runWithRetryOptions(p_320397_, p_397514_, p_319485_ -> p_319485_);
    }

    private static ArgumentBuilder<CommandSourceStack, ?> runWithRetryOptionsAndBuildInfo(ArgumentBuilder<CommandSourceStack, ?> p_320872_, InCommandFunction<CommandContext<CommandSourceStack>, TestFinder> p_397644_) {
        return TestCommand.runWithRetryOptions(p_320872_, p_397644_, p_319482_ -> p_319482_.then(((RequiredArgumentBuilder)Commands.argument("rotationSteps", IntegerArgumentType.integer()).executes(p_396457_ -> TestCommand.run((TestFinder)p_397644_.apply(p_396457_), new RetryOptions(IntegerArgumentType.getInteger((CommandContext)p_396457_, (String)"numberOfTimes"), BoolArgumentType.getBool((CommandContext)p_396457_, (String)"untilFailed")), IntegerArgumentType.getInteger((CommandContext)p_396457_, (String)"rotationSteps"), 8))).then(Commands.argument("testsPerRow", IntegerArgumentType.integer()).executes(p_396448_ -> TestCommand.run((TestFinder)p_397644_.apply(p_396448_), new RetryOptions(IntegerArgumentType.getInteger((CommandContext)p_396448_, (String)"numberOfTimes"), BoolArgumentType.getBool((CommandContext)p_396448_, (String)"untilFailed")), IntegerArgumentType.getInteger((CommandContext)p_396448_, (String)"rotationSteps"), IntegerArgumentType.getInteger((CommandContext)p_396448_, (String)"testsPerRow"))))));
    }

    public static void register(CommandDispatcher<CommandSourceStack> p_397608_, CommandBuildContext p_397506_) {
        ArgumentBuilder<CommandSourceStack, ?> argumentbuilder = TestCommand.runWithRetryOptionsAndBuildInfo(Commands.argument("onlyRequiredTests", BoolArgumentType.bool()), p_396444_ -> TestFinder.builder().failedTests((CommandContext<CommandSourceStack>)p_396444_, BoolArgumentType.getBool((CommandContext)p_396444_, (String)"onlyRequiredTests")));
        LiteralArgumentBuilder literalargumentbuilder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("test").requires(Commands.hasPermission(2))).then(Commands.literal("run").then(TestCommand.runWithRetryOptionsAndBuildInfo(Commands.argument("tests", ResourceSelectorArgument.resourceSelector(p_397506_, Registries.TEST_INSTANCE)), p_425189_ -> TestFinder.builder().byResourceSelection((CommandContext<CommandSourceStack>)p_425189_, ResourceSelectorArgument.getSelectedResources((CommandContext<CommandSourceStack>)p_425189_, "tests")))))).then(Commands.literal("runmultiple").then(((RequiredArgumentBuilder)Commands.argument("tests", ResourceSelectorArgument.resourceSelector(p_397506_, Registries.TEST_INSTANCE)).executes(p_425190_ -> TestCommand.run(TestFinder.builder().byResourceSelection((CommandContext<CommandSourceStack>)p_425190_, ResourceSelectorArgument.getSelectedResources((CommandContext<CommandSourceStack>)p_425190_, "tests")), RetryOptions.noRetries(), 0, 8))).then(Commands.argument("amount", IntegerArgumentType.integer()).executes(p_425191_ -> TestCommand.run(TestFinder.builder().createMultipleCopies(IntegerArgumentType.getInteger((CommandContext)p_425191_, (String)"amount")).byResourceSelection((CommandContext<CommandSourceStack>)p_425191_, ResourceSelectorArgument.getSelectedResources((CommandContext<CommandSourceStack>)p_425191_, "tests")), RetryOptions.noRetries(), 0, 8)))))).then(TestCommand.runWithRetryOptions(Commands.literal("runthese"), TestFinder.builder()::allNearby))).then(TestCommand.runWithRetryOptions(Commands.literal("runclosest"), TestFinder.builder()::nearest))).then(TestCommand.runWithRetryOptions(Commands.literal("runthat"), TestFinder.builder()::lookedAt))).then(TestCommand.runWithRetryOptionsAndBuildInfo(Commands.literal("runfailed").then(argumentbuilder), TestFinder.builder()::failedTests))).then(Commands.literal("verify").then(Commands.argument("tests", ResourceSelectorArgument.resourceSelector(p_397506_, Registries.TEST_INSTANCE)).executes(p_425188_ -> TestCommand.verify(TestFinder.builder().byResourceSelection((CommandContext<CommandSourceStack>)p_425188_, ResourceSelectorArgument.getSelectedResources((CommandContext<CommandSourceStack>)p_425188_, "tests"))))))).then(Commands.literal("locate").then(Commands.argument("tests", ResourceSelectorArgument.resourceSelector(p_397506_, Registries.TEST_INSTANCE)).executes(p_425187_ -> TestCommand.locate(TestFinder.builder().byResourceSelection((CommandContext<CommandSourceStack>)p_425187_, ResourceSelectorArgument.getSelectedResources((CommandContext<CommandSourceStack>)p_425187_, "tests"))))))).then(Commands.literal("resetclosest").executes(p_396461_ -> TestCommand.reset(TestFinder.builder().nearest((CommandContext<CommandSourceStack>)p_396461_))))).then(Commands.literal("resetthese").executes(p_396453_ -> TestCommand.reset(TestFinder.builder().allNearby((CommandContext<CommandSourceStack>)p_396453_))))).then(Commands.literal("resetthat").executes(p_396462_ -> TestCommand.reset(TestFinder.builder().lookedAt((CommandContext<CommandSourceStack>)p_396462_))))).then(Commands.literal("clearthat").executes(p_396455_ -> TestCommand.clear(TestFinder.builder().lookedAt((CommandContext<CommandSourceStack>)p_396455_))))).then(Commands.literal("clearthese").executes(p_396442_ -> TestCommand.clear(TestFinder.builder().allNearby((CommandContext<CommandSourceStack>)p_396442_))))).then(((LiteralArgumentBuilder)Commands.literal("clearall").executes(p_396431_ -> TestCommand.clear(TestFinder.builder().radius((CommandContext<CommandSourceStack>)p_396431_, 200)))).then(Commands.argument("radius", IntegerArgumentType.integer()).executes(p_396425_ -> TestCommand.clear(TestFinder.builder().radius((CommandContext<CommandSourceStack>)p_396425_, Mth.clamp(IntegerArgumentType.getInteger((CommandContext)p_396425_, (String)"radius"), 0, 1024))))))).then(Commands.literal("stop").executes(p_319497_ -> TestCommand.stopTests()))).then(((LiteralArgumentBuilder)Commands.literal("pos").executes(p_128023_ -> TestCommand.showPos((CommandSourceStack)p_128023_.getSource(), "pos"))).then(Commands.argument("var", StringArgumentType.word()).executes(p_128021_ -> TestCommand.showPos((CommandSourceStack)p_128021_.getSource(), StringArgumentType.getString((CommandContext)p_128021_, (String)"var")))))).then(Commands.literal("create").then(((RequiredArgumentBuilder)Commands.argument("id", ResourceLocationArgument.id()).suggests(TestCommand::suggestTestFunction).executes(p_396424_ -> TestCommand.createNewStructure((CommandSourceStack)p_396424_.getSource(), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)p_396424_, "id"), 5, 5, 5))).then(((RequiredArgumentBuilder)Commands.argument("width", IntegerArgumentType.integer()).executes(p_396469_ -> TestCommand.createNewStructure((CommandSourceStack)p_396469_.getSource(), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)p_396469_, "id"), IntegerArgumentType.getInteger((CommandContext)p_396469_, (String)"width"), IntegerArgumentType.getInteger((CommandContext)p_396469_, (String)"width"), IntegerArgumentType.getInteger((CommandContext)p_396469_, (String)"width")))).then(Commands.argument("height", IntegerArgumentType.integer()).then(Commands.argument("depth", IntegerArgumentType.integer()).executes(p_396465_ -> TestCommand.createNewStructure((CommandSourceStack)p_396465_.getSource(), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)p_396465_, "id"), IntegerArgumentType.getInteger((CommandContext)p_396465_, (String)"width"), IntegerArgumentType.getInteger((CommandContext)p_396465_, (String)"height"), IntegerArgumentType.getInteger((CommandContext)p_396465_, (String)"depth"))))))));
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            literalargumentbuilder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)literalargumentbuilder.then(Commands.literal("export").then(Commands.argument("test", ResourceArgument.resource(p_397506_, Registries.TEST_INSTANCE)).executes(p_396460_ -> TestCommand.exportTestStructure((CommandSourceStack)p_396460_.getSource(), ResourceArgument.getResource((CommandContext<CommandSourceStack>)p_396460_, "test", Registries.TEST_INSTANCE)))))).then(Commands.literal("exportclosest").executes(p_396473_ -> TestCommand.export(TestFinder.builder().nearest((CommandContext<CommandSourceStack>)p_396473_))))).then(Commands.literal("exportthese").executes(p_396433_ -> TestCommand.export(TestFinder.builder().allNearby((CommandContext<CommandSourceStack>)p_396433_))))).then(Commands.literal("exportthat").executes(p_396423_ -> TestCommand.export(TestFinder.builder().lookedAt((CommandContext<CommandSourceStack>)p_396423_))));
        }
        p_397608_.register(literalargumentbuilder);
    }

    public static CompletableFuture<Suggestions> suggestTestFunction(CommandContext<CommandSourceStack> p_397651_, SuggestionsBuilder p_397175_) {
        Stream<String> stream = ((CommandSourceStack)p_397651_.getSource()).registryAccess().lookupOrThrow(Registries.TEST_FUNCTION).listElements().map(Holder::getRegisteredName);
        return SharedSuggestionProvider.suggest(stream, p_397175_);
    }

    private static int resetGameTestInfo(CommandSourceStack p_398051_, GameTestInfo p_320507_) {
        TestInstanceBlockEntity testinstanceblockentity = p_320507_.getTestInstanceBlockEntity();
        testinstanceblockentity.resetTest(p_398051_::sendSystemMessage);
        return 1;
    }

    private static Stream<GameTestInfo> toGameTestInfos(CommandSourceStack p_320827_, RetryOptions p_320932_, TestPosFinder p_397800_) {
        return p_397800_.findTestPos().map(p_396472_ -> TestCommand.createGameTestInfo(p_396472_, p_320827_, p_320932_)).flatMap(Optional::stream);
    }

    private static Stream<GameTestInfo> toGameTestInfo(CommandSourceStack p_320465_, RetryOptions p_320183_, TestInstanceFinder p_398020_, int p_320854_) {
        return p_398020_.findTests().filter(p_396427_ -> TestCommand.verifyStructureExists(p_320465_, ((GameTestInstance)p_396427_.value()).structure())).map(p_396422_ -> new GameTestInfo((Holder.Reference<GameTestInstance>)p_396422_, StructureUtils.getRotationForRotationSteps(p_320854_), p_320465_.getLevel(), p_320183_));
    }

    private static Optional<GameTestInfo> createGameTestInfo(BlockPos p_320172_, CommandSourceStack p_397178_, RetryOptions p_320822_) {
        ServerLevel serverlevel = p_397178_.getLevel();
        BlockEntity blockEntity = serverlevel.getBlockEntity(p_320172_);
        if (blockEntity instanceof TestInstanceBlockEntity) {
            TestInstanceBlockEntity testinstanceblockentity = (TestInstanceBlockEntity)blockEntity;
            Optional optional = testinstanceblockentity.test().flatMap(((Registry)p_397178_.registryAccess().lookupOrThrow(Registries.TEST_INSTANCE))::get);
            if (optional.isEmpty()) {
                p_397178_.sendFailure(Component.translatable("commands.test.error.non_existant_test", testinstanceblockentity.getTestName()));
                return Optional.empty();
            }
            Holder.Reference reference = (Holder.Reference)optional.get();
            GameTestInfo gametestinfo = new GameTestInfo(reference, testinstanceblockentity.getRotation(), serverlevel, p_320822_);
            gametestinfo.setTestBlockPos(p_320172_);
            return !TestCommand.verifyStructureExists(p_397178_, gametestinfo.getStructure()) ? Optional.empty() : Optional.of(gametestinfo);
        }
        p_397178_.sendFailure(Component.translatable("commands.test.error.test_instance_not_found.position", p_320172_.getX(), p_320172_.getY(), p_320172_.getZ()));
        return Optional.empty();
    }

    private static int createNewStructure(CommandSourceStack p_127968_, ResourceLocation p_397523_, int p_127970_, int p_127971_, int p_127972_) throws CommandSyntaxException {
        if (p_127970_ <= 48 && p_127971_ <= 48 && p_127972_ <= 48) {
            ServerLevel serverlevel = p_127968_.getLevel();
            BlockPos blockpos = TestCommand.createTestPositionAround(p_127968_);
            TestInstanceBlockEntity testinstanceblockentity = StructureUtils.createNewEmptyTest(p_397523_, blockpos, new Vec3i(p_127970_, p_127971_, p_127972_), Rotation.NONE, serverlevel);
            BlockPos blockpos1 = testinstanceblockentity.getStructurePos();
            BlockPos blockpos2 = blockpos1.offset(p_127970_ - 1, 0, p_127972_ - 1);
            BlockPos.betweenClosedStream(blockpos1, blockpos2).forEach(p_414995_ -> serverlevel.setBlockAndUpdate((BlockPos)p_414995_, Blocks.BEDROCK.defaultBlockState()));
            p_127968_.sendSuccess(() -> Component.translatable("commands.test.create.success", testinstanceblockentity.getTestName()), true);
            return 1;
        }
        throw TOO_LARGE.create((Object)48);
    }

    private static int showPos(CommandSourceStack p_127960_, String p_127961_) throws CommandSyntaxException {
        ServerLevel serverlevel;
        BlockHitResult blockhitresult = (BlockHitResult)p_127960_.getPlayerOrException().pick(10.0, 1.0f, false);
        BlockPos blockpos = blockhitresult.getBlockPos();
        Optional<BlockPos> optional = StructureUtils.findTestContainingPos(blockpos, 15, serverlevel = p_127960_.getLevel());
        if (optional.isEmpty()) {
            optional = StructureUtils.findTestContainingPos(blockpos, 200, serverlevel);
        }
        if (optional.isEmpty()) {
            throw NO_TEST_CONTAINING.create((Object)blockpos.getX(), (Object)blockpos.getY(), (Object)blockpos.getZ());
        }
        BlockEntity blockEntity = serverlevel.getBlockEntity(optional.get());
        if (blockEntity instanceof TestInstanceBlockEntity) {
            TestInstanceBlockEntity testinstanceblockentity = (TestInstanceBlockEntity)blockEntity;
            BlockPos blockpos2 = testinstanceblockentity.getStructurePos();
            BlockPos blockpos1 = blockpos.subtract(blockpos2);
            String $$10 = blockpos1.getX() + ", " + blockpos1.getY() + ", " + blockpos1.getZ();
            String $$11 = testinstanceblockentity.getTestName().getString();
            MutableComponent $$12 = Component.translatable("commands.test.coordinates", blockpos1.getX(), blockpos1.getY(), blockpos1.getZ()).setStyle(Style.EMPTY.withBold(true).withColor(ChatFormatting.GREEN).withHoverEvent(new HoverEvent.ShowText(Component.translatable("commands.test.coordinates.copy"))).withClickEvent(new ClickEvent.CopyToClipboard("final BlockPos " + p_127961_ + " = new BlockPos(" + $$10 + ");")));
            p_127960_.sendSuccess(() -> Component.translatable("commands.test.relative_position", $$11, $$12), false);
            DebugPackets.sendGameTestAddMarker(serverlevel, new BlockPos(blockpos), $$10, -2147418368, 10000);
            return 1;
        }
        throw TEST_INSTANCE_COULD_NOT_BE_FOUND.create();
    }

    private static int stopTests() {
        GameTestTicker.SINGLETON.clear();
        return 1;
    }

    public static int trackAndStartRunner(CommandSourceStack p_320627_, GameTestRunner p_320295_) {
        p_320295_.addListener(new TestBatchSummaryDisplayer(p_320627_));
        MultipleTestTracker multipletesttracker = new MultipleTestTracker(p_320295_.getTestInfos());
        multipletesttracker.addListener(new TestSummaryDisplayer(p_320627_, multipletesttracker));
        multipletesttracker.addFailureListener(p_396449_ -> FailedTestTracker.rememberFailedTest(p_396449_.getTestHolder()));
        p_320295_.start();
        return 1;
    }

    private static int exportTestStructure(CommandSourceStack p_128011_, Holder<GameTestInstance> p_397788_) {
        return !TestInstanceBlockEntity.export(p_128011_.getLevel(), p_397788_.value().structure(), p_128011_::sendSystemMessage) ? 0 : 1;
    }

    private static boolean verifyStructureExists(CommandSourceStack p_397899_, ResourceLocation p_397562_) {
        if (p_397899_.getLevel().getStructureManager().get(p_397562_).isEmpty()) {
            p_397899_.sendFailure(Component.translatable("commands.test.error.structure_not_found", Component.translationArg(p_397562_)));
            return false;
        }
        return true;
    }

    private static BlockPos createTestPositionAround(CommandSourceStack p_308921_) {
        BlockPos blockpos = BlockPos.containing(p_308921_.getPosition());
        int i = p_308921_.getLevel().getHeightmapPos(Heightmap.Types.WORLD_SURFACE, blockpos).getY();
        return new BlockPos(blockpos.getX(), i, blockpos.getZ() + 3);
    }

    record TestBatchSummaryDisplayer(CommandSourceStack source) implements GameTestBatchListener
    {
        @Override
        public void testBatchStarting(GameTestBatch p_319827_) {
            this.source.sendSuccess(() -> Component.translatable("commands.test.batch.starting", p_319827_.environment().getRegisteredName(), p_319827_.index()), true);
        }

        @Override
        public void testBatchFinished(GameTestBatch p_320779_) {
        }
    }

    public record TestSummaryDisplayer(CommandSourceStack source, MultipleTestTracker tracker) implements GameTestListener
    {
        @Override
        public void testStructureLoaded(GameTestInfo p_128064_) {
        }

        @Override
        public void testPassed(GameTestInfo p_177797_, GameTestRunner p_320726_) {
            this.showTestSummaryIfAllDone();
        }

        @Override
        public void testFailed(GameTestInfo p_128066_, GameTestRunner p_320567_) {
            this.showTestSummaryIfAllDone();
        }

        @Override
        public void testAddedForRerun(GameTestInfo p_319856_, GameTestInfo p_320528_, GameTestRunner p_319832_) {
            this.tracker.addTestToTrack(p_320528_);
        }

        private void showTestSummaryIfAllDone() {
            if (this.tracker.isDone()) {
                this.source.sendSuccess(() -> Component.translatable("commands.test.summary", this.tracker.getTotalCount()).withStyle(ChatFormatting.WHITE), true);
                if (this.tracker.hasFailedRequired()) {
                    this.source.sendFailure(Component.translatable("commands.test.summary.failed", this.tracker.getFailedRequiredCount()));
                } else {
                    this.source.sendSuccess(() -> Component.translatable("commands.test.summary.all_required_passed").withStyle(ChatFormatting.GREEN), true);
                }
                if (this.tracker.hasFailedOptional()) {
                    this.source.sendSystemMessage(Component.translatable("commands.test.summary.optional_failed", this.tracker.getFailedOptionalCount()));
                }
            }
        }
    }
}

