/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.collect.Lists;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.gametest.framework.GameTestInfo;
import net.minecraft.gametest.framework.GameTestRunner;

public class GameTestTicker {
    public static final GameTestTicker SINGLETON = new GameTestTicker();
    private final Collection<GameTestInfo> testInfos = Lists.newCopyOnWriteArrayList();
    @Nullable
    private GameTestRunner runner;
    private State state = State.IDLE;
    private volatile boolean ticking = false;

    private GameTestTicker() {
    }

    public void add(GameTestInfo p_127789_) {
        this.testInfos.add(p_127789_);
    }

    public void clear() {
        if (this.state != State.IDLE) {
            this.state = State.HALTING;
        } else {
            this.testInfos.clear();
            if (this.runner != null) {
                this.runner.stop();
                this.runner = null;
            }
        }
    }

    public void setRunner(GameTestRunner p_320547_) {
        if (this.runner != null) {
            Util.logAndPauseIfInIde("The runner was already set in GameTestTicker");
        }
        this.runner = p_320547_;
    }

    public void startTicking() {
        this.ticking = true;
    }

    public void tick() {
        if (this.runner != null && this.ticking) {
            this.state = State.RUNNING;
            this.testInfos.forEach(p_319813_ -> p_319813_.tick(this.runner));
            this.testInfos.removeIf(GameTestInfo::isDone);
            State gametestticker$state = this.state;
            this.state = State.IDLE;
            if (gametestticker$state == State.HALTING) {
                this.clear();
            }
        }
    }

    static enum State {
        IDLE,
        RUNNING,
        HALTING;

    }
}

