/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.gametest.framework.GameTestInstance;
import net.minecraft.gametest.framework.TestData;
import net.minecraft.gametest.framework.TestEnvironmentDefinition;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TestBlock;
import net.minecraft.world.level.block.entity.TestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.TestBlockMode;

public class BlockBasedTestInstance
extends GameTestInstance {
    public static final MapCodec<BlockBasedTestInstance> CODEC = RecordCodecBuilder.mapCodec(p_397683_ -> p_397683_.group((App)TestData.CODEC.forGetter(GameTestInstance::info)).apply((Applicative)p_397683_, BlockBasedTestInstance::new));

    public BlockBasedTestInstance(TestData<Holder<TestEnvironmentDefinition>> p_397064_) {
        super(p_397064_);
    }

    @Override
    public void run(GameTestHelper p_397754_) {
        BlockPos blockpos = this.findStartBlock(p_397754_);
        TestBlockEntity testblockentity = p_397754_.getBlockEntity(blockpos, TestBlockEntity.class);
        testblockentity.trigger();
        p_397754_.onEachTick(() -> {
            boolean flag;
            List<BlockPos> list = this.findTestBlocks(p_397754_, TestBlockMode.ACCEPT);
            if (list.isEmpty()) {
                p_397754_.fail(Component.translatable("test_block.error.missing", TestBlockMode.ACCEPT.getDisplayName()));
            }
            if (flag = list.stream().map(p_400878_ -> p_397754_.getBlockEntity((BlockPos)p_400878_, TestBlockEntity.class)).anyMatch(TestBlockEntity::hasTriggered)) {
                p_397754_.succeed();
            } else {
                this.forAllTriggeredTestBlocks(p_397754_, TestBlockMode.FAIL, p_397155_ -> p_397754_.fail(Component.literal(p_397155_.getMessage())));
                this.forAllTriggeredTestBlocks(p_397754_, TestBlockMode.LOG, TestBlockEntity::trigger);
            }
        });
    }

    private void forAllTriggeredTestBlocks(GameTestHelper p_397789_, TestBlockMode p_397661_, Consumer<TestBlockEntity> p_397861_) {
        for (BlockPos blockpos : this.findTestBlocks(p_397789_, p_397661_)) {
            TestBlockEntity testblockentity = p_397789_.getBlockEntity(blockpos, TestBlockEntity.class);
            if (!testblockentity.hasTriggered()) continue;
            p_397861_.accept(testblockentity);
            testblockentity.reset();
        }
    }

    private BlockPos findStartBlock(GameTestHelper p_397254_) {
        List<BlockPos> list = this.findTestBlocks(p_397254_, TestBlockMode.START);
        if (list.isEmpty()) {
            p_397254_.fail(Component.translatable("test_block.error.missing", TestBlockMode.START.getDisplayName()));
        }
        if (list.size() != 1) {
            p_397254_.fail(Component.translatable("test_block.error.too_many", TestBlockMode.START.getDisplayName()));
        }
        return list.getFirst();
    }

    private List<BlockPos> findTestBlocks(GameTestHelper p_397394_, TestBlockMode p_397286_) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        p_397394_.forEveryBlockInStructure(p_397203_ -> {
            BlockState blockstate = p_397394_.getBlockState((BlockPos)p_397203_);
            if (blockstate.is(Blocks.TEST_BLOCK) && blockstate.getValue(TestBlock.MODE) == p_397286_) {
                list.add(p_397203_.immutable());
            }
        });
        return list;
    }

    public MapCodec<BlockBasedTestInstance> codec() {
        return CODEC;
    }

    @Override
    protected MutableComponent typeDescription() {
        return Component.translatable("test_instance.type.block_based");
    }
}

